/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.store.IndexInput;

public class InputStreamIndexInput
extends InputStream {
    private final IndexInput indexInput;
    private final long limit;
    private final long actualSizeToRead;
    private long counter = 0L;
    private long markPointer;
    private long markCounter;

    public InputStreamIndexInput(IndexInput indexInput, long limit2) {
        this.indexInput = indexInput;
        this.limit = limit2;
        this.actualSizeToRead = indexInput.length() - indexInput.getFilePointer() > limit2 ? limit2 : indexInput.length() - indexInput.getFilePointer();
    }

    public long actualSizeToRead() {
        return this.actualSizeToRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.indexInput.getFilePointer() >= this.indexInput.length()) {
            return -1;
        }
        if (this.indexInput.getFilePointer() + (long)len > this.indexInput.length()) {
            len = (int)(this.indexInput.length() - this.indexInput.getFilePointer());
        }
        if (this.counter + (long)len > this.limit) {
            len = (int)(this.limit - this.counter);
        }
        if (len <= 0) {
            return -1;
        }
        this.indexInput.readBytes(b, off, len, false);
        this.counter += (long)len;
        return len;
    }

    @Override
    public int read() throws IOException {
        if (this.counter++ >= this.limit) {
            return -1;
        }
        return this.indexInput.getFilePointer() < this.indexInput.length() ? this.indexInput.readByte() & 0xFF : -1;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markPointer = this.indexInput.getFilePointer();
        this.markCounter = this.counter;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.indexInput.seek(this.markPointer);
        this.counter = this.markCounter;
    }
}

