/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.XTermsFilter;
import org.elasticsearch.common.geo.GeoShapeConstants;
import org.elasticsearch.common.geo.ShapeBuilder;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.lucene.spatial.SpatialStrategy;
import org.elasticsearch.common.lucene.spatial.prefix.tree.Node;
import org.elasticsearch.common.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.elasticsearch.index.mapper.FieldMapper;

public class TermQueryPrefixTreeStrategy
extends SpatialStrategy {
    private static final double WITHIN_BUFFER_DISTANCE = 0.5;
    private static final BufferParameters BUFFER_PARAMETERS = new BufferParameters(3, 3);

    public TermQueryPrefixTreeStrategy(FieldMapper.Names fieldName, SpatialPrefixTree prefixTree, double distanceErrorPct) {
        super(fieldName, prefixTree, distanceErrorPct);
    }

    @Override
    public Filter createIntersectsFilter(Shape shape) {
        int detailLevel = this.getPrefixTree().getLevelForDistance(this.calcDistanceFromErrPct(shape, this.getDistanceErrorPct(), GeoShapeConstants.SPATIAL_CONTEXT));
        List<Node> nodes = this.getPrefixTree().getNodes(shape, detailLevel, false);
        Term[] nodeTerms = new Term[nodes.size()];
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            nodeTerms[i2] = this.getFieldName().createIndexNameTerm(nodes.get(i2).getTokenString());
        }
        return new XTermsFilter(nodeTerms);
    }

    @Override
    public Query createIntersectsQuery(Shape shape) {
        int detailLevel = this.getPrefixTree().getLevelForDistance(this.calcDistanceFromErrPct(shape, this.getDistanceErrorPct(), GeoShapeConstants.SPATIAL_CONTEXT));
        List<Node> nodes = this.getPrefixTree().getNodes(shape, detailLevel, false);
        BooleanQuery query = new BooleanQuery();
        for (Node node : nodes) {
            query.add(new TermQuery(this.getFieldName().createIndexNameTerm(node.getTokenString())), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery(query);
    }

    @Override
    public Filter createDisjointFilter(Shape shape) {
        int detailLevel = this.getPrefixTree().getLevelForDistance(this.calcDistanceFromErrPct(shape, this.getDistanceErrorPct(), GeoShapeConstants.SPATIAL_CONTEXT));
        List<Node> nodes = this.getPrefixTree().getNodes(shape, detailLevel, false);
        XBooleanFilter filter = new XBooleanFilter();
        for (Node node : nodes) {
            filter.addNot(new TermFilter(this.getFieldName().createIndexNameTerm(node.getTokenString())));
        }
        return filter;
    }

    @Override
    public Query createDisjointQuery(Shape shape) {
        int detailLevel = this.getPrefixTree().getLevelForDistance(this.calcDistanceFromErrPct(shape, this.getDistanceErrorPct(), GeoShapeConstants.SPATIAL_CONTEXT));
        List<Node> nodes = this.getPrefixTree().getNodes(shape, detailLevel, false);
        BooleanQuery query = new BooleanQuery();
        query.add(new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        for (Node node : nodes) {
            query.add(new TermQuery(this.getFieldName().createIndexNameTerm(node.getTokenString())), BooleanClause.Occur.MUST_NOT);
        }
        return new ConstantScoreQuery(query);
    }

    @Override
    public Filter createWithinFilter(Shape shape) {
        Filter intersectsFilter = this.createIntersectsFilter(shape);
        Geometry shapeGeometry = ShapeBuilder.toJTSGeometry(shape);
        Geometry buffer = BufferOp.bufferOp(shapeGeometry, 0.5, BUFFER_PARAMETERS);
        JtsGeometry bufferedShape = new JtsGeometry(buffer.difference(shapeGeometry), GeoShapeConstants.SPATIAL_CONTEXT, true);
        Filter bufferedFilter = this.createIntersectsFilter(bufferedShape);
        XBooleanFilter filter = new XBooleanFilter();
        filter.addShould(intersectsFilter);
        filter.addNot(bufferedFilter);
        return filter;
    }

    @Override
    public Query createWithinQuery(Shape shape) {
        Query intersectsQuery = this.createIntersectsQuery(shape);
        Geometry shapeGeometry = ShapeBuilder.toJTSGeometry(shape);
        Geometry buffer = BufferOp.bufferOp(shapeGeometry, 0.5, BUFFER_PARAMETERS);
        JtsGeometry bufferedShape = new JtsGeometry(buffer.difference(shapeGeometry), GeoShapeConstants.SPATIAL_CONTEXT, true);
        Query bufferedQuery = this.createIntersectsQuery(bufferedShape);
        BooleanQuery query = new BooleanQuery();
        query.add(intersectsQuery, BooleanClause.Occur.SHOULD);
        query.add(bufferedQuery, BooleanClause.Occur.MUST_NOT);
        return new ConstantScoreQuery(query);
    }
}

