/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.lucene.all.AllEntries;
import org.elasticsearch.common.lucene.all.AllTokenStream;

public class AllField
extends AbstractField {
    private final AllEntries allEntries;
    private final Analyzer analyzer;

    public AllField(String name2, Field.Store store, Field.TermVector termVector, AllEntries allEntries, Analyzer analyzer) {
        super(name2, store, Field.Index.ANALYZED, termVector);
        this.allEntries = allEntries;
        this.analyzer = analyzer;
    }

    @Override
    public String stringValue() {
        if (this.isStored()) {
            return this.allEntries.buildText();
        }
        return null;
    }

    @Override
    public Reader readerValue() {
        return null;
    }

    @Override
    public TokenStream tokenStreamValue() {
        try {
            this.allEntries.reset();
            return AllTokenStream.allTokenStream(this.name, this.allEntries, this.analyzer);
        }
        catch (IOException e) {
            throw new ElasticSearchException("Failed to create token stream");
        }
    }
}

