/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.lucene.FieldBuilder;
import org.elasticsearch.common.lucene.uid.UidField;

public class DocumentBuilder {
    public static final Document EMPTY = new Document();
    private final Document document = new Document();

    public static DocumentBuilder doc() {
        return new DocumentBuilder();
    }

    public static Fieldable uidField(String value2) {
        return DocumentBuilder.uidField(value2, 0L);
    }

    public static Fieldable uidField(String value2, long version) {
        return new UidField("_uid", value2, version);
    }

    public static FieldBuilder field(String name2, String value2) {
        return DocumentBuilder.field(name2, value2, Field.Store.YES, Field.Index.ANALYZED);
    }

    public static FieldBuilder field(String name2, String value2, Field.Store store, Field.Index index2) {
        return new FieldBuilder(name2, value2, store, index2);
    }

    public static FieldBuilder field(String name2, String value2, Field.Store store, Field.Index index2, Field.TermVector termVector) {
        return new FieldBuilder(name2, value2, store, index2, termVector);
    }

    public static FieldBuilder field(String name2, byte[] value2, Field.Store store) {
        return new FieldBuilder(name2, value2, store);
    }

    public static FieldBuilder field(String name2, byte[] value2, int offset2, int length2, Field.Store store) {
        return new FieldBuilder(name2, value2, offset2, length2, store);
    }

    private DocumentBuilder() {
    }

    public DocumentBuilder boost(float boost) {
        this.document.setBoost(boost);
        return this;
    }

    public DocumentBuilder add(Fieldable field2) {
        this.document.add(field2);
        return this;
    }

    public DocumentBuilder add(FieldBuilder fieldBuilder) {
        this.document.add(fieldBuilder.build());
        return this;
    }

    public Document build() {
        return this.document;
    }
}

