/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.support;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;

public abstract class AbstractESLogger
implements ESLogger {
    private final String prefix;

    protected AbstractESLogger(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void trace(String msg, Object ... params2) {
        if (this.isTraceEnabled()) {
            this.internalTrace(LoggerMessageFormat.format(this.prefix, msg, params2));
        }
    }

    protected abstract void internalTrace(String var1);

    @Override
    public void trace(String msg, Throwable cause2, Object ... params2) {
        if (this.isTraceEnabled()) {
            this.internalTrace(LoggerMessageFormat.format(this.prefix, msg, params2), cause2);
        }
    }

    protected abstract void internalTrace(String var1, Throwable var2);

    @Override
    public void debug(String msg, Object ... params2) {
        if (this.isDebugEnabled()) {
            this.internalDebug(LoggerMessageFormat.format(this.prefix, msg, params2));
        }
    }

    protected abstract void internalDebug(String var1);

    @Override
    public void debug(String msg, Throwable cause2, Object ... params2) {
        if (this.isDebugEnabled()) {
            this.internalDebug(LoggerMessageFormat.format(this.prefix, msg, params2), cause2);
        }
    }

    protected abstract void internalDebug(String var1, Throwable var2);

    @Override
    public void info(String msg, Object ... params2) {
        if (this.isInfoEnabled()) {
            this.internalInfo(LoggerMessageFormat.format(this.prefix, msg, params2));
        }
    }

    protected abstract void internalInfo(String var1);

    @Override
    public void info(String msg, Throwable cause2, Object ... params2) {
        if (this.isInfoEnabled()) {
            this.internalInfo(LoggerMessageFormat.format(this.prefix, msg, params2), cause2);
        }
    }

    protected abstract void internalInfo(String var1, Throwable var2);

    @Override
    public void warn(String msg, Object ... params2) {
        if (this.isWarnEnabled()) {
            this.internalWarn(LoggerMessageFormat.format(this.prefix, msg, params2));
        }
    }

    protected abstract void internalWarn(String var1);

    @Override
    public void warn(String msg, Throwable cause2, Object ... params2) {
        if (this.isWarnEnabled()) {
            this.internalWarn(LoggerMessageFormat.format(this.prefix, msg, params2), cause2);
        }
    }

    protected abstract void internalWarn(String var1, Throwable var2);

    @Override
    public void error(String msg, Object ... params2) {
        if (this.isErrorEnabled()) {
            this.internalError(LoggerMessageFormat.format(this.prefix, msg, params2));
        }
    }

    protected abstract void internalError(String var1);

    @Override
    public void error(String msg, Throwable cause2, Object ... params2) {
        if (this.isErrorEnabled()) {
            this.internalError(LoggerMessageFormat.format(this.prefix, msg, params2), cause2);
        }
    }

    protected abstract void internalError(String var1, Throwable var2);
}

