/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;

public class DateMathParser {
    private final FormatDateTimeFormatter dateTimeFormatter;
    private final TimeUnit timeUnit;

    public DateMathParser(FormatDateTimeFormatter dateTimeFormatter, TimeUnit timeUnit) {
        this.dateTimeFormatter = dateTimeFormatter;
        this.timeUnit = timeUnit;
    }

    public long parse(String text, long now) {
        return this.parse(text, now, false, false);
    }

    public long parseUpperInclusive(String text, long now) {
        return this.parse(text, now, true, true);
    }

    public long parse(String text, long now, boolean roundUp, boolean upperInclusive) {
        String mathString;
        long time;
        if (text.startsWith("now")) {
            time = now;
            mathString = text.substring("now".length());
        } else {
            String parseString;
            int index2 = text.indexOf("||");
            if (index2 == -1) {
                parseString = text;
                mathString = "";
            } else {
                parseString = text.substring(0, index2);
                mathString = text.substring(index2 + 2);
            }
            time = upperInclusive ? this.parseUpperInclusiveStringValue(parseString) : this.parseStringValue(parseString);
        }
        if (mathString.isEmpty()) {
            return time;
        }
        return this.parseMath(mathString, time, roundUp);
    }

    private long parseMath(String mathString, long time, boolean roundUp) throws ElasticSearchParseException {
        MutableDateTime dateTime = new MutableDateTime(time, DateTimeZone.UTC);
        try {
            int i2 = 0;
            block10: while (i2 < mathString.length()) {
                int num;
                int type2;
                char c;
                if ((c = mathString.charAt(i2++)) == '/') {
                    type2 = 0;
                } else if (c == '+') {
                    type2 = 1;
                } else if (c == '-') {
                    type2 = 2;
                } else {
                    throw new ElasticSearchParseException("operator not supported for date math [" + mathString + "]");
                }
                if (!Character.isDigit(mathString.charAt(i2))) {
                    num = 1;
                } else {
                    int numFrom = i2;
                    while (Character.isDigit(mathString.charAt(i2))) {
                        ++i2;
                    }
                    num = Integer.parseInt(mathString.substring(numFrom, i2));
                }
                if (type2 == 0 && num != 1) {
                    throw new ElasticSearchParseException("rounding `/` can only be used on single unit types [" + mathString + "]");
                }
                char unit = mathString.charAt(i2++);
                switch (unit) {
                    case 'M': {
                        if (type2 == 0) {
                            if (roundUp) {
                                dateTime.monthOfYear().roundCeiling();
                                continue block10;
                            }
                            dateTime.monthOfYear().roundFloor();
                            continue block10;
                        }
                        if (type2 == 1) {
                            dateTime.addMonths(num);
                            continue block10;
                        }
                        if (type2 != 2) continue block10;
                        dateTime.addMonths(-num);
                        continue block10;
                    }
                    case 'w': {
                        if (type2 == 0) {
                            if (roundUp) {
                                dateTime.weekOfWeekyear().roundCeiling();
                                continue block10;
                            }
                            dateTime.weekOfWeekyear().roundFloor();
                            continue block10;
                        }
                        if (type2 == 1) {
                            dateTime.addWeeks(num);
                            continue block10;
                        }
                        if (type2 != 2) continue block10;
                        dateTime.addWeeks(-num);
                        continue block10;
                    }
                    case 'd': {
                        if (type2 == 0) {
                            if (roundUp) {
                                dateTime.dayOfMonth().roundCeiling();
                                continue block10;
                            }
                            dateTime.dayOfMonth().roundFloor();
                            continue block10;
                        }
                        if (type2 == 1) {
                            dateTime.addDays(num);
                            continue block10;
                        }
                        if (type2 != 2) continue block10;
                        dateTime.addDays(-num);
                        continue block10;
                    }
                    case 'H': 
                    case 'h': {
                        if (type2 == 0) {
                            if (roundUp) {
                                dateTime.hourOfDay().roundCeiling();
                                continue block10;
                            }
                            dateTime.hourOfDay().roundFloor();
                            continue block10;
                        }
                        if (type2 == 1) {
                            dateTime.addHours(num);
                            continue block10;
                        }
                        if (type2 != 2) continue block10;
                        dateTime.addHours(-num);
                        continue block10;
                    }
                    case 'm': {
                        if (type2 == 0) {
                            if (roundUp) {
                                dateTime.minuteOfHour().roundCeiling();
                                continue block10;
                            }
                            dateTime.minuteOfHour().roundFloor();
                            continue block10;
                        }
                        if (type2 == 1) {
                            dateTime.addMinutes(num);
                            continue block10;
                        }
                        if (type2 != 2) continue block10;
                        dateTime.addMinutes(-num);
                        continue block10;
                    }
                    case 's': {
                        if (type2 == 0) {
                            if (roundUp) {
                                dateTime.secondOfMinute().roundCeiling();
                                continue block10;
                            }
                            dateTime.secondOfMinute().roundFloor();
                            continue block10;
                        }
                        if (type2 == 1) {
                            dateTime.addSeconds(num);
                            continue block10;
                        }
                        if (type2 != 2) continue block10;
                        dateTime.addSeconds(-num);
                        continue block10;
                    }
                }
                throw new ElasticSearchParseException("unit [" + unit + "] not supported for date math [" + mathString + "]");
            }
        }
        catch (Exception e) {
            if (e instanceof ElasticSearchParseException) {
                throw (ElasticSearchParseException)e;
            }
            throw new ElasticSearchParseException("failed to parse date math [" + mathString + "]");
        }
        return dateTime.getMillis();
    }

    private long parseStringValue(String value2) {
        try {
            return this.dateTimeFormatter.parser().parseMillis(value2);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value2);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new ElasticSearchParseException("failed to parse date field [" + value2 + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }

    private long parseUpperInclusiveStringValue(String value2) {
        try {
            MutableDateTime dateTime = new MutableDateTime(1970, 1, 1, 23, 59, 59, 999, DateTimeZone.UTC);
            int location = this.dateTimeFormatter.parser().parseInto(dateTime, value2, 0);
            if (location == value2.length()) {
                return dateTime.getMillis();
            }
            if (location <= 0 || dateTime.getYear() > 5000) {
                try {
                    long time = Long.parseLong(value2);
                    return this.timeUnit.toMillis(time);
                }
                catch (NumberFormatException e1) {
                    throw new ElasticSearchParseException("failed to parse date field [" + value2 + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number");
                }
            }
            return dateTime.getMillis();
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value2);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new ElasticSearchParseException("failed to parse date field [" + value2 + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }
}

