/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.smile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.PrettyPrinter;
import org.elasticsearch.common.jackson.core.SerializableString;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.base.GeneratorBase;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.core.json.JsonWriteContext;
import org.elasticsearch.common.jackson.dataformat.smile.ModuleVersion;
import org.elasticsearch.common.jackson.dataformat.smile.SmileBufferRecycler;
import org.elasticsearch.common.jackson.dataformat.smile.SmileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmileGenerator
extends GeneratorBase {
    private static final int MIN_BUFFER_LENGTH = 770;
    protected static final byte TOKEN_BYTE_LONG_STRING_ASCII = -32;
    protected static final byte TOKEN_BYTE_INT_32 = 36;
    protected static final byte TOKEN_BYTE_INT_64 = 37;
    protected static final byte TOKEN_BYTE_BIG_INTEGER = 38;
    protected static final byte TOKEN_BYTE_FLOAT_32 = 40;
    protected static final byte TOKEN_BYTE_FLOAT_64 = 41;
    protected static final byte TOKEN_BYTE_BIG_DECIMAL = 42;
    protected static final int SURR1_FIRST = 55296;
    protected static final int SURR1_LAST = 56319;
    protected static final int SURR2_FIRST = 56320;
    protected static final int SURR2_LAST = 57343;
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected final IOContext _ioContext;
    protected final OutputStream _out;
    protected int _smileFeatures;
    protected final SmileBufferRecycler<SharedStringNode> _smileBufferRecycler;
    protected byte[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected int _bytesWritten;
    protected SharedStringNode[] _seenNames;
    protected int _seenNameCount;
    protected SharedStringNode[] _seenStringValues;
    protected int _seenStringValueCount;
    protected boolean _bufferRecyclable;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<SharedStringNode>>> _smileRecyclerRef = new ThreadLocal();

    public SmileGenerator(IOContext ctxt, int jsonFeatures, int smileFeatures, ObjectCodec codec, OutputStream out) {
        super(jsonFeatures, codec);
        this._smileFeatures = smileFeatures;
        this._ioContext = ctxt;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = out;
        this._bufferRecyclable = true;
        this._outputBuffer = ctxt.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._charBuffer = ctxt.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least " + 770);
        }
        if ((smileFeatures & Feature.CHECK_SHARED_NAMES.getMask()) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if ((smileFeatures & Feature.CHECK_SHARED_STRING_VALUES.getMask()) == 0) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
        } else {
            this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (this._seenStringValues == null) {
                this._seenStringValues = new SharedStringNode[64];
            }
            this._seenStringValueCount = 0;
        }
    }

    public SmileGenerator(IOContext ctxt, int jsonFeatures, int smileFeatures, ObjectCodec codec, OutputStream out, byte[] outputBuffer, int offset2, boolean bufferRecyclable) {
        super(jsonFeatures, codec);
        this._smileFeatures = smileFeatures;
        this._ioContext = ctxt;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = out;
        this._bufferRecyclable = bufferRecyclable;
        this._outputTail = offset2;
        this._outputBuffer = outputBuffer;
        this._outputEnd = this._outputBuffer.length;
        this._charBuffer = ctxt.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least " + 770);
        }
        if ((smileFeatures & Feature.CHECK_SHARED_NAMES.getMask()) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if ((smileFeatures & Feature.CHECK_SHARED_STRING_VALUES.getMask()) == 0) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
        } else {
            this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (this._seenStringValues == null) {
                this._seenStringValues = new SharedStringNode[64];
            }
            this._seenStringValueCount = 0;
        }
    }

    public void writeHeader() throws IOException {
        int last2 = 0;
        if ((this._smileFeatures & Feature.CHECK_SHARED_NAMES.getMask()) != 0) {
            last2 |= 1;
        }
        if ((this._smileFeatures & Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
            last2 |= 2;
        }
        if ((this._smileFeatures & Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
            last2 |= 4;
        }
        this._writeBytes((byte)58, (byte)41, (byte)10, (byte)last2);
    }

    protected static final SmileBufferRecycler<SharedStringNode> _smileBufferRecycler() {
        SmileBufferRecycler<SharedStringNode> br;
        SoftReference<SmileBufferRecycler<SharedStringNode>> ref = _smileRecyclerRef.get();
        SmileBufferRecycler<SharedStringNode> smileBufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<SharedStringNode>>(br));
        }
        return br;
    }

    @Override
    public Version version() {
        return ModuleVersion.instance.version();
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._out;
    }

    @Override
    public final void writeFieldName(String name2) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(name2) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name2);
    }

    @Override
    public final void writeFieldName(SerializableString name2) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(name2.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name2);
    }

    @Override
    public final void writeStringField(String fieldName, String value2) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(fieldName);
        this.writeString(value2);
    }

    public SmileGenerator enable(Feature f) {
        this._smileFeatures |= f.getMask();
        return this;
    }

    public SmileGenerator disable(Feature f) {
        this._smileFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._smileFeatures & f.getMask()) != 0;
    }

    public SmileGenerator configure(Feature f, boolean state2) {
        if (state2) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public void writeRaw(byte b) throws IOException, JsonGenerationException {
        this._writeByte((byte)-8);
    }

    public void writeBytes(byte[] data2, int offset2, int len) throws IOException {
        this._writeBytes(data2, offset2, len);
    }

    @Override
    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._writeByte((byte)-7);
        this._writeContext = this._writeContext.getParent();
    }

    @Override
    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writeByte((byte)-6);
    }

    @Override
    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._writeByte((byte)-5);
    }

    private final void _writeFieldName(String name2) throws IOException, JsonGenerationException {
        int typeToken;
        int ix;
        int len = name2.length();
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (ix = this._findSeenName(name2)) >= 0) {
            this._writeSharedNameReference(ix);
            return;
        }
        if (len > 56) {
            this._writeNonShortFieldName(name2, len);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        name2.getChars(0, len, this._charBuffer, 0);
        int origOffset = this._outputTail++;
        int byteLen = this._shortUTF8Encode(this._charBuffer, 0, len);
        if (byteLen == len) {
            if (byteLen <= 64) {
                typeToken = (byte)(127 + byteLen);
            } else {
                typeToken = 52;
                this._outputBuffer[this._outputTail++] = -4;
            }
        } else if (byteLen <= 56) {
            typeToken = (byte)(190 + byteLen);
        } else {
            typeToken = 52;
            this._outputBuffer[this._outputTail++] = -4;
        }
        this._outputBuffer[origOffset] = typeToken;
        if (this._seenNameCount >= 0) {
            this._addSeenName(name2);
        }
    }

    private final void _writeNonShortFieldName(String name2, int len) throws IOException, JsonGenerationException {
        this._writeByte((byte)52);
        if (len > this._charBufferLength) {
            this._slowUTF8Encode(name2);
        } else {
            name2.getChars(0, len, this._charBuffer, 0);
            int maxLen = len + len + len;
            if (maxLen <= this._outputBuffer.length) {
                if (this._outputTail + maxLen >= this._outputEnd) {
                    this._flushBuffer();
                }
                this._shortUTF8Encode(this._charBuffer, 0, len);
            } else {
                this._mediumUTF8Encode(this._charBuffer, 0, len);
            }
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(name2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldName(SerializableString name2) throws IOException, JsonGenerationException {
        int ix;
        int charLen = name2.charLength();
        if (charLen == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (ix = this._findSeenName(name2.getValue())) >= 0) {
            this._writeSharedNameReference(ix);
            return;
        }
        byte[] bytes2 = name2.asUnquotedUTF8();
        int byteLen = bytes2.length;
        if (byteLen != charLen) {
            this._writeFieldNameUnicode(name2, bytes2);
            return;
        }
        if (byteLen <= 64) {
            if (this._outputTail + byteLen >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(127 + byteLen);
            System.arraycopy(bytes2, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
        } else {
            this._writeLongAsciiFieldName(bytes2);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(name2.getValue());
        }
    }

    private final void _writeLongAsciiFieldName(byte[] bytes2) throws IOException, JsonGenerationException {
        int byteLen = bytes2.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + byteLen + 1 < this._outputEnd) {
            System.arraycopy(bytes2, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
        } else {
            this._flushBuffer();
            if (byteLen < 770) {
                System.arraycopy(bytes2, 0, this._outputBuffer, this._outputTail, byteLen);
                this._outputTail += byteLen;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(bytes2, 0, byteLen);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldNameUnicode(SerializableString name2, byte[] bytes2) throws IOException, JsonGenerationException {
        int byteLen = bytes2.length;
        if (byteLen <= 56) {
            if (this._outputTail + byteLen >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(190 + byteLen);
            System.arraycopy(bytes2, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
            if (this._seenNameCount >= 0) {
                this._addSeenName(name2.getValue());
            }
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + byteLen + 1 < this._outputEnd) {
            System.arraycopy(bytes2, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
        } else {
            this._flushBuffer();
            if (byteLen < 770) {
                System.arraycopy(bytes2, 0, this._outputBuffer, this._outputTail, byteLen);
                this._outputTail += byteLen;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(bytes2, 0, byteLen);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
        if (this._seenNameCount >= 0) {
            this._addSeenName(name2.getValue());
        }
    }

    private final void _writeSharedNameReference(int ix) throws IOException, JsonGenerationException {
        if (ix >= this._seenNameCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared name with index " + ix + "; but have only seen " + this._seenNameCount + " so far!");
        }
        if (ix < 64) {
            this._writeByte((byte)(64 + ix));
        } else {
            this._writeBytes((byte)(48 + (ix >> 8)), (byte)ix);
        }
    }

    @Override
    public void writeString(String text) throws IOException, JsonGenerationException {
        int ix;
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        int len = text.length();
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (len > 65) {
            this._writeNonSharedString(text, len);
            return;
        }
        if (this._seenStringValueCount >= 0 && (ix = this._findSeenStringValue(text)) >= 0) {
            this._writeSharedStringValueReference(ix);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        text.getChars(0, len, this._charBuffer, 0);
        int origOffset = this._outputTail++;
        int byteLen = this._shortUTF8Encode(this._charBuffer, 0, len);
        if (byteLen <= 64) {
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(text);
            }
            this._outputBuffer[origOffset] = byteLen == len ? (byte)(63 + byteLen) : (byte)(126 + byteLen);
        } else {
            this._outputBuffer[origOffset] = byteLen == len ? -32 : -28;
            this._outputBuffer[this._outputTail++] = -4;
        }
    }

    private final void _writeSharedStringValueReference(int ix) throws IOException, JsonGenerationException {
        if (ix >= this._seenStringValueCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared String value with index " + ix + "; but have only seen " + this._seenStringValueCount + " so far!");
        }
        if (ix < 31) {
            this._writeByte((byte)(1 + ix));
        } else {
            this._writeBytes((byte)(236 + (ix >> 8)), (byte)ix);
        }
    }

    private final void _writeNonSharedString(String text, int len) throws IOException, JsonGenerationException {
        if (len > this._charBufferLength) {
            this._writeByte((byte)-28);
            this._slowUTF8Encode(text);
            this._writeByte((byte)-4);
            return;
        }
        text.getChars(0, len, this._charBuffer, 0);
        int maxLen = len + len + len + 2;
        if (maxLen > this._outputBuffer.length) {
            this._writeByte((byte)-28);
            this._mediumUTF8Encode(this._charBuffer, 0, len);
            this._writeByte((byte)-4);
            return;
        }
        if (this._outputTail + maxLen >= this._outputEnd) {
            this._flushBuffer();
        }
        int origOffset = this._outputTail;
        this._writeByte((byte)-32);
        int byteLen = this._shortUTF8Encode(this._charBuffer, 0, len);
        if (byteLen > len) {
            this._outputBuffer[origOffset] = -28;
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    @Override
    public void writeString(char[] text, int offset2, int len) throws IOException, JsonGenerationException {
        if (len <= 65 && this._seenStringValueCount >= 0 && len > 0) {
            this.writeString(new String(text, offset2, len));
            return;
        }
        this._verifyValueWrite("write String value");
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (len <= 64) {
            int typeToken;
            if (this._outputTail + 196 >= this._outputEnd) {
                this._flushBuffer();
            }
            int origOffset = this._outputTail++;
            int byteLen = this._shortUTF8Encode(text, offset2, offset2 + len);
            if (byteLen <= 64) {
                typeToken = byteLen == len ? (int)((byte)(63 + byteLen)) : (int)((byte)(126 + byteLen));
            } else {
                typeToken = -28;
                this._outputBuffer[this._outputTail++] = -4;
            }
            this._outputBuffer[origOffset] = typeToken;
        } else {
            int maxLen = len + len + len + 2;
            if (maxLen <= this._outputBuffer.length) {
                if (this._outputTail + maxLen >= this._outputEnd) {
                    this._flushBuffer();
                }
                int origOffset = this._outputTail;
                this._writeByte((byte)-28);
                int byteLen = this._shortUTF8Encode(text, offset2, offset2 + len);
                if (byteLen == len) {
                    this._outputBuffer[origOffset] = -32;
                }
                this._outputBuffer[this._outputTail++] = -4;
            } else {
                this._writeByte((byte)-28);
                this._mediumUTF8Encode(text, offset2, offset2 + len);
                this._writeByte((byte)-4);
            }
        }
    }

    @Override
    public final void writeString(SerializableString sstr) throws IOException, JsonGenerationException {
        int ix;
        this._verifyValueWrite("write String value");
        String str = sstr.getValue();
        int len = str.length();
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (len <= 65 && this._seenStringValueCount >= 0 && (ix = this._findSeenStringValue(str)) >= 0) {
            this._writeSharedStringValueReference(ix);
            return;
        }
        byte[] raw = sstr.asUnquotedUTF8();
        int byteLen = raw.length;
        if (byteLen <= 64) {
            if (this._outputTail + byteLen + 1 >= this._outputEnd) {
                this._flushBuffer();
            }
            int typeToken = byteLen == len ? 63 + byteLen : 126 + byteLen;
            this._outputBuffer[this._outputTail++] = (byte)typeToken;
            System.arraycopy(raw, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(sstr.getValue());
            }
        } else {
            byte typeToken = byteLen == len ? (byte)-32 : -28;
            this._writeByte(typeToken);
            this._writeBytes(raw, 0, raw.length);
            this._writeByte((byte)-4);
        }
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset2, int len) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenStringValueCount >= 0) {
            throw new UnsupportedOperationException("Can not use direct UTF-8 write methods when 'Feature.CHECK_SHARED_STRING_VALUES' enabled");
        }
        if (len <= 65) {
            if (this._outputTail + len >= this._outputEnd) {
                this._flushBuffer();
            }
            if (len == 1) {
                this._outputBuffer[this._outputTail++] = 64;
                this._outputBuffer[this._outputTail++] = text[offset2];
            } else {
                this._outputBuffer[this._outputTail++] = (byte)(126 + len);
                System.arraycopy(text, offset2, this._outputBuffer, this._outputTail, len);
                this._outputTail += len;
            }
        } else {
            int maxLen = len + len + len + 2;
            if (maxLen <= this._outputBuffer.length) {
                if (this._outputTail + maxLen >= this._outputEnd) {
                    this._flushBuffer();
                }
                this._outputBuffer[this._outputTail++] = -28;
                System.arraycopy(text, offset2, this._outputBuffer, this._outputTail, len);
                this._outputTail += len;
                this._outputBuffer[this._outputTail++] = -4;
            } else {
                this._writeByte((byte)-28);
                this._writeBytes(text, offset2, len);
                this._writeByte((byte)-4);
            }
        }
    }

    @Override
    public final void writeUTF8String(byte[] text, int offset2, int len) throws IOException, JsonGenerationException {
        this.writeRawUTF8String(text, offset2, len);
    }

    @Override
    public void writeRaw(String text) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(String text, int offset2, int len) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char[] text, int offset2, int len) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String text) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String text, int offset2, int len) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(char[] text, int offset2, int len) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeBinary(Base64Variant b64variant, byte[] data2, int offset2, int len) throws IOException, JsonGenerationException {
        if (data2 == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            this._write7BitBinaryWithLength(data2, offset2, len);
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(len);
            this._writeBytes(data2, offset2, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBinary(InputStream data2, int dataLength) throws IOException, JsonGenerationException {
        int missing;
        if (dataLength < 0) {
            throw new UnsupportedOperationException("Must pass actual length for Smile encoded data");
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            byte[] encodingBuffer = this._ioContext.allocBase64Buffer();
            try {
                missing = this._write7BitBinaryWithLength(data2, dataLength, encodingBuffer);
            }
            finally {
                this._ioContext.releaseBase64Buffer(encodingBuffer);
            }
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(dataLength);
            missing = this._writeBytes(data2, dataLength);
        }
        if (missing > 0) {
            this._reportError("Too few bytes available: missing " + missing + " bytes (out of " + dataLength + ")");
        }
        return dataLength;
    }

    @Override
    public int writeBinary(Base64Variant b64variant, InputStream data2, int dataLength) throws IOException, JsonGenerationException {
        return this.writeBinary(data2, dataLength);
    }

    @Override
    public void writeBoolean(boolean state2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        if (state2) {
            this._writeByte((byte)35);
        } else {
            this._writeByte((byte)34);
        }
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeByte((byte)33);
    }

    @Override
    public void writeNumber(int i2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        i2 = SmileUtil.zigzagEncode(i2);
        if (i2 <= 63 && i2 >= 0) {
            if (i2 <= 31) {
                this._writeByte((byte)(192 + i2));
                return;
            }
            this._writeBytes((byte)36, (byte)(128 + i2));
            return;
        }
        byte b0 = (byte)(128 + (i2 & 0x3F));
        if ((i2 >>>= 6) <= 127) {
            this._writeBytes((byte)36, (byte)i2, b0);
            return;
        }
        byte b1 = (byte)(i2 & 0x7F);
        if ((i2 >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)i2, b1, b0);
            return;
        }
        byte b2 = (byte)(i2 & 0x7F);
        if ((i2 >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)i2, b2, b1, b0);
            return;
        }
        byte b3 = (byte)(i2 & 0x7F);
        this._writeBytes((byte)36, (byte)(i2 >> 7), b3, b2, b1, b0);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        l = SmileUtil.zigzagEncode(l);
        int i2 = (int)l;
        byte b0 = (byte)(128 + (i2 & 0x3F));
        byte b1 = (byte)(i2 >> 6 & 0x7F);
        byte b2 = (byte)(i2 >> 13 & 0x7F);
        byte b3 = (byte)(i2 >> 20 & 0x7F);
        byte b4 = (byte)((int)(l >>>= 27) & 0x7F);
        i2 = (int)(l >> 7);
        if (i2 == 0) {
            this._writeBytes((byte)37, b4, b3, b2, b1, b0);
            return;
        }
        if (i2 <= 127) {
            this._writeBytes((byte)37, (byte)i2);
            this._writeBytes(b4, b3, b2, b1, b0);
            return;
        }
        byte b5 = (byte)(i2 & 0x7F);
        if ((i2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)i2);
            this._writeBytes(b5, b4, b3, b2, b1, b0);
            return;
        }
        byte b6 = (byte)(i2 & 0x7F);
        if ((i2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)i2, b6);
            this._writeBytes(b5, b4, b3, b2, b1, b0);
            return;
        }
        byte b7 = (byte)(i2 & 0x7F);
        if ((i2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)i2, b7, b6);
            this._writeBytes(b5, b4, b3, b2, b1, b0);
            return;
        }
        byte b8 = (byte)(i2 & 0x7F);
        this._writeBytes((byte)37, (byte)(i2 >>= 7), b8, b7, b6);
        this._writeBytes(b5, b4, b3, b2, b1, b0);
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)38);
        byte[] data2 = v.toByteArray();
        this._write7BitBinaryWithLength(data2, 0, data2.length);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._ensureRoomForOutput(11);
        this._verifyValueWrite("write number");
        long l = Double.doubleToRawLongBits(d);
        this._outputBuffer[this._outputTail++] = 41;
        int hi5 = (int)(l >>> 35);
        this._outputBuffer[this._outputTail + 4] = (byte)(hi5 & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((hi5 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((hi5 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((hi5 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)(hi5 >>= 7);
        this._outputTail += 5;
        int mid = (int)(l >> 28);
        this._outputBuffer[this._outputTail++] = (byte)(mid & 0x7F);
        int lo4 = (int)l;
        this._outputBuffer[this._outputTail + 3] = (byte)(lo4 & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((lo4 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((lo4 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((lo4 >>= 7) & 0x7F);
        this._outputTail += 4;
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._ensureRoomForOutput(6);
        this._verifyValueWrite("write number");
        int i2 = Float.floatToRawIntBits(f);
        this._outputBuffer[this._outputTail++] = 40;
        this._outputBuffer[this._outputTail + 4] = (byte)(i2 & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((i2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((i2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((i2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((i2 >>= 7) & 0x7F);
        this._outputTail += 5;
    }

    @Override
    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)42);
        int scale = dec.scale();
        this._writeSignedVInt(scale);
        BigInteger unscaled = dec.unscaledValue();
        byte[] data2 = unscaled.toByteArray();
        this._write7BitBinaryWithLength(data2, 0, data2.length);
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        throw this._notSupported();
    }

    @Override
    protected final void _verifyValueWrite(String typeMsg) throws IOException, JsonGenerationException {
        int status2 = this._writeContext.writeValue();
        if (status2 == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
    }

    @Override
    public final void flush() throws IOException {
        this._flushBuffer();
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext ctxt;
                if ((ctxt = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        boolean wasClosed = this._closed;
        super.close();
        if (!wasClosed && this.isEnabled(Feature.WRITE_END_MARKER)) {
            this._writeByte((byte)-1);
        }
        this._flushBuffer();
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        } else {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    private final int _shortUTF8Encode(char[] str, int i2, int end2) {
        int ptr = this._outputTail;
        byte[] outBuf = this._outputBuffer;
        do {
            char c;
            if ((c = str[i2]) > '\u007f') {
                return this._shortUTF8Encode2(str, i2, end2, ptr);
            }
            outBuf[ptr++] = (byte)c;
        } while (++i2 < end2);
        int codedLen = ptr - this._outputTail;
        this._outputTail = ptr;
        return codedLen;
    }

    private final int _shortUTF8Encode2(char[] str, int i2, int end2, int outputPtr) {
        byte[] outBuf = this._outputBuffer;
        while (i2 < end2) {
            int c;
            if ((c = str[i2++]) <= 127) {
                outBuf[outputPtr++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                outBuf[outputPtr++] = (byte)(0xC0 | c >> 6);
                outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                outBuf[outputPtr++] = (byte)(0xE0 | c >> 12);
                outBuf[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
                outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (i2 >= end2) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._convertSurrogate(c, str[i2++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            outBuf[outputPtr++] = (byte)(0xF0 | c >> 18);
            outBuf[outputPtr++] = (byte)(0x80 | c >> 12 & 0x3F);
            outBuf[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
        }
        int codedLen = outputPtr - this._outputTail;
        this._outputTail = outputPtr;
        return codedLen;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _slowUTF8Encode(String str) throws IOException {
        int len = str.length();
        int inputPtr = 0;
        int bufferEnd = this._outputEnd - 4;
        block0: while (inputPtr < len) {
            int c;
            if (this._outputTail >= bufferEnd) {
                this._flushBuffer();
            }
            if ((c = str.charAt(inputPtr++)) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)c;
                int maxInCount = len - inputPtr;
                int maxOutCount = bufferEnd - this._outputTail;
                if (maxInCount > maxOutCount) {
                    maxInCount = maxOutCount;
                }
                maxInCount += inputPtr;
                while (true) {
                    if (inputPtr >= maxInCount) continue block0;
                    if ((c = (int)str.charAt(inputPtr++)) > 127) break;
                    this._outputBuffer[this._outputTail++] = (byte)c;
                }
            }
            if (c < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | c >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | c >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (inputPtr >= len) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._convertSurrogate(c, str.charAt(inputPtr++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | c >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(char[] str, int inputPtr, int inputEnd) throws IOException {
        int bufferEnd = this._outputEnd - 4;
        block0: while (inputPtr < inputEnd) {
            int c;
            if (this._outputTail >= bufferEnd) {
                this._flushBuffer();
            }
            if ((c = str[inputPtr++]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)c;
                int maxInCount = inputEnd - inputPtr;
                int maxOutCount = bufferEnd - this._outputTail;
                if (maxInCount > maxOutCount) {
                    maxInCount = maxOutCount;
                }
                maxInCount += inputPtr;
                while (true) {
                    if (inputPtr >= maxInCount) continue block0;
                    if ((c = str[inputPtr++]) > 127) break;
                    this._outputBuffer[this._outputTail++] = (byte)c;
                }
            }
            if (c < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | c >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | c >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (inputPtr >= inputEnd) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._convertSurrogate(c, str[inputPtr++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | c >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
        }
        return;
    }

    private int _convertSurrogate(int firstPart, int secondPart) {
        if (secondPart < 56320 || secondPart > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(firstPart) + ", second 0x" + Integer.toHexString(secondPart) + "; illegal combination");
        }
        return 65536 + (firstPart - 55296 << 10) + (secondPart - 56320);
    }

    private void _throwIllegalSurrogate(int code) {
        if (code > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(code) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (code >= 55296) {
            if (code <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(code) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(code) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(code) + ") to output");
    }

    private final void _ensureRoomForOutput(int needed) throws IOException {
        if (this._outputTail + needed >= this._outputEnd) {
            this._flushBuffer();
        }
    }

    private final void _writeByte(byte b) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b;
    }

    private final void _writeBytes(byte b1, byte b2) throws IOException {
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
    }

    private final void _writeBytes(byte b1, byte b2, byte b3) throws IOException {
        if (this._outputTail + 2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
        this._outputBuffer[this._outputTail++] = b3;
    }

    private final void _writeBytes(byte b1, byte b2, byte b3, byte b4) throws IOException {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
        this._outputBuffer[this._outputTail++] = b3;
        this._outputBuffer[this._outputTail++] = b4;
    }

    private final void _writeBytes(byte b1, byte b2, byte b3, byte b4, byte b5) throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
        this._outputBuffer[this._outputTail++] = b3;
        this._outputBuffer[this._outputTail++] = b4;
        this._outputBuffer[this._outputTail++] = b5;
    }

    private final void _writeBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6) throws IOException {
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
        this._outputBuffer[this._outputTail++] = b3;
        this._outputBuffer[this._outputTail++] = b4;
        this._outputBuffer[this._outputTail++] = b5;
        this._outputBuffer[this._outputTail++] = b6;
    }

    private final void _writeBytes(byte[] data2, int offset2, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this._outputTail + len >= this._outputEnd) {
            this._writeBytesLong(data2, offset2, len);
            return;
        }
        System.arraycopy(data2, offset2, this._outputBuffer, this._outputTail, len);
        this._outputTail += len;
    }

    private final int _writeBytes(InputStream in, int bytesLeft) throws IOException {
        while (bytesLeft > 0) {
            int count2;
            int room = this._outputEnd - this._outputTail;
            if (room < 0) {
                this._flushBuffer();
                room = this._outputEnd - this._outputTail;
            }
            if ((count2 = in.read(this._outputBuffer, this._outputTail, room)) < 0) break;
            this._outputTail += count2;
            bytesLeft -= count2;
        }
        return bytesLeft;
    }

    private final void _writeBytesLong(byte[] data2, int offset2, int len) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        while (true) {
            int currLen = Math.min(len, this._outputEnd - this._outputTail);
            System.arraycopy(data2, offset2, this._outputBuffer, this._outputTail, currLen);
            this._outputTail += currLen;
            if ((len -= currLen) == 0) break;
            offset2 += currLen;
            this._flushBuffer();
        }
    }

    private void _writePositiveVInt(int i2) throws IOException {
        this._ensureRoomForOutput(5);
        byte b0 = (byte)(128 + (i2 & 0x3F));
        if ((i2 >>= 6) <= 127) {
            if (i2 > 0) {
                this._outputBuffer[this._outputTail++] = (byte)i2;
            }
            this._outputBuffer[this._outputTail++] = b0;
            return;
        }
        byte b1 = (byte)(i2 & 0x7F);
        if ((i2 >>= 7) <= 127) {
            this._outputBuffer[this._outputTail++] = (byte)i2;
            this._outputBuffer[this._outputTail++] = b1;
            this._outputBuffer[this._outputTail++] = b0;
        } else {
            byte b2 = (byte)(i2 & 0x7F);
            if ((i2 >>= 7) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)i2;
                this._outputBuffer[this._outputTail++] = b2;
                this._outputBuffer[this._outputTail++] = b1;
                this._outputBuffer[this._outputTail++] = b0;
            } else {
                byte b3 = (byte)(i2 & 0x7F);
                this._outputBuffer[this._outputTail++] = (byte)(i2 >> 7);
                this._outputBuffer[this._outputTail++] = b3;
                this._outputBuffer[this._outputTail++] = b2;
                this._outputBuffer[this._outputTail++] = b1;
                this._outputBuffer[this._outputTail++] = b0;
            }
        }
    }

    private void _writeSignedVInt(int input) throws IOException {
        this._writePositiveVInt(SmileUtil.zigzagEncode(input));
    }

    protected void _write7BitBinaryWithLength(byte[] data2, int offset2, int len) throws IOException {
        int i2;
        this._writePositiveVInt(len);
        while (len >= 7) {
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            i2 = data2[offset2++];
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 1 & 0x7F);
            i2 = i2 << 8 | data2[offset2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 2 & 0x7F);
            i2 = i2 << 8 | data2[offset2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 3 & 0x7F);
            i2 = i2 << 8 | data2[offset2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 4 & 0x7F);
            i2 = i2 << 8 | data2[offset2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 5 & 0x7F);
            i2 = i2 << 8 | data2[offset2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 6 & 0x7F);
            i2 = i2 << 8 | data2[offset2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(i2 & 0x7F);
            len -= 7;
        }
        if (len > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            i2 = data2[offset2++];
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 1 & 0x7F);
            if (len > 1) {
                i2 = (i2 & 1) << 8 | data2[offset2++] & 0xFF;
                this._outputBuffer[this._outputTail++] = (byte)(i2 >> 2 & 0x7F);
                if (len > 2) {
                    i2 = (i2 & 3) << 8 | data2[offset2++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(i2 >> 3 & 0x7F);
                    if (len > 3) {
                        i2 = (i2 & 7) << 8 | data2[offset2++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(i2 >> 4 & 0x7F);
                        if (len > 4) {
                            i2 = (i2 & 0xF) << 8 | data2[offset2++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 5 & 0x7F);
                            if (len > 5) {
                                i2 = (i2 & 0x1F) << 8 | data2[offset2++] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(i2 >> 6 & 0x7F);
                                this._outputBuffer[this._outputTail++] = (byte)(i2 & 0x3F);
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(i2 & 0x1F);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(i2 & 0xF);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(i2 & 7);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(i2 & 3);
                }
            } else {
                this._outputBuffer[this._outputTail++] = (byte)(i2 & 1);
            }
        }
    }

    protected int _write7BitBinaryWithLength(InputStream in, int bytesLeft, byte[] buffer) throws IOException {
        int i2;
        this._writePositiveVInt(bytesLeft);
        int inputPtr = 0;
        int inputEnd = 0;
        int lastFullOffset = -7;
        while (bytesLeft >= 7) {
            if (inputPtr > lastFullOffset) {
                inputEnd = this._readMore(in, buffer, inputPtr, inputEnd, bytesLeft);
                inputPtr = 0;
                if (inputEnd < 7) {
                    bytesLeft -= inputEnd;
                    break;
                }
                lastFullOffset = inputEnd - 7;
            }
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            i2 = buffer[inputPtr++];
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 1 & 0x7F);
            i2 = i2 << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 2 & 0x7F);
            i2 = i2 << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 3 & 0x7F);
            i2 = i2 << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 4 & 0x7F);
            i2 = i2 << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 5 & 0x7F);
            i2 = i2 << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 6 & 0x7F);
            i2 = i2 << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(i2 & 0x7F);
            bytesLeft -= 7;
        }
        if (bytesLeft > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            inputEnd = this._readMore(in, buffer, inputPtr, inputEnd, bytesLeft);
            inputPtr = 0;
            if (inputEnd > 0) {
                bytesLeft -= inputEnd;
                i2 = buffer[inputPtr++];
                this._outputBuffer[this._outputTail++] = (byte)(i2 >> 1 & 0x7F);
                if (inputEnd > 1) {
                    i2 = (i2 & 1) << 8 | buffer[inputPtr++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(i2 >> 2 & 0x7F);
                    if (inputEnd > 2) {
                        i2 = (i2 & 3) << 8 | buffer[inputPtr++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(i2 >> 3 & 0x7F);
                        if (inputEnd > 3) {
                            i2 = (i2 & 7) << 8 | buffer[inputPtr++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(i2 >> 4 & 0x7F);
                            if (inputEnd > 4) {
                                i2 = (i2 & 0xF) << 8 | buffer[inputPtr++] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(i2 >> 5 & 0x7F);
                                if (inputEnd > 5) {
                                    i2 = (i2 & 0x1F) << 8 | buffer[inputPtr++] & 0xFF;
                                    this._outputBuffer[this._outputTail++] = (byte)(i2 >> 6 & 0x7F);
                                    this._outputBuffer[this._outputTail++] = (byte)(i2 & 0x3F);
                                } else {
                                    this._outputBuffer[this._outputTail++] = (byte)(i2 & 0x1F);
                                }
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(i2 & 0xF);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(i2 & 7);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(i2 & 3);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(i2 & 1);
                }
            }
        }
        return bytesLeft;
    }

    private int _readMore(InputStream in, byte[] readBuffer, int inputPtr, int inputEnd, int maxRead) throws IOException {
        int length2;
        int i2 = 0;
        while (inputPtr < inputEnd) {
            readBuffer[i2++] = readBuffer[inputPtr++];
        }
        inputPtr = 0;
        inputEnd = i2;
        maxRead = Math.min(maxRead, readBuffer.length);
        while ((length2 = maxRead - inputEnd) != 0) {
            int count2 = in.read(readBuffer, inputEnd, length2);
            if (count2 < 0) {
                return inputEnd;
            }
            if ((inputEnd += count2) < 7) continue;
        }
        return inputEnd;
    }

    @Override
    protected void _releaseBuffers() {
        Object[] valueBuf;
        Object[] nameBuf;
        char[] cbuf;
        byte[] buf = this._outputBuffer;
        if (buf != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer(buf);
        }
        if ((cbuf = this._charBuffer) != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer(cbuf);
        }
        if ((nameBuf = this._seenNames) != null && nameBuf.length == 64) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(nameBuf, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((SharedStringNode[])nameBuf);
        }
        if ((valueBuf = this._seenStringValues) != null && valueBuf.length == 64) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(valueBuf, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((SharedStringNode[])valueBuf);
        }
    }

    protected final void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._bytesWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    private final int _findSeenName(String name2) {
        int hash2 = name2.hashCode();
        SharedStringNode head = this._seenNames[hash2 & this._seenNames.length - 1];
        if (head == null) {
            return -1;
        }
        SharedStringNode node = head;
        if (node.value == name2) {
            return node.index;
        }
        while ((node = node.next) != null) {
            if (node.value != name2) continue;
            return node.index;
        }
        node = head;
        do {
            String value2;
            if ((value2 = node.value).hashCode() != hash2 || !value2.equals(name2)) continue;
            return node.index;
        } while ((node = node.next) != null);
        return -1;
    }

    private final void _addSeenName(String name2) {
        if (this._seenNameCount == this._seenNames.length) {
            if (this._seenNameCount == 1024) {
                Arrays.fill(this._seenNames, null);
                this._seenNameCount = 0;
            } else {
                SharedStringNode[] old = this._seenNames;
                this._seenNames = new SharedStringNode[1024];
                int mask = 1023;
                for (SharedStringNode node : old) {
                    while (node != null) {
                        int ix = node.value.hashCode() & 0x3FF;
                        SharedStringNode next = node.next;
                        node.next = this._seenNames[ix];
                        this._seenNames[ix] = node;
                        node = next;
                    }
                }
            }
        }
        int ix = name2.hashCode() & this._seenNames.length - 1;
        this._seenNames[ix] = new SharedStringNode(name2, this._seenNameCount, this._seenNames[ix]);
        ++this._seenNameCount;
    }

    private final int _findSeenStringValue(String text) {
        int hash2 = text.hashCode();
        SharedStringNode head = this._seenStringValues[hash2 & this._seenStringValues.length - 1];
        if (head != null) {
            SharedStringNode node = head;
            do {
                if (node.value != text) continue;
                return node.index;
            } while ((node = node.next) != null);
            node = head;
            do {
                String value2;
                if ((value2 = node.value).hashCode() != hash2 || !value2.equals(text)) continue;
                return node.index;
            } while ((node = node.next) != null);
        }
        return -1;
    }

    private final void _addSeenStringValue(String text) {
        if (this._seenStringValueCount == this._seenStringValues.length) {
            if (this._seenStringValueCount == 1024) {
                Arrays.fill(this._seenStringValues, null);
                this._seenStringValueCount = 0;
            } else {
                SharedStringNode[] old = this._seenStringValues;
                this._seenStringValues = new SharedStringNode[1024];
                int mask = 1023;
                for (SharedStringNode node : old) {
                    while (node != null) {
                        int ix = node.value.hashCode() & 0x3FF;
                        SharedStringNode next = node.next;
                        node.next = this._seenStringValues[ix];
                        this._seenStringValues[ix] = node;
                        node = next;
                    }
                }
            }
        }
        int ix = text.hashCode() & this._seenStringValues.length - 1;
        this._seenStringValues[ix] = new SharedStringNode(text, this._seenStringValueCount, this._seenStringValues[ix]);
        ++this._seenStringValueCount;
    }

    protected long outputOffset() {
        return this._bytesWritten + this._outputTail;
    }

    protected UnsupportedOperationException _notSupported() {
        return new UnsupportedOperationException();
    }

    protected static final class SharedStringNode {
        public final String value;
        public final int index;
        public SharedStringNode next;

        public SharedStringNode(String value2, int index2, SharedStringNode next) {
            this.value = value2;
            this.index = index2;
            this.next = next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        WRITE_HEADER(true),
        WRITE_END_MARKER(false),
        ENCODE_BINARY_AS_7BIT(true),
        CHECK_SHARED_NAMES(true),
        CHECK_SHARED_STRING_VALUES(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

