/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.stream.AdapterStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;

public class HandlesStreamOutput
extends AdapterStreamOutput {
    private static final int DEFAULT_IDENTITY_THRESHOLD = 50;
    private final int identityThreshold;
    private final TObjectIntHashMap<String> handles = new TObjectIntHashMap(10, 0.5f, -1);
    private final HandleTable identityHandles = new HandleTable(10, 3.0f);

    public HandlesStreamOutput(StreamOutput out) {
        this(out, 50);
    }

    public HandlesStreamOutput(StreamOutput out, int identityThreshold) {
        super(out);
        this.identityThreshold = identityThreshold;
    }

    @Override
    @Deprecated
    public void writeUTF(String s2) throws IOException {
        if (s2.length() < this.identityThreshold) {
            int handle = this.handles.get(s2);
            if (handle == -1) {
                handle = this.handles.size();
                this.handles.put(s2, handle);
                this.out.writeByte((byte)0);
                this.out.writeVInt(handle);
                this.out.writeUTF(s2);
            } else {
                this.out.writeByte((byte)1);
                this.out.writeVInt(handle);
            }
        } else {
            int handle = this.identityHandles.lookup(s2);
            if (handle == -1) {
                handle = this.identityHandles.assign(s2);
                this.out.writeByte((byte)2);
                this.out.writeVInt(handle);
                this.out.writeUTF(s2);
            } else {
                this.out.writeByte((byte)3);
                this.out.writeVInt(handle);
            }
        }
    }

    @Override
    public void writeString(String s2) throws IOException {
        if (s2.length() < this.identityThreshold) {
            int handle = this.handles.get(s2);
            if (handle == -1) {
                handle = this.handles.size();
                this.handles.put(s2, handle);
                this.out.writeByte((byte)0);
                this.out.writeVInt(handle);
                this.out.writeUTF(s2);
            } else {
                this.out.writeByte((byte)1);
                this.out.writeVInt(handle);
            }
        } else {
            int handle = this.identityHandles.lookup(s2);
            if (handle == -1) {
                handle = this.identityHandles.assign(s2);
                this.out.writeByte((byte)2);
                this.out.writeVInt(handle);
                this.out.writeUTF(s2);
            } else {
                this.out.writeByte((byte)3);
                this.out.writeVInt(handle);
            }
        }
    }

    @Override
    public void reset() throws IOException {
        this.handles.clear();
        this.identityHandles.clear();
        if (this.out != null) {
            this.out.reset();
        }
    }

    public void clear() {
        this.handles.clear();
        this.identityHandles.clear();
    }

    private static class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index2 = this.hash(obj) % this.spine.length;
            int i2 = this.spine[index2];
            while (i2 >= 0) {
                if (this.objs[i2] == obj) {
                    return i2;
                }
                i2 = this.next[i2];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object obj, int handle) {
            int index2 = this.hash(obj) % this.spine.length;
            this.objs[handle] = obj;
            this.next[handle] = this.spine[index2];
            this.spine[index2] = handle;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i2 = 0; i2 < this.size; ++i2) {
                this.insert(this.objs[i2], i2);
            }
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }
}

