/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class CachedStreamOutput {
    private static final SoftWrapper<Queue<Entry>> cache = new SoftWrapper();
    private static final AtomicInteger counter = new AtomicInteger();
    public static int BYTES_LIMIT = 0x100000;
    public static int COUNT_LIMIT = 100;
    private static ThreadLocal<SoftReference<UTF8StreamWriter>> utf8StreamWriter;

    private static Entry newEntry() {
        BytesStreamOutput bytes2 = new BytesStreamOutput();
        HandlesStreamOutput handles = new HandlesStreamOutput(bytes2);
        return new Entry(bytes2, handles);
    }

    public static void clear() {
        cache.clear();
    }

    public static Entry popEntry() {
        Queue<Entry> ref = cache.get();
        if (ref == null) {
            return CachedStreamOutput.newEntry();
        }
        Entry entry = ref.poll();
        if (entry == null) {
            return CachedStreamOutput.newEntry();
        }
        counter.decrementAndGet();
        entry.reset();
        return entry;
    }

    public static void pushEntry(Entry entry) {
        entry.reset();
        if (entry.bytes().bytes().length() > BYTES_LIMIT) {
            return;
        }
        Queue<Entry> ref = cache.get();
        if (ref == null) {
            ref = ConcurrentCollections.newQueue();
            counter.set(0);
            cache.set(ref);
        }
        if (counter.incrementAndGet() > COUNT_LIMIT) {
            counter.decrementAndGet();
        } else {
            ref.add(entry);
        }
    }

    public static UTF8StreamWriter utf8StreamWriter() {
        UTF8StreamWriter writer;
        SoftReference<UTF8StreamWriter> ref = utf8StreamWriter.get();
        UTF8StreamWriter uTF8StreamWriter = writer = ref == null ? null : ref.get();
        if (writer == null) {
            writer = new UTF8StreamWriter(4096);
            utf8StreamWriter.set(new SoftReference<UTF8StreamWriter>(writer));
        }
        writer.reset();
        return writer;
    }

    static {
        long maxHeap = JvmInfo.jvmInfo().mem().heapMax().bytes();
        if (maxHeap < ByteSizeValue.parseBytesSizeValue("500mb").bytes()) {
            BYTES_LIMIT = (int)ByteSizeValue.parseBytesSizeValue("500kb").bytes();
            COUNT_LIMIT = 10;
        } else if (maxHeap < ByteSizeValue.parseBytesSizeValue("1gb").bytes()) {
            BYTES_LIMIT = (int)ByteSizeValue.parseBytesSizeValue("1mb").bytes();
            COUNT_LIMIT = 20;
        } else if (maxHeap < ByteSizeValue.parseBytesSizeValue("4gb").bytes()) {
            BYTES_LIMIT = (int)ByteSizeValue.parseBytesSizeValue("2mb").bytes();
            COUNT_LIMIT = 50;
        } else if (maxHeap < ByteSizeValue.parseBytesSizeValue("10gb").bytes()) {
            BYTES_LIMIT = (int)ByteSizeValue.parseBytesSizeValue("5mb").bytes();
            COUNT_LIMIT = 50;
        } else {
            BYTES_LIMIT = (int)ByteSizeValue.parseBytesSizeValue("10mb").bytes();
            COUNT_LIMIT = 100;
        }
        utf8StreamWriter = new ThreadLocal();
    }

    static class SoftWrapper<T> {
        private SoftReference<T> ref;

        public void set(T ref) {
            this.ref = new SoftReference<T>(ref);
        }

        public T get() {
            return this.ref == null ? null : (T)this.ref.get();
        }

        public void clear() {
            this.ref = null;
        }
    }

    public static class Entry {
        private final BytesStreamOutput bytes;
        private final HandlesStreamOutput handles;

        Entry(BytesStreamOutput bytes2, HandlesStreamOutput handles) {
            this.bytes = bytes2;
            this.handles = handles;
        }

        public void reset() {
            this.bytes.reset();
            this.handles.setOut(this.bytes);
            this.handles.clear();
        }

        public BytesStreamOutput bytes() {
            return this.bytes;
        }

        public StreamOutput handles() throws IOException {
            return this.handles;
        }

        public StreamOutput bytes(Compressor compressor) throws IOException {
            return compressor.streamOutput(this.bytes);
        }

        public StreamOutput handles(Compressor compressor) throws IOException {
            CompressedStreamOutput compressed = compressor.streamOutput(this.bytes);
            this.handles.clear();
            this.handles.setOut(compressed);
            return this.handles;
        }
    }
}

