/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.spi;

import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.ElementVisitor;

public final class ProviderLookup<T>
implements Element {
    private final Object source;
    private final Key<T> key;
    private Provider<T> delegate;

    public ProviderLookup(Object source2, Key<T> key2) {
        this.source = Preconditions.checkNotNull(source2, "source");
        this.key = Preconditions.checkNotNull(key2, "key");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public void initializeDelegate(Provider<T> delegate2) {
        Preconditions.checkState(this.delegate == null, "delegate already initialized");
        this.delegate = Preconditions.checkNotNull(delegate2, "delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getProvider(this.key));
    }

    public Provider<T> getDelegate() {
        return this.delegate;
    }

    public Provider<T> getProvider() {
        return new Provider<T>(){

            @Override
            public T get() {
                Preconditions.checkState(ProviderLookup.this.delegate != null, "This Provider cannot be used until the Injector has been created.");
                return ProviderLookup.this.delegate.get();
            }

            public String toString() {
                return "Provider<" + ProviderLookup.this.key.getTypeLiteral() + ">";
            }
        };
    }
}

