/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;

public class SourceProvider {
    public static final Object UNKNOWN_SOURCE = "[unknown source]";
    private final ImmutableSet<String> classNamesToSkip;
    public static final SourceProvider DEFAULT_INSTANCE = new SourceProvider(ImmutableSet.of(SourceProvider.class.getName()));

    public SourceProvider() {
        this.classNamesToSkip = ImmutableSet.of(SourceProvider.class.getName());
    }

    private SourceProvider(Iterable<String> classesToSkip) {
        this.classNamesToSkip = ImmutableSet.copyOf(classesToSkip);
    }

    public SourceProvider plusSkippedClasses(Class ... moreClassesToSkip) {
        return new SourceProvider(Iterables.concat(this.classNamesToSkip, SourceProvider.asStrings(moreClassesToSkip)));
    }

    private static List<String> asStrings(Class ... classes2) {
        ArrayList<String> strings = Lists.newArrayList();
        for (Class c : classes2) {
            strings.add(c.getName());
        }
        return strings;
    }

    public StackTraceElement get() {
        for (StackTraceElement element : new Throwable().getStackTrace()) {
            String className = element.getClassName();
            if (this.classNamesToSkip.contains(className)) continue;
            return element;
        }
        throw new AssertionError();
    }
}

