/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.spi.Message;

public class MoreTypes {
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static final Map<TypeLiteral<?>, TypeLiteral<?>> PRIMITIVE_TO_WRAPPER = new ImmutableMap.Builder<TypeLiteral<Boolean>, TypeLiteral<Boolean>>().put(TypeLiteral.get(Boolean.TYPE), TypeLiteral.get(Boolean.class)).put(TypeLiteral.get(Byte.TYPE), TypeLiteral.get(Byte.class)).put(TypeLiteral.get(Short.TYPE), TypeLiteral.get(Short.class)).put(TypeLiteral.get(Integer.TYPE), TypeLiteral.get(Integer.class)).put(TypeLiteral.get(Long.TYPE), TypeLiteral.get(Long.class)).put(TypeLiteral.get(Float.TYPE), TypeLiteral.get(Float.class)).put(TypeLiteral.get(Double.TYPE), TypeLiteral.get(Double.class)).put(TypeLiteral.get(Character.TYPE), TypeLiteral.get(Character.class)).put(TypeLiteral.get(Void.TYPE), TypeLiteral.get(Void.class)).build();

    private MoreTypes() {
    }

    public static <T> TypeLiteral<T> makeKeySafe(TypeLiteral<T> type2) {
        if (!MoreTypes.isFullySpecified(type2.getType())) {
            String message2 = type2 + " cannot be used as a key; It is not fully specified.";
            throw new ConfigurationException(ImmutableSet.of(new Message(message2)));
        }
        TypeLiteral<?> wrappedPrimitives = PRIMITIVE_TO_WRAPPER.get(type2);
        return wrappedPrimitives != null ? wrappedPrimitives : type2;
    }

    private static boolean isFullySpecified(Type type2) {
        if (type2 instanceof Class) {
            return true;
        }
        if (type2 instanceof CompositeType) {
            return ((CompositeType)((Object)type2)).isFullySpecified();
        }
        if (type2 instanceof TypeVariable) {
            return false;
        }
        return ((CompositeType)((Object)MoreTypes.canonicalize(type2))).isFullySpecified();
    }

    public static Type canonicalize(Type type2) {
        if (type2 instanceof ParameterizedTypeImpl || type2 instanceof GenericArrayTypeImpl || type2 instanceof WildcardTypeImpl) {
            return type2;
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType p2 = (ParameterizedType)type2;
            return new ParameterizedTypeImpl(p2.getOwnerType(), p2.getRawType(), p2.getActualTypeArguments());
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type2;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type2 instanceof Class && ((Class)type2).isArray()) {
            Class c = (Class)type2;
            return new GenericArrayTypeImpl(c.getComponentType());
        }
        if (type2 instanceof WildcardType) {
            WildcardType w = (WildcardType)type2;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type2;
    }

    public static Member serializableCopy(Member member) {
        return member instanceof MemberImpl ? member : new MemberImpl(member);
    }

    public static Class<?> getRawType(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type rawType = parameterizedType.getRawType();
            Preconditions.checkArgument(rawType instanceof Class, "Expected a Class, but <%s> is of type %s", type2, type2.getClass().getName());
            return (Class)rawType;
        }
        if (type2 instanceof GenericArrayType) {
            return Object[].class;
        }
        if (type2 instanceof TypeVariable) {
            return Object.class;
        }
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type2 + "> is of type " + type2.getClass().getName());
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            return Objects.equal(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return MoreTypes.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    public static int hashCode(Type type2) {
        if (type2 instanceof Class) {
            return type2.hashCode();
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType p2 = (ParameterizedType)type2;
            return Arrays.hashCode(p2.getActualTypeArguments()) ^ p2.getRawType().hashCode() ^ MoreTypes.hashCodeOrZero(p2.getOwnerType());
        }
        if (type2 instanceof GenericArrayType) {
            return MoreTypes.hashCode(((GenericArrayType)type2).getGenericComponentType());
        }
        if (type2 instanceof WildcardType) {
            WildcardType w = (WildcardType)type2;
            return Arrays.hashCode(w.getLowerBounds()) ^ Arrays.hashCode(w.getUpperBounds());
        }
        return MoreTypes.hashCodeOrZero(type2);
    }

    private static int hashCodeOrZero(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static String toString(Type type2) {
        if (type2 instanceof Class) {
            return ((Class)type2).getName();
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            Type ownerType = parameterizedType.getOwnerType();
            StringBuilder stringBuilder = new StringBuilder();
            if (ownerType != null) {
                stringBuilder.append(MoreTypes.toString(ownerType)).append(".");
            }
            stringBuilder.append(MoreTypes.toString(parameterizedType.getRawType()));
            if (arguments.length > 0) {
                stringBuilder.append("<").append(MoreTypes.toString(arguments[0]));
                for (int i2 = 1; i2 < arguments.length; ++i2) {
                    stringBuilder.append(", ").append(MoreTypes.toString(arguments[i2]));
                }
            }
            return stringBuilder.append(">").toString();
        }
        if (type2 instanceof GenericArrayType) {
            return MoreTypes.toString(((GenericArrayType)type2).getGenericComponentType()) + "[]";
        }
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length != 1 || lowerBounds.length > 1) {
                throw new UnsupportedOperationException("Unsupported wildcard type " + type2);
            }
            if (lowerBounds.length == 1) {
                if (upperBounds[0] != Object.class) {
                    throw new UnsupportedOperationException("Unsupported wildcard type " + type2);
                }
                return "? super " + MoreTypes.toString(lowerBounds[0]);
            }
            if (upperBounds[0] == Object.class) {
                return "?";
            }
            return "? extends " + MoreTypes.toString(upperBounds[0]);
        }
        return type2.toString();
    }

    public static Class<? extends Member> memberType(Member member) {
        Preconditions.checkNotNull(member, "member");
        if (member instanceof MemberImpl) {
            return ((MemberImpl)member).memberType;
        }
        if (member instanceof Field) {
            return Field.class;
        }
        if (member instanceof Method) {
            return Method.class;
        }
        if (member instanceof Constructor) {
            return Constructor.class;
        }
        throw new IllegalArgumentException("Unsupported implementation class for Member, " + member.getClass());
    }

    public static String toString(Member member) {
        Class<? extends Member> memberType = MoreTypes.memberType(member);
        if (memberType == Method.class) {
            return member.getDeclaringClass().getName() + "." + member.getName() + "()";
        }
        if (memberType == Field.class) {
            return member.getDeclaringClass().getName() + "." + member.getName();
        }
        if (memberType == Constructor.class) {
            return member.getDeclaringClass().getName() + ".<init>()";
        }
        throw new AssertionError();
    }

    public static String memberKey(Member member) {
        Preconditions.checkNotNull(member, "member");
        return "<NO_MEMBER_KEY>";
    }

    public static Type getGenericSupertype(Type type2, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return type2;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces2 = rawType.getInterfaces();
            int length2 = interfaces2.length;
            for (int i2 = 0; i2 < length2; ++i2) {
                if (interfaces2[i2] == toResolve) {
                    return rawType.getGenericInterfaces()[i2];
                }
                if (!toResolve.isAssignableFrom(interfaces2[i2])) continue;
                return MoreTypes.getGenericSupertype(rawType.getGenericInterfaces()[i2], interfaces2[i2], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom(rawSupertype)) {
                    return MoreTypes.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    public static Type resolveTypeVariable(Type type2, Class<?> rawType, TypeVariable unknown) {
        Class<?> declaredByRaw = MoreTypes.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = MoreTypes.getGenericSupertype(type2, rawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index2 = MoreTypes.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index2];
        }
        return unknown;
    }

    private static int indexOf(Object[] array, Object toFind) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!toFind.equals(array[i2])) continue;
            return i2;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    private static void checkNotPrimitive(Type type2, String use) {
        Preconditions.checkArgument(!(type2 instanceof Class) || !((Class)type2).isPrimitive(), "Primitive types are not allowed in %s: %s", use, type2);
    }

    private static interface CompositeType {
        public boolean isFullySpecified();
    }

    public static class MemberImpl
    implements Member,
    Serializable {
        private final Class<?> declaringClass;
        private final String name;
        private final int modifiers;
        private final boolean synthetic;
        private final Class<? extends Member> memberType;
        private final String memberKey;

        private MemberImpl(Member member) {
            this.declaringClass = member.getDeclaringClass();
            this.name = member.getName();
            this.modifiers = member.getModifiers();
            this.synthetic = member.isSynthetic();
            this.memberType = MoreTypes.memberType(member);
            this.memberKey = MoreTypes.memberKey(member);
        }

        public Class getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean isSynthetic() {
            return this.synthetic;
        }

        public String toString() {
            return MoreTypes.toString(this);
        }
    }

    public static class WildcardTypeImpl
    implements WildcardType,
    Serializable,
    CompositeType {
        private final Type upperBound;
        private final Type lowerBound;
        private static final long serialVersionUID = 0L;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            Preconditions.checkArgument(lowerBounds.length <= 1, "Must have at most one lower bound.");
            Preconditions.checkArgument(upperBounds.length == 1, "Must have exactly one upper bound.");
            if (lowerBounds.length == 1) {
                Preconditions.checkNotNull(lowerBounds[0], "lowerBound");
                MoreTypes.checkNotPrimitive(lowerBounds[0], "wildcard bounds");
                Preconditions.checkArgument(upperBounds[0] == Object.class, "bounded both ways");
                this.lowerBound = MoreTypes.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                Preconditions.checkNotNull(upperBounds[0], "upperBound");
                MoreTypes.checkNotPrimitive(upperBounds[0], "wildcard bounds");
                this.lowerBound = null;
                this.upperBound = MoreTypes.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        @Override
        public boolean isFullySpecified() {
            return MoreTypes.isFullySpecified(this.upperBound) && (this.lowerBound == null || MoreTypes.isFullySpecified(this.lowerBound));
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && MoreTypes.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return MoreTypes.hashCode(this);
        }

        public String toString() {
            return MoreTypes.toString(this);
        }
    }

    public static class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable,
    CompositeType {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = MoreTypes.canonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        @Override
        public boolean isFullySpecified() {
            return MoreTypes.isFullySpecified(this.componentType);
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && MoreTypes.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return MoreTypes.hashCode(this);
        }

        public String toString() {
            return MoreTypes.toString(this);
        }
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable,
    CompositeType {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class rawTypeAsClass = (Class)rawType;
                Preconditions.checkArgument(ownerType != null || rawTypeAsClass.getEnclosingClass() == null, "No owner type for enclosed %s", rawType);
                Preconditions.checkArgument(ownerType == null || rawTypeAsClass.getEnclosingClass() != null, "Owner type for unenclosed %s", rawType);
            }
            this.ownerType = ownerType == null ? null : MoreTypes.canonicalize(ownerType);
            this.rawType = MoreTypes.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            for (int t = 0; t < this.typeArguments.length; ++t) {
                Preconditions.checkNotNull(this.typeArguments[t], "type parameter");
                MoreTypes.checkNotPrimitive(this.typeArguments[t], "type parameters");
                this.typeArguments[t] = MoreTypes.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public boolean isFullySpecified() {
            if (this.ownerType != null && !MoreTypes.isFullySpecified(this.ownerType)) {
                return false;
            }
            if (!MoreTypes.isFullySpecified(this.rawType)) {
                return false;
            }
            for (Type type2 : this.typeArguments) {
                if (MoreTypes.isFullySpecified(type2)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && MoreTypes.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return MoreTypes.hashCode(this);
        }

        public String toString() {
            return MoreTypes.toString(this);
        }
    }
}

