/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.ProvisionException;
import org.elasticsearch.common.inject.Scope;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.MatcherAndConverter;
import org.elasticsearch.common.inject.internal.MoreTypes;
import org.elasticsearch.common.inject.internal.SourceProvider;
import org.elasticsearch.common.inject.internal.StackTraceElements;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.InjectionListener;
import org.elasticsearch.common.inject.spi.InjectionPoint;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.inject.spi.TypeListenerBinding;

public final class Errors
implements Serializable {
    private final Errors root;
    private final Errors parent;
    private final Object source;
    private List<Message> errors;
    private static final String CONSTRUCTOR_RULES = "Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.";
    private static final Collection<Converter<?>> converters = ImmutableList.of(new Converter<Class>(Class.class){

        @Override
        public String toString(Class c) {
            return c.getName();
        }
    }, new Converter<Member>(Member.class){

        @Override
        public String toString(Member member) {
            return MoreTypes.toString(member);
        }
    }, new Converter<Key>(Key.class){

        @Override
        public String toString(Key key2) {
            if (key2.getAnnotationType() != null) {
                return key2.getTypeLiteral() + " annotated with " + (key2.getAnnotation() != null ? key2.getAnnotation() : key2.getAnnotationType());
            }
            return key2.getTypeLiteral().toString();
        }
    });

    public Errors() {
        this.root = this;
        this.parent = null;
        this.source = SourceProvider.UNKNOWN_SOURCE;
    }

    public Errors(Object source2) {
        this.root = this;
        this.parent = null;
        this.source = source2;
    }

    private Errors(Errors parent, Object source2) {
        this.root = parent.root;
        this.parent = parent;
        this.source = source2;
    }

    public Errors withSource(Object source2) {
        return source2 == SourceProvider.UNKNOWN_SOURCE ? this : new Errors(this, source2);
    }

    public Errors missingImplementation(Key key2) {
        return this.addMessage("No implementation for %s was bound.", key2);
    }

    public Errors converterReturnedNull(String stringValue, Object source2, TypeLiteral<?> type2, MatcherAndConverter matchingConverter) {
        return this.addMessage("Received null converting '%s' (bound at %s) to %s%n using %s.", stringValue, Errors.convert(source2), type2, matchingConverter);
    }

    public Errors conversionTypeError(String stringValue, Object source2, TypeLiteral<?> type2, MatcherAndConverter matchingConverter, Object converted) {
        return this.addMessage("Type mismatch converting '%s' (bound at %s) to %s%n using %s.%n Converter returned %s.", stringValue, Errors.convert(source2), type2, matchingConverter, converted);
    }

    public Errors conversionError(String stringValue, Object source2, TypeLiteral<?> type2, MatcherAndConverter matchingConverter, RuntimeException cause2) {
        return this.errorInUserCode(cause2, "Error converting '%s' (bound at %s) to %s%n using %s.%n Reason: %s", stringValue, Errors.convert(source2), type2, matchingConverter, cause2);
    }

    public Errors ambiguousTypeConversion(String stringValue, Object source2, TypeLiteral<?> type2, MatcherAndConverter a, MatcherAndConverter b) {
        return this.addMessage("Multiple converters can convert '%s' (bound at %s) to %s:%n %s and%n %s.%n Please adjust your type converter configuration to avoid overlapping matches.", stringValue, Errors.convert(source2), type2, a, b);
    }

    public Errors bindingToProvider() {
        return this.addMessage("Binding to Provider is not allowed.", new Object[0]);
    }

    public Errors subtypeNotProvided(Class<? extends Provider<?>> providerType, Class<?> type2) {
        return this.addMessage("%s doesn't provide instances of %s.", providerType, type2);
    }

    public Errors notASubtype(Class<?> implementationType, Class<?> type2) {
        return this.addMessage("%s doesn't extend %s.", implementationType, type2);
    }

    public Errors recursiveImplementationType() {
        return this.addMessage("@ImplementedBy points to the same class it annotates.", new Object[0]);
    }

    public Errors recursiveProviderType() {
        return this.addMessage("@ProvidedBy points to the same class it annotates.", new Object[0]);
    }

    public Errors missingRuntimeRetention(Object source2) {
        return this.addMessage("Please annotate with @Retention(RUNTIME).%n Bound at %s.", Errors.convert(source2));
    }

    public Errors missingScopeAnnotation() {
        return this.addMessage("Please annotate with @ScopeAnnotation.", new Object[0]);
    }

    public Errors optionalConstructor(Constructor constructor2) {
        return this.addMessage("%s is annotated @Inject(optional=true), but constructors cannot be optional.", constructor2);
    }

    public Errors cannotBindToGuiceType(String simpleName) {
        return this.addMessage("Binding to core guice framework type is not allowed: %s.", simpleName);
    }

    public Errors scopeNotFound(Class<? extends Annotation> scopeAnnotation) {
        return this.addMessage("No scope is bound to %s.", scopeAnnotation);
    }

    public Errors scopeAnnotationOnAbstractType(Class<? extends Annotation> scopeAnnotation, Class<?> type2, Object source2) {
        return this.addMessage("%s is annotated with %s, but scope annotations are not supported for abstract types.%n Bound at %s.", type2, scopeAnnotation, Errors.convert(source2));
    }

    public Errors misplacedBindingAnnotation(Member member, Annotation bindingAnnotation) {
        return this.addMessage("%s is annotated with %s, but binding annotations should be applied to its parameters instead.", member, bindingAnnotation);
    }

    public Errors missingConstructor(Class<?> implementation) {
        return this.addMessage("Could not find a suitable constructor in %s. Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.", implementation);
    }

    public Errors tooManyConstructors(Class<?> implementation) {
        return this.addMessage("%s has more than one constructor annotated with @Inject. Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.", implementation);
    }

    public Errors duplicateScopes(Scope existing, Class<? extends Annotation> annotationType, Scope scope) {
        return this.addMessage("Scope %s is already bound to %s. Cannot bind %s.", existing, annotationType, scope);
    }

    public Errors voidProviderMethod() {
        return this.addMessage("Provider methods must return a value. Do not return void.", new Object[0]);
    }

    public Errors missingConstantValues() {
        return this.addMessage("Missing constant value. Please call to(...).", new Object[0]);
    }

    public Errors cannotInjectInnerClass(Class<?> type2) {
        return this.addMessage("Injecting into inner classes is not supported.  Please use a 'static' class (top-level or nested) instead of %s.", type2);
    }

    public Errors duplicateBindingAnnotations(Member member, Class<? extends Annotation> a, Class<? extends Annotation> b) {
        return this.addMessage("%s has more than one annotation annotated with @BindingAnnotation: %s and %s", member, a, b);
    }

    public Errors duplicateScopeAnnotations(Class<? extends Annotation> a, Class<? extends Annotation> b) {
        return this.addMessage("More than one scope annotation was found: %s and %s.", a, b);
    }

    public Errors recursiveBinding() {
        return this.addMessage("Binding points to itself.", new Object[0]);
    }

    public Errors bindingAlreadySet(Key<?> key2, Object source2) {
        return this.addMessage("A binding to %s was already configured at %s.", key2, Errors.convert(source2));
    }

    public Errors childBindingAlreadySet(Key<?> key2) {
        return this.addMessage("A binding to %s already exists on a child injector.", key2);
    }

    public Errors errorInjectingMethod(Throwable cause2) {
        return this.errorInUserCode(cause2, "Error injecting method, %s", cause2);
    }

    public Errors errorNotifyingTypeListener(TypeListenerBinding listener, TypeLiteral<?> type2, Throwable cause2) {
        return this.errorInUserCode(cause2, "Error notifying TypeListener %s (bound at %s) of %s.%n Reason: %s", listener.getListener(), Errors.convert(listener.getSource()), type2, cause2);
    }

    public Errors errorInjectingConstructor(Throwable cause2) {
        return this.errorInUserCode(cause2, "Error injecting constructor, %s", cause2);
    }

    public Errors errorInProvider(RuntimeException runtimeException) {
        return this.errorInUserCode(runtimeException, "Error in custom provider, %s", runtimeException);
    }

    public Errors errorInUserInjector(MembersInjector<?> listener, TypeLiteral<?> type2, RuntimeException cause2) {
        return this.errorInUserCode(cause2, "Error injecting %s using %s.%n Reason: %s", type2, listener, cause2);
    }

    public Errors errorNotifyingInjectionListener(InjectionListener<?> listener, TypeLiteral<?> type2, RuntimeException cause2) {
        return this.errorInUserCode(cause2, "Error notifying InjectionListener %s of %s.%n Reason: %s", listener, type2, cause2);
    }

    public void exposedButNotBound(Key<?> key2) {
        this.addMessage("Could not expose() %s, it must be explicitly bound.", key2);
    }

    public static Collection<Message> getMessagesFromThrowable(Throwable throwable) {
        if (throwable instanceof ProvisionException) {
            return ((ProvisionException)throwable).getErrorMessages();
        }
        if (throwable instanceof ConfigurationException) {
            return ((ConfigurationException)throwable).getErrorMessages();
        }
        if (throwable instanceof CreationException) {
            return ((CreationException)throwable).getErrorMessages();
        }
        return ImmutableSet.of();
    }

    public Errors errorInUserCode(Throwable cause2, String messageFormat, Object ... arguments) {
        Collection<Message> messages = Errors.getMessagesFromThrowable(cause2);
        if (!messages.isEmpty()) {
            return this.merge(messages);
        }
        return this.addMessage(cause2, messageFormat, arguments);
    }

    public Errors cannotInjectRawProvider() {
        return this.addMessage("Cannot inject a Provider that has no type parameter", new Object[0]);
    }

    public Errors cannotInjectRawMembersInjector() {
        return this.addMessage("Cannot inject a MembersInjector that has no type parameter", new Object[0]);
    }

    public Errors cannotInjectTypeLiteralOf(Type unsupportedType) {
        return this.addMessage("Cannot inject a TypeLiteral of %s", unsupportedType);
    }

    public Errors cannotInjectRawTypeLiteral() {
        return this.addMessage("Cannot inject a TypeLiteral that has no type parameter", new Object[0]);
    }

    public Errors cannotSatisfyCircularDependency(Class<?> expectedType) {
        return this.addMessage("Tried proxying %s to support a circular dependency, but it is not an interface.", expectedType);
    }

    public void throwCreationExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        throw new CreationException(this.getMessages());
    }

    public void throwConfigurationExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        throw new ConfigurationException(this.getMessages());
    }

    public void throwProvisionExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        throw new ProvisionException(this.getMessages());
    }

    private Message merge(Message message2) {
        ArrayList<Object> sources = Lists.newArrayList();
        sources.addAll(this.getSources());
        sources.addAll(message2.getSources());
        return new Message(sources, message2.getMessage(), message2.getCause());
    }

    public Errors merge(Collection<Message> messages) {
        for (Message message2 : messages) {
            this.addMessage(this.merge(message2));
        }
        return this;
    }

    public Errors merge(Errors moreErrors) {
        if (moreErrors.root == this.root || moreErrors.root.errors == null) {
            return this;
        }
        this.merge(moreErrors.root.errors);
        return this;
    }

    public List<Object> getSources() {
        ArrayList<Object> sources = Lists.newArrayList();
        Errors e = this;
        while (e != null) {
            if (e.source != SourceProvider.UNKNOWN_SOURCE) {
                sources.add(0, e.source);
            }
            e = e.parent;
        }
        return sources;
    }

    public void throwIfNewErrors(int expectedSize) throws ErrorsException {
        if (this.size() == expectedSize) {
            return;
        }
        throw this.toException();
    }

    public ErrorsException toException() {
        return new ErrorsException(this);
    }

    public boolean hasErrors() {
        return this.root.errors != null;
    }

    public Errors addMessage(String messageFormat, Object ... arguments) {
        return this.addMessage(null, messageFormat, arguments);
    }

    private Errors addMessage(Throwable cause2, String messageFormat, Object ... arguments) {
        String message2 = Errors.format(messageFormat, arguments);
        this.addMessage(new Message(this.getSources(), message2, cause2));
        return this;
    }

    public Errors addMessage(Message message2) {
        if (this.root.errors == null) {
            this.root.errors = Lists.newArrayList();
        }
        this.root.errors.add(message2);
        return this;
    }

    public static String format(String messageFormat, Object ... arguments) {
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            arguments[i2] = Errors.convert(arguments[i2]);
        }
        return String.format(messageFormat, arguments);
    }

    public List<Message> getMessages() {
        if (this.root.errors == null) {
            return ImmutableList.of();
        }
        ArrayList<Message> result2 = Lists.newArrayList(this.root.errors);
        Collections.sort(result2, new Comparator<Message>(){

            @Override
            public int compare(Message a, Message b) {
                return a.getSource().compareTo(b.getSource());
            }
        });
        return result2;
    }

    public static String format(String heading, Collection<Message> errorMessages) {
        Formatter fmt = new Formatter().format(heading, new Object[0]).format(":%n%n", new Object[0]);
        int index2 = 1;
        boolean displayCauses = Errors.getOnlyCause(errorMessages) == null;
        for (Message errorMessage : errorMessages) {
            fmt.format("%s) %s%n", index2++, errorMessage.getMessage());
            List<Object> dependencies = errorMessage.getSources();
            for (int i2 = dependencies.size() - 1; i2 >= 0; --i2) {
                Object source2 = dependencies.get(i2);
                Errors.formatSource(fmt, source2);
            }
            Throwable cause2 = errorMessage.getCause();
            if (displayCauses && cause2 != null) {
                StringWriter writer = new StringWriter();
                cause2.printStackTrace(new PrintWriter(writer));
                fmt.format("Caused by: %s", writer.getBuffer());
            }
            fmt.format("%n", new Object[0]);
        }
        if (errorMessages.size() == 1) {
            fmt.format("1 error", new Object[0]);
        } else {
            fmt.format("%s errors", errorMessages.size());
        }
        return fmt.toString();
    }

    public <T> T checkForNull(T value2, Object source2, Dependency<?> dependency) throws ErrorsException {
        if (value2 != null || dependency.isNullable()) {
            return value2;
        }
        int parameterIndex = dependency.getParameterIndex();
        String parameterName = parameterIndex != -1 ? "parameter " + parameterIndex + " of " : "";
        this.addMessage("null returned by binding at %s%n but %s%s is not @Nullable", source2, parameterName, dependency.getInjectionPoint().getMember());
        throw this.toException();
    }

    public static Throwable getOnlyCause(Collection<Message> messages) {
        Throwable onlyCause = null;
        for (Message message2 : messages) {
            Throwable messageCause = message2.getCause();
            if (messageCause == null) continue;
            if (onlyCause != null) {
                return null;
            }
            onlyCause = messageCause;
        }
        return onlyCause;
    }

    public int size() {
        return this.root.errors == null ? 0 : this.root.errors.size();
    }

    public static Object convert(Object o) {
        for (Converter<?> converter : converters) {
            if (!converter.appliesTo(o)) continue;
            return converter.convert(o);
        }
        return o;
    }

    public static void formatSource(Formatter formatter, Object source2) {
        if (source2 instanceof Dependency) {
            Dependency dependency = (Dependency)source2;
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            if (injectionPoint != null) {
                Errors.formatInjectionPoint(formatter, dependency, injectionPoint);
            } else {
                Errors.formatSource(formatter, dependency.getKey());
            }
        } else if (source2 instanceof InjectionPoint) {
            Errors.formatInjectionPoint(formatter, null, (InjectionPoint)source2);
        } else if (source2 instanceof Class) {
            formatter.format("  at %s%n", StackTraceElements.forType((Class)source2));
        } else if (source2 instanceof Member) {
            formatter.format("  at %s%n", StackTraceElements.forMember((Member)source2));
        } else if (source2 instanceof TypeLiteral) {
            formatter.format("  while locating %s%n", source2);
        } else if (source2 instanceof Key) {
            Key key2 = (Key)source2;
            formatter.format("  while locating %s%n", Errors.convert(key2));
        } else {
            formatter.format("  at %s%n", source2);
        }
    }

    public static void formatInjectionPoint(Formatter formatter, Dependency<?> dependency, InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        Class<? extends Member> memberType = MoreTypes.memberType(member);
        if (memberType == Field.class) {
            dependency = injectionPoint.getDependencies().get(0);
            formatter.format("  while locating %s%n", Errors.convert(dependency.getKey()));
            formatter.format("    for field at %s%n", StackTraceElements.forMember(member));
        } else if (dependency != null) {
            formatter.format("  while locating %s%n", Errors.convert(dependency.getKey()));
            formatter.format("    for parameter %s at %s%n", dependency.getParameterIndex(), StackTraceElements.forMember(member));
        } else {
            Errors.formatSource(formatter, injectionPoint.getMember());
        }
    }

    private static abstract class Converter<T> {
        final Class<T> type;

        Converter(Class<T> type2) {
            this.type = type2;
        }

        boolean appliesTo(Object o) {
            return this.type.isAssignableFrom(o.getClass());
        }

        String convert(Object o) {
            return this.toString(this.type.cast(o));
        }

        abstract String toString(T var1);
    }
}

