/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.assistedinject;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.inject.BindingAnnotation;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.assistedinject.Assisted;

class Parameter {
    private final Type type;
    private final boolean isAssisted;
    private final Annotation bindingAnnotation;
    private final boolean isProvider;

    public Parameter(Type type2, Annotation[] annotations2) {
        this.type = type2;
        this.bindingAnnotation = this.getBindingAnnotation(annotations2);
        this.isAssisted = this.hasAssistedAnnotation(annotations2);
        this.isProvider = this.isProvider(type2);
    }

    public boolean isProvidedByFactory() {
        return this.isAssisted;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.isAssisted) {
            result2.append("@Assisted");
            result2.append(" ");
        }
        if (this.bindingAnnotation != null) {
            result2.append(((Object)this.bindingAnnotation).toString());
            result2.append(" ");
        }
        result2.append(this.type.toString());
        return result2.toString();
    }

    private boolean hasAssistedAnnotation(Annotation[] annotations2) {
        for (Annotation annotation2 : annotations2) {
            if (!annotation2.annotationType().equals(Assisted.class)) continue;
            return true;
        }
        return false;
    }

    public Object getValue(Injector injector) {
        return this.isProvider ? injector.getProvider(this.getBindingForType(this.getProvidedType(this.type))) : injector.getInstance(this.getPrimaryBindingKey());
    }

    public boolean isBound(Injector injector) {
        return this.isBound(injector, this.getPrimaryBindingKey()) || this.isBound(injector, this.fixAnnotations(this.getPrimaryBindingKey()));
    }

    private boolean isBound(Injector injector, Key<?> key2) {
        try {
            return injector.getBinding(key2) != null;
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    public Key<?> fixAnnotations(Key<?> key2) {
        return key2.getAnnotation() == null ? key2 : Key.get(key2.getTypeLiteral(), key2.getAnnotation().annotationType());
    }

    Key<?> getPrimaryBindingKey() {
        return this.isProvider ? this.getBindingForType(this.getProvidedType(this.type)) : this.getBindingForType(this.type);
    }

    private Type getProvidedType(Type type2) {
        return ((ParameterizedType)type2).getActualTypeArguments()[0];
    }

    private boolean isProvider(Type type2) {
        return type2 instanceof ParameterizedType && ((ParameterizedType)type2).getRawType() == Provider.class;
    }

    private Key<?> getBindingForType(Type type2) {
        return this.bindingAnnotation != null ? Key.get(type2, this.bindingAnnotation) : Key.get(type2);
    }

    private Annotation getBindingAnnotation(Annotation[] annotations2) {
        Annotation bindingAnnotation = null;
        for (Annotation a : annotations2) {
            if (a.annotationType().getAnnotation(BindingAnnotation.class) == null) continue;
            Preconditions.checkArgument(bindingAnnotation == null, "Parameter has multiple binding annotations: %s and %s", bindingAnnotation, a);
            bindingAnnotation = a;
        }
        return bindingAnnotation;
    }
}

