/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.assistedinject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.inject.assistedinject.AssistedConstructor;
import org.elasticsearch.common.inject.assistedinject.AssistedInject;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider2;
import org.elasticsearch.common.inject.assistedinject.Parameter;
import org.elasticsearch.common.inject.assistedinject.ParameterListKey;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.HasDependencies;
import org.elasticsearch.common.inject.spi.Message;

public class FactoryProvider<F>
implements Provider<F>,
HasDependencies {
    private Injector injector;
    private final TypeLiteral<F> factoryType;
    private final Map<Method, AssistedConstructor<?>> factoryMethodToConstructor;

    public static <F> Provider<F> newFactory(Class<F> factoryType, Class<?> implementationType) {
        return FactoryProvider.newFactory(TypeLiteral.get(factoryType), TypeLiteral.get(implementationType));
    }

    public static <F> Provider<F> newFactory(TypeLiteral<F> factoryType, TypeLiteral<?> implementationType) {
        Map<Method, AssistedConstructor<?>> factoryMethodToConstructor = FactoryProvider.createMethodMapping(factoryType, implementationType);
        if (!factoryMethodToConstructor.isEmpty()) {
            return new FactoryProvider<F>(factoryType, factoryMethodToConstructor);
        }
        return new FactoryProvider2<F>(factoryType, Key.get(implementationType));
    }

    private FactoryProvider(TypeLiteral<F> factoryType, Map<Method, AssistedConstructor<?>> factoryMethodToConstructor) {
        this.factoryType = factoryType;
        this.factoryMethodToConstructor = factoryMethodToConstructor;
        this.checkDeclaredExceptionsMatch();
    }

    @Inject
    void setInjectorAndCheckUnboundParametersAreInjectable(Injector injector) {
        this.injector = injector;
        for (AssistedConstructor<?> c : this.factoryMethodToConstructor.values()) {
            for (Parameter p2 : c.getAllParameters()) {
                if (p2.isProvidedByFactory() || this.paramCanBeInjected(p2, injector)) continue;
                throw FactoryProvider.newConfigurationException("Parameter of type '%s' is not injectable or annotated with @Assisted for Constructor '%s'", p2, c);
            }
        }
    }

    private void checkDeclaredExceptionsMatch() {
        for (Map.Entry<Method, AssistedConstructor<?>> entry : this.factoryMethodToConstructor.entrySet()) {
            for (Class<?> constructorException : entry.getValue().getDeclaredExceptions()) {
                if (this.isConstructorExceptionCompatibleWithFactoryExeception(constructorException, entry.getKey().getExceptionTypes())) continue;
                throw FactoryProvider.newConfigurationException("Constructor %s declares an exception, but no compatible exception is thrown by the factory method %s", entry.getValue(), entry.getKey());
            }
        }
    }

    private boolean isConstructorExceptionCompatibleWithFactoryExeception(Class<?> constructorException, Class<?>[] factoryExceptions) {
        for (Class<?> factoryException : factoryExceptions) {
            if (!factoryException.isAssignableFrom(constructorException)) continue;
            return true;
        }
        return false;
    }

    private boolean paramCanBeInjected(Parameter parameter, Injector injector) {
        return parameter.isBound(injector);
    }

    private static Map<Method, AssistedConstructor<?>> createMethodMapping(TypeLiteral<?> factoryType, TypeLiteral<?> implementationType) {
        ArrayList<AssistedConstructor<?>> constructors2 = Lists.newArrayList();
        for (Constructor<?> constructor2 : implementationType.getRawType().getDeclaredConstructors()) {
            if (constructor2.getAnnotation(AssistedInject.class) == null) continue;
            AssistedConstructor assistedConstructor = new AssistedConstructor(constructor2, implementationType.getParameterTypes(constructor2));
            constructors2.add(assistedConstructor);
        }
        if (constructors2.isEmpty()) {
            return ImmutableMap.of();
        }
        Method[] factoryMethods = factoryType.getRawType().getMethods();
        if (constructors2.size() != factoryMethods.length) {
            throw FactoryProvider.newConfigurationException("Constructor mismatch: %s has %s @AssistedInject constructors, factory %s has %s creation methods", implementationType, constructors2.size(), factoryType, factoryMethods.length);
        }
        HashMap<ParameterListKey, AssistedConstructor> paramsToConstructor = Maps.newHashMap();
        for (AssistedConstructor assistedConstructor : constructors2) {
            if (paramsToConstructor.containsKey(assistedConstructor.getAssistedParameters())) {
                throw new RuntimeException("Duplicate constructor, " + assistedConstructor);
            }
            paramsToConstructor.put(assistedConstructor.getAssistedParameters(), assistedConstructor);
        }
        HashMap<Method, AssistedConstructor<?>> result2 = Maps.newHashMap();
        for (Method method2 : factoryMethods) {
            if (!method2.getReturnType().isAssignableFrom(implementationType.getRawType())) {
                throw FactoryProvider.newConfigurationException("Return type of method %s is not assignable from %s", method2, implementationType);
            }
            ArrayList<Type> parameterTypes = Lists.newArrayList();
            for (TypeLiteral<?> parameterType : factoryType.getParameterTypes(method2)) {
                parameterTypes.add(parameterType.getType());
            }
            ParameterListKey methodParams = new ParameterListKey(parameterTypes);
            if (!paramsToConstructor.containsKey(methodParams)) {
                throw FactoryProvider.newConfigurationException("%s has no @AssistInject constructor that takes the @Assisted parameters %s in that order. @AssistInject constructors are %s", implementationType, methodParams, paramsToConstructor.values());
            }
            method2.getParameterAnnotations();
            Annotation[][] arr$ = method2.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] parameterAnnotations;
                for (Annotation parameterAnnotation : parameterAnnotations = arr$[i$]) {
                    if (parameterAnnotation.annotationType() != Assisted.class) continue;
                    throw FactoryProvider.newConfigurationException("Factory method %s has an @Assisted parameter, which is incompatible with the deprecated @AssistedInject annotation. Please replace @AssistedInject with @Inject on the %s constructor.", method2, implementationType);
                }
            }
            AssistedConstructor matchingConstructor = (AssistedConstructor)paramsToConstructor.remove(methodParams);
            result2.put(method2, matchingConstructor);
        }
        return result2;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        ArrayList<Dependency<?>> dependencies = Lists.newArrayList();
        for (AssistedConstructor<?> constructor2 : this.factoryMethodToConstructor.values()) {
            for (Parameter parameter : constructor2.getAllParameters()) {
                if (parameter.isProvidedByFactory()) continue;
                dependencies.add(Dependency.get(parameter.getPrimaryBindingKey()));
            }
        }
        return ImmutableSet.copyOf(dependencies);
    }

    @Override
    public F get() {
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy2, Method method2, Object[] creationArgs) throws Throwable {
                if (method2.getDeclaringClass().equals(Object.class)) {
                    return method2.invoke((Object)this, creationArgs);
                }
                AssistedConstructor constructor2 = (AssistedConstructor)FactoryProvider.this.factoryMethodToConstructor.get(method2);
                Object[] constructorArgs = this.gatherArgsForConstructor(constructor2, creationArgs);
                Object objectToReturn = constructor2.newInstance(constructorArgs);
                FactoryProvider.this.injector.injectMembers(objectToReturn);
                return objectToReturn;
            }

            public Object[] gatherArgsForConstructor(AssistedConstructor<?> constructor2, Object[] factoryArgs) {
                int numParams = constructor2.getAllParameters().size();
                int argPosition = 0;
                Object[] result2 = new Object[numParams];
                for (int i2 = 0; i2 < numParams; ++i2) {
                    Parameter parameter = constructor2.getAllParameters().get(i2);
                    if (parameter.isProvidedByFactory()) {
                        result2[i2] = factoryArgs[argPosition];
                        ++argPosition;
                        continue;
                    }
                    result2[i2] = parameter.getValue(FactoryProvider.this.injector);
                }
                return result2;
            }
        };
        Class<F> factoryRawType = this.factoryType.getRawType();
        return factoryRawType.cast(Proxy.newProxyInstance(factoryRawType.getClassLoader(), new Class[]{factoryRawType}, invocationHandler));
    }

    private static ConfigurationException newConfigurationException(String format, Object ... args2) {
        return new ConfigurationException(ImmutableSet.of(new Message(Errors.format(format, args2))));
    }
}

