/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.assistedinject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.assistedinject.Parameter;
import org.elasticsearch.common.inject.assistedinject.ParameterListKey;

class AssistedConstructor<T> {
    private final Constructor<T> constructor;
    private final ParameterListKey assistedParameters;
    private final List<Parameter> allParameters;

    public AssistedConstructor(Constructor<T> constructor2, List<TypeLiteral<?>> parameterTypes) {
        this.constructor = constructor2;
        Annotation[][] annotations2 = constructor2.getParameterAnnotations();
        ArrayList<Type> typeList = Lists.newArrayList();
        this.allParameters = new ArrayList<Parameter>();
        for (int i2 = 0; i2 < parameterTypes.size(); ++i2) {
            Parameter parameter = new Parameter(parameterTypes.get(i2).getType(), annotations2[i2]);
            this.allParameters.add(parameter);
            if (!parameter.isProvidedByFactory()) continue;
            typeList.add(parameter.getType());
        }
        this.assistedParameters = new ParameterListKey(typeList);
    }

    public ParameterListKey getAssistedParameters() {
        return this.assistedParameters;
    }

    public List<Parameter> getAllParameters() {
        return this.allParameters;
    }

    public Set<Class<?>> getDeclaredExceptions() {
        return new HashSet(Arrays.asList(this.constructor.getExceptionTypes()));
    }

    public T newInstance(Object[] args2) throws Throwable {
        this.constructor.setAccessible(true);
        try {
            return this.constructor.newInstance(args2);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public String toString() {
        return this.constructor.toString();
    }
}

