/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.internal.InternalFactory;
import org.elasticsearch.common.inject.spi.Dependency;

class SingleParameterInjector<T> {
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private final Dependency<T> dependency;
    private final InternalFactory<? extends T> factory;

    SingleParameterInjector(Dependency<T> dependency, InternalFactory<? extends T> factory) {
        this.dependency = dependency;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T inject(Errors errors, InternalContext context) throws ErrorsException {
        context.setDependency(this.dependency);
        try {
            T t = this.factory.get(errors.withSource(this.dependency), context, this.dependency);
            return t;
        }
        finally {
            context.setDependency(null);
        }
    }

    static Object[] getAll(Errors errors, InternalContext context, SingleParameterInjector<?>[] parameterInjectors) throws ErrorsException {
        if (parameterInjectors == null) {
            return NO_ARGUMENTS;
        }
        int numErrorsBefore = errors.size();
        int size2 = parameterInjectors.length;
        Object[] parameters2 = new Object[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            SingleParameterInjector<?> parameterInjector = parameterInjectors[i2];
            try {
                parameters2[i2] = super.inject(errors, context);
                continue;
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return parameters2;
    }
}

