/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.Collection;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.spi.Message;

public final class ProvisionException
extends RuntimeException {
    private final ImmutableSet<Message> messages;
    private static final long serialVersionUID = 0L;

    public ProvisionException(Iterable<Message> messages) {
        this.messages = ImmutableSet.copyOf(messages);
        Preconditions.checkArgument(!this.messages.isEmpty());
        this.initCause(Errors.getOnlyCause(this.messages));
    }

    public ProvisionException(String message2, Throwable cause2) {
        super(cause2);
        this.messages = ImmutableSet.of(new Message(ImmutableList.<Object>of(), message2, cause2));
    }

    public ProvisionException(String message2) {
        this.messages = ImmutableSet.of(new Message(message2));
    }

    public Collection<Message> getErrorMessages() {
        return this.messages;
    }

    @Override
    public String getMessage() {
        return Errors.format("Guice provision errors", this.messages);
    }
}

