/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.ConstantFactory;
import org.elasticsearch.common.inject.ConstructorBindingImpl;
import org.elasticsearch.common.inject.ConstructorInjectorStore;
import org.elasticsearch.common.inject.ContextualCallable;
import org.elasticsearch.common.inject.DeferredLookups;
import org.elasticsearch.common.inject.ImplementedBy;
import org.elasticsearch.common.inject.Initializables;
import org.elasticsearch.common.inject.Initializer;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorBuilder;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Lookups;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.MembersInjectorImpl;
import org.elasticsearch.common.inject.MembersInjectorStore;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ProvidedBy;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.ProvisionException;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.SingleParameterInjector;
import org.elasticsearch.common.inject.State;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Annotations;
import org.elasticsearch.common.inject.internal.BindingImpl;
import org.elasticsearch.common.inject.internal.Classes;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InstanceBindingImpl;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.internal.InternalFactory;
import org.elasticsearch.common.inject.internal.LinkedBindingImpl;
import org.elasticsearch.common.inject.internal.LinkedProviderBindingImpl;
import org.elasticsearch.common.inject.internal.MatcherAndConverter;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.inject.internal.Scoping;
import org.elasticsearch.common.inject.internal.SourceProvider;
import org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.elasticsearch.common.inject.spi.BindingTargetVisitor;
import org.elasticsearch.common.inject.spi.ConvertedConstantBinding;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.InjectionPoint;
import org.elasticsearch.common.inject.spi.ProviderBinding;
import org.elasticsearch.common.inject.spi.ProviderKeyBinding;
import org.elasticsearch.common.inject.util.Providers;

class InjectorImpl
implements Injector,
Lookups {
    final State state;
    final InjectorImpl parent;
    final BindingsMultimap bindingsMultimap = new BindingsMultimap();
    final Initializer initializer;
    Map<Key<?>, BindingImpl<?>> jitBindings = Maps.newHashMap();
    Lookups lookups = new DeferredLookups(this);
    ConstructorInjectorStore constructors = new ConstructorInjectorStore(this);
    MembersInjectorStore membersInjectorStore;
    final ThreadLocal<Object[]> localContext;

    InjectorImpl(@Nullable InjectorImpl parent, State state2, Initializer initializer) {
        this.parent = parent;
        this.state = state2;
        this.initializer = initializer;
        this.localContext = parent != null ? parent.localContext : new ThreadLocal<Object[]>(){

            @Override
            protected Object[] initialValue() {
                return new Object[1];
            }
        };
    }

    void index() {
        for (Binding<?> binding2 : this.state.getExplicitBindingsThisLevel().values()) {
            this.index(binding2);
        }
    }

    <T> void index(Binding<T> binding2) {
        this.bindingsMultimap.put(binding2.getKey().getTypeLiteral(), binding2);
    }

    @Override
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type2) {
        return this.bindingsMultimap.getAll(type2);
    }

    public <T> BindingImpl<T> getBinding(Key<T> key2) {
        Errors errors = new Errors(key2);
        try {
            BindingImpl<T> result2 = this.getBindingOrThrow(key2, errors);
            errors.throwConfigurationExceptionIfErrorsExist();
            return result2;
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    public <T> BindingImpl<T> getBindingOrThrow(Key<T> key2, Errors errors) throws ErrorsException {
        BindingImpl<T> binding2 = this.state.getExplicitBinding(key2);
        if (binding2 != null) {
            return binding2;
        }
        return this.getJustInTimeBinding(key2, errors);
    }

    @Override
    public <T> Binding<T> getBinding(Class<T> type2) {
        return this.getBinding((Key)Key.get(type2));
    }

    @Override
    public Injector getParent() {
        return this.parent;
    }

    @Override
    public Injector createChildInjector(Iterable<? extends Module> modules) {
        return new InjectorBuilder().parentInjector(this).addModules(modules).build();
    }

    @Override
    public Injector createChildInjector(Module ... modules) {
        return this.createChildInjector(ImmutableList.copyOf(modules));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BindingImpl<T> getJustInTimeBinding(Key<T> key2, Errors errors) throws ErrorsException {
        Object object = this.state.lock();
        synchronized (object) {
            InjectorImpl injector = this;
            while (injector != null) {
                BindingImpl<?> binding2 = injector.jitBindings.get(key2);
                if (binding2 != null) {
                    return binding2;
                }
                injector = injector.parent;
            }
            return this.createJustInTimeBindingRecursive(key2, errors);
        }
    }

    static boolean isProvider(Key<?> key2) {
        return key2.getTypeLiteral().getRawType().equals(Provider.class);
    }

    static boolean isMembersInjector(Key<?> key2) {
        return key2.getTypeLiteral().getRawType().equals(MembersInjector.class) && !key2.hasAnnotationType();
    }

    private <T> BindingImpl<MembersInjector<T>> createMembersInjectorBinding(Key<MembersInjector<T>> key2, Errors errors) throws ErrorsException {
        Type membersInjectorType = key2.getTypeLiteral().getType();
        if (!(membersInjectorType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawMembersInjector().toException();
        }
        TypeLiteral<?> instanceType = TypeLiteral.get(((ParameterizedType)membersInjectorType).getActualTypeArguments()[0]);
        MembersInjectorImpl<?> membersInjector = this.membersInjectorStore.get(instanceType, errors);
        ConstantFactory factory = new ConstantFactory(Initializables.of(membersInjector));
        return new InstanceBindingImpl<MembersInjector<T>>(this, key2, SourceProvider.UNKNOWN_SOURCE, factory, ImmutableSet.<InjectionPoint>of(), membersInjector);
    }

    private <T> BindingImpl<Provider<T>> createProviderBinding(Key<Provider<T>> key2, Errors errors) throws ErrorsException {
        Type providerType = key2.getTypeLiteral().getType();
        if (!(providerType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawProvider().toException();
        }
        Type entryType = ((ParameterizedType)providerType).getActualTypeArguments()[0];
        Key<?> providedKey = key2.ofType(entryType);
        BindingImpl<?> delegate2 = this.getBindingOrThrow(providedKey, errors);
        return new ProviderBindingImpl<T>(this, key2, delegate2);
    }

    private <T> BindingImpl<T> convertConstantStringBinding(Key<T> key2, Errors errors) throws ErrorsException {
        Key<String> stringKey = key2.ofType(String.class);
        BindingImpl<String> stringBinding = this.state.getExplicitBinding(stringKey);
        if (stringBinding == null || !stringBinding.isConstant()) {
            return null;
        }
        String stringValue = stringBinding.getProvider().get();
        Object source2 = stringBinding.getSource();
        TypeLiteral<T> type2 = key2.getTypeLiteral();
        MatcherAndConverter matchingConverter = this.state.getConverter(stringValue, type2, errors, source2);
        if (matchingConverter == null) {
            return null;
        }
        try {
            Object converted = matchingConverter.getTypeConverter().convert(stringValue, type2);
            if (converted == null) {
                throw errors.converterReturnedNull(stringValue, source2, type2, matchingConverter).toException();
            }
            if (!type2.getRawType().isInstance(converted)) {
                throw errors.conversionTypeError(stringValue, source2, type2, matchingConverter, converted).toException();
            }
            return new ConvertedConstantBindingImpl<Object>(this, key2, converted, stringBinding);
        }
        catch (ErrorsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw errors.conversionError(stringValue, source2, type2, matchingConverter, e).toException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void initializeBinding(BindingImpl<T> binding2, Errors errors) throws ErrorsException {
        if (binding2 instanceof ConstructorBindingImpl) {
            Key<T> key2 = binding2.getKey();
            this.jitBindings.put(key2, binding2);
            boolean successful = false;
            try {
                ((ConstructorBindingImpl)binding2).initialize(this, errors);
                successful = true;
            }
            finally {
                if (!successful) {
                    this.jitBindings.remove(key2);
                }
            }
        }
    }

    <T> BindingImpl<T> createUnitializedBinding(Key<T> key2, Scoping scoping, Object source2, Errors errors) throws ErrorsException {
        Class<? extends Annotation> scopeAnnotation;
        Class<T> rawType = key2.getTypeLiteral().getRawType();
        if (rawType.isArray() || rawType.isEnum()) {
            throw errors.missingImplementation(key2).toException();
        }
        if (rawType == TypeLiteral.class) {
            BindingImpl<TypeLiteral<T>> binding2 = this.createTypeLiteralBinding(key2, errors);
            return binding2;
        }
        ImplementedBy implementedBy = rawType.getAnnotation(ImplementedBy.class);
        if (implementedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source2, errors);
            return this.createImplementedByBinding(key2, scoping, implementedBy, errors);
        }
        ProvidedBy providedBy = rawType.getAnnotation(ProvidedBy.class);
        if (providedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source2, errors);
            return this.createProvidedByBinding(key2, scoping, providedBy, errors);
        }
        if (Modifier.isAbstract(rawType.getModifiers())) {
            throw errors.missingImplementation(key2).toException();
        }
        if (Classes.isInnerClass(rawType)) {
            throw errors.cannotInjectInnerClass(rawType).toException();
        }
        if (!scoping.isExplicitlyScoped() && (scopeAnnotation = Annotations.findScopeAnnotation(errors, rawType)) != null) {
            scoping = Scopes.makeInjectable(Scoping.forAnnotation(scopeAnnotation), this, errors.withSource(rawType));
        }
        return ConstructorBindingImpl.create(this, key2, source2, scoping);
    }

    private <T> BindingImpl<TypeLiteral<T>> createTypeLiteralBinding(Key<TypeLiteral<T>> key2, Errors errors) throws ErrorsException {
        Type typeLiteralType = key2.getTypeLiteral().getType();
        if (!(typeLiteralType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawTypeLiteral().toException();
        }
        ParameterizedType parameterizedType = (ParameterizedType)typeLiteralType;
        Type innerType = parameterizedType.getActualTypeArguments()[0];
        if (!(innerType instanceof Class || innerType instanceof GenericArrayType || innerType instanceof ParameterizedType)) {
            throw errors.cannotInjectTypeLiteralOf(innerType).toException();
        }
        TypeLiteral<?> value2 = TypeLiteral.get(innerType);
        ConstantFactory factory = new ConstantFactory(Initializables.of(value2));
        return new InstanceBindingImpl<TypeLiteral<T>>(this, key2, SourceProvider.UNKNOWN_SOURCE, factory, ImmutableSet.<InjectionPoint>of(), value2);
    }

    <T> BindingImpl<T> createProvidedByBinding(Key<T> key2, Scoping scoping, ProvidedBy providedBy, Errors errors) throws ErrorsException {
        final Class<T> rawType = key2.getTypeLiteral().getRawType();
        final Class<? extends Provider<?>> providerType = providedBy.value();
        if (providerType == rawType) {
            throw errors.recursiveProviderType().toException();
        }
        final Key<? extends Provider<?>> providerKey = Key.get(providerType);
        final BindingImpl<? extends Provider<?>> providerBinding = this.getBindingOrThrow(providerKey, errors);
        InternalFactory internalFactory = new InternalFactory<T>(){

            @Override
            public T get(Errors errors, InternalContext context, Dependency dependency) throws ErrorsException {
                errors = errors.withSource(providerKey);
                Provider provider = (Provider)providerBinding.getInternalFactory().get(errors, context, dependency);
                try {
                    Object o = provider.get();
                    if (o != null && !rawType.isInstance(o)) {
                        throw errors.subtypeNotProvided(providerType, rawType).toException();
                    }
                    Object t = o;
                    return t;
                }
                catch (RuntimeException e) {
                    throw errors.errorInProvider(e).toException();
                }
            }
        };
        return new LinkedProviderBindingImpl<T>(this, key2, rawType, Scopes.scope(key2, this, internalFactory, scoping), scoping, providerKey);
    }

    <T> BindingImpl<T> createImplementedByBinding(Key<T> key2, Scoping scoping, ImplementedBy implementedBy, Errors errors) throws ErrorsException {
        Class<T> rawType = key2.getTypeLiteral().getRawType();
        Class<?> implementationType = implementedBy.value();
        if (implementationType == rawType) {
            throw errors.recursiveImplementationType().toException();
        }
        if (!rawType.isAssignableFrom(implementationType)) {
            throw errors.notASubtype(implementationType, rawType).toException();
        }
        Class<?> subclass = implementationType;
        final Key<?> targetKey = Key.get(subclass);
        final BindingImpl<?> targetBinding = this.getBindingOrThrow(targetKey, errors);
        InternalFactory internalFactory = new InternalFactory<T>(){

            @Override
            public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
                return targetBinding.getInternalFactory().get(errors.withSource(targetKey), context, dependency);
            }
        };
        return new LinkedBindingImpl<T>(this, key2, rawType, Scopes.scope(key2, this, internalFactory, scoping), scoping, targetKey);
    }

    private <T> BindingImpl<T> createJustInTimeBindingRecursive(Key<T> key2, Errors errors) throws ErrorsException {
        if (this.parent != null) {
            try {
                return this.parent.createJustInTimeBindingRecursive(key2, new Errors());
            }
            catch (ErrorsException ignored) {
                // empty catch block
            }
        }
        if (this.state.isBlacklisted(key2)) {
            throw errors.childBindingAlreadySet(key2).toException();
        }
        BindingImpl<T> binding2 = this.createJustInTimeBinding(key2, errors);
        this.state.parent().blacklist(key2);
        this.jitBindings.put(key2, binding2);
        return binding2;
    }

    <T> BindingImpl<T> createJustInTimeBinding(Key<T> key2, Errors errors) throws ErrorsException {
        if (this.state.isBlacklisted(key2)) {
            throw errors.childBindingAlreadySet(key2).toException();
        }
        if (InjectorImpl.isProvider(key2)) {
            BindingImpl<Provider<T>> binding2 = this.createProviderBinding(key2, errors);
            return binding2;
        }
        if (InjectorImpl.isMembersInjector(key2)) {
            BindingImpl<MembersInjector<T>> binding3 = this.createMembersInjectorBinding(key2, errors);
            return binding3;
        }
        BindingImpl<Provider<T>> convertedBinding = this.convertConstantStringBinding(key2, errors);
        if (convertedBinding != null) {
            return convertedBinding;
        }
        if (key2.hasAnnotationType()) {
            if (key2.hasAttributes()) {
                try {
                    Errors ignored = new Errors();
                    return this.getBindingOrThrow(key2.withoutAttributes(), ignored);
                }
                catch (ErrorsException ignored) {
                    // empty catch block
                }
            }
            throw errors.missingImplementation(key2).toException();
        }
        Class<Provider<T>> source2 = key2.getTypeLiteral().getRawType();
        BindingImpl<Provider<T>> binding4 = this.createUnitializedBinding(key2, Scoping.UNSCOPED, source2, errors);
        this.initializeBinding(binding4, errors);
        return binding4;
    }

    <T> InternalFactory<? extends T> getInternalFactory(Key<T> key2, Errors errors) throws ErrorsException {
        return this.getBindingOrThrow(key2, errors).getInternalFactory();
    }

    @Override
    public Map<Key<?>, Binding<?>> getBindings() {
        return this.state.getExplicitBindingsThisLevel();
    }

    SingleParameterInjector<?>[] getParametersInjectors(List<Dependency<?>> parameters2, Errors errors) throws ErrorsException {
        if (parameters2.isEmpty()) {
            return null;
        }
        int numErrorsBefore = errors.size();
        SingleParameterInjector[] result2 = new SingleParameterInjector[parameters2.size()];
        int i2 = 0;
        for (Dependency<?> parameter : parameters2) {
            try {
                result2[i2++] = this.createParameterInjector(parameter, errors.withSource(parameter));
            }
            catch (ErrorsException rethrownBelow) {}
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return result2;
    }

    <T> SingleParameterInjector<T> createParameterInjector(Dependency<T> dependency, Errors errors) throws ErrorsException {
        InternalFactory<T> factory = this.getInternalFactory(dependency.getKey(), errors);
        return new SingleParameterInjector<T>(dependency, factory);
    }

    @Override
    public void injectMembers(Object instance) {
        MembersInjector<?> membersInjector = this.getMembersInjector(instance.getClass());
        membersInjector.injectMembers(instance);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Errors errors = new Errors(typeLiteral);
        try {
            return this.membersInjectorStore.get(typeLiteral, errors);
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type2) {
        return this.getMembersInjector(TypeLiteral.get(type2));
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type2) {
        return this.getProvider(Key.get(type2));
    }

    <T> Provider<T> getProviderOrThrow(Key<T> key2, Errors errors) throws ErrorsException {
        final InternalFactory<T> factory = this.getInternalFactory(key2, errors);
        final Dependency<T> dependency = Dependency.get(key2);
        return new Provider<T>(){

            @Override
            public T get() {
                final Errors errors = new Errors(dependency);
                try {
                    Object t = InjectorImpl.this.callInContext(new ContextualCallable<T>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public T call(InternalContext context) throws ErrorsException {
                            context.setDependency(dependency);
                            try {
                                Object t = factory.get(errors, context, dependency);
                                return t;
                            }
                            finally {
                                context.setDependency(null);
                            }
                        }
                    });
                    errors.throwIfNewErrors(0);
                    return t;
                }
                catch (ErrorsException e) {
                    throw new ProvisionException(errors.merge(e.getErrors()).getMessages());
                }
            }

            public String toString() {
                return factory.toString();
            }
        };
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key2) {
        Errors errors = new Errors(key2);
        try {
            Provider<T> result2 = this.getProviderOrThrow(key2, errors);
            errors.throwIfNewErrors(0);
            return result2;
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    @Override
    public <T> T getInstance(Key<T> key2) {
        return this.getProvider(key2).get();
    }

    @Override
    public <T> T getInstance(Class<T> type2) {
        return this.getProvider(type2).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T callInContext(ContextualCallable<T> callable) throws ErrorsException {
        Object[] reference2 = this.localContext.get();
        if (reference2[0] == null) {
            reference2[0] = new InternalContext();
            try {
                T t = callable.call((InternalContext)reference2[0]);
                return t;
            }
            finally {
                reference2[0] = null;
            }
        }
        return callable.call((InternalContext)reference2[0]);
    }

    public String toString() {
        return new ToStringBuilder(Injector.class).add("bindings", this.state.getExplicitBindingsThisLevel().values()).toString();
    }

    public void clearCache() {
        this.state.clearBlacklisted();
        this.constructors = new ConstructorInjectorStore(this);
        this.membersInjectorStore = new MembersInjectorStore(this, this.state.getTypeListenerBindings());
        this.jitBindings = Maps.newHashMap();
    }

    static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException;
    }

    private static class BindingsMultimap {
        final Map<TypeLiteral<?>, List<Binding<?>>> multimap = Maps.newHashMap();

        private BindingsMultimap() {
        }

        <T> void put(TypeLiteral<T> type2, Binding<T> binding2) {
            List<Binding<?>> bindingsForType = this.multimap.get(type2);
            if (bindingsForType == null) {
                bindingsForType = Lists.newArrayList();
                this.multimap.put(type2, bindingsForType);
            }
            bindingsForType.add(binding2);
        }

        <T> List<Binding<T>> getAll(TypeLiteral<T> type2) {
            List<Binding<?>> bindings = this.multimap.get(type2);
            return bindings != null ? Collections.unmodifiableList(this.multimap.get(type2)) : ImmutableList.of();
        }
    }

    private static class ConvertedConstantBindingImpl<T>
    extends BindingImpl<T>
    implements ConvertedConstantBinding<T> {
        final T value;
        final Provider<T> provider;
        final Binding<String> originalBinding;

        ConvertedConstantBindingImpl(Injector injector, Key<T> key2, T value2, Binding<String> originalBinding) {
            super(injector, key2, originalBinding.getSource(), new ConstantFactory<T>(Initializables.of(value2)), Scoping.UNSCOPED);
            this.value = value2;
            this.provider = Providers.of(value2);
            this.originalBinding = originalBinding;
        }

        @Override
        public Provider<T> getProvider() {
            return this.provider;
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
            return visitor.visit(this);
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public Key<String> getSourceKey() {
            return this.originalBinding.getKey();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of(Dependency.get(this.getSourceKey()));
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return new ToStringBuilder(ConvertedConstantBinding.class).add("key", this.getKey()).add("sourceKey", this.getSourceKey()).add("value", this.value).toString();
        }
    }

    static class ProviderBindingImpl<T>
    extends BindingImpl<Provider<T>>
    implements ProviderBinding<Provider<T>> {
        final BindingImpl<T> providedBinding;

        ProviderBindingImpl(InjectorImpl injector, Key<Provider<T>> key2, Binding<T> providedBinding) {
            super(injector, key2, providedBinding.getSource(), ProviderBindingImpl.createInternalFactory(providedBinding), Scoping.UNSCOPED);
            this.providedBinding = (BindingImpl)providedBinding;
        }

        static <T> InternalFactory<Provider<T>> createInternalFactory(Binding<T> providedBinding) {
            final Provider<T> provider = providedBinding.getProvider();
            return new InternalFactory<Provider<T>>(){

                @Override
                public Provider<T> get(Errors errors, InternalContext context, Dependency dependency) {
                    return provider;
                }
            };
        }

        @Override
        public Key<? extends T> getProvidedKey() {
            return this.providedBinding.getKey();
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super Provider<T>, V> visitor) {
            return visitor.visit(this);
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return new ToStringBuilder(ProviderKeyBinding.class).add("key", this.getKey()).add("providedKey", this.getProvidedKey()).toString();
        }
    }
}

