/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.List;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.AbstractProcessor;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.BoundProviderFactory;
import org.elasticsearch.common.inject.ConstantFactory;
import org.elasticsearch.common.inject.ExposedKeyFactory;
import org.elasticsearch.common.inject.FactoryProxy;
import org.elasticsearch.common.inject.Initializable;
import org.elasticsearch.common.inject.Initializer;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.InternalFactoryToProviderAdapter;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Scope;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Annotations;
import org.elasticsearch.common.inject.internal.BindingImpl;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.ExposedBindingImpl;
import org.elasticsearch.common.inject.internal.InstanceBindingImpl;
import org.elasticsearch.common.inject.internal.InternalFactory;
import org.elasticsearch.common.inject.internal.LinkedBindingImpl;
import org.elasticsearch.common.inject.internal.LinkedProviderBindingImpl;
import org.elasticsearch.common.inject.internal.ProviderInstanceBindingImpl;
import org.elasticsearch.common.inject.internal.ProviderMethod;
import org.elasticsearch.common.inject.internal.Scoping;
import org.elasticsearch.common.inject.internal.UntargettedBindingImpl;
import org.elasticsearch.common.inject.spi.BindingTargetVisitor;
import org.elasticsearch.common.inject.spi.ConstructorBinding;
import org.elasticsearch.common.inject.spi.ConvertedConstantBinding;
import org.elasticsearch.common.inject.spi.ExposedBinding;
import org.elasticsearch.common.inject.spi.InjectionPoint;
import org.elasticsearch.common.inject.spi.InstanceBinding;
import org.elasticsearch.common.inject.spi.LinkedKeyBinding;
import org.elasticsearch.common.inject.spi.PrivateElements;
import org.elasticsearch.common.inject.spi.ProviderBinding;
import org.elasticsearch.common.inject.spi.ProviderInstanceBinding;
import org.elasticsearch.common.inject.spi.ProviderKeyBinding;
import org.elasticsearch.common.inject.spi.UntargettedBinding;

class BindingProcessor
extends AbstractProcessor {
    private final List<CreationListener> creationListeners = Lists.newArrayList();
    private final Initializer initializer;
    private final List<Runnable> uninitializedBindings = Lists.newArrayList();
    private static final Set<Class<?>> FORBIDDEN_TYPES = ImmutableSet.of(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, new Class[]{Module.class, Provider.class, Scope.class, TypeLiteral.class});

    BindingProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        final Object source2 = command.getSource();
        if (Void.class.equals(command.getKey().getRawType())) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getProviderInstance() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        final Key<T> key2 = command.getKey();
        Class<T> rawType = key2.getTypeLiteral().getRawType();
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        this.validateKey(command.getSource(), command.getKey());
        final Scoping scoping = Scopes.makeInjectable(((BindingImpl)command).getScoping(), this.injector, this.errors);
        command.acceptTargetVisitor(new BindingTargetVisitor<T, Void>(){

            @Override
            public Void visit(InstanceBinding<? extends T> binding2) {
                Set<InjectionPoint> injectionPoints = binding2.getInjectionPoints();
                Object instance = binding2.getInstance();
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, instance, source2, injectionPoints);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scopes.scope(key2, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, key2, source2, scopedFactory, injectionPoints, instance));
                return null;
            }

            @Override
            public Void visit(ProviderInstanceBinding<? extends T> binding2) {
                Provider provider = binding2.getProviderInstance();
                Set<InjectionPoint> injectionPoints = binding2.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, provider, source2, injectionPoints);
                InternalFactoryToProviderAdapter factory = new InternalFactoryToProviderAdapter(initializable, source2);
                InternalFactory scopedFactory = Scopes.scope(key2, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, key2, source2, scopedFactory, scoping, provider, injectionPoints));
                return null;
            }

            @Override
            public Void visit(ProviderKeyBinding<? extends T> binding2) {
                Key providerKey = binding2.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, source2);
                BindingProcessor.this.creationListeners.add(boundProviderFactory);
                InternalFactory scopedFactory = Scopes.scope(key2, BindingProcessor.this.injector, boundProviderFactory, scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, key2, source2, scopedFactory, scoping, providerKey));
                return null;
            }

            @Override
            public Void visit(LinkedKeyBinding<? extends T> binding2) {
                Key linkedKey = binding2.getLinkedKey();
                if (key2.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding();
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, key2, linkedKey, source2);
                BindingProcessor.this.creationListeners.add(factory);
                InternalFactory scopedFactory = Scopes.scope(key2, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, key2, source2, scopedFactory, scoping, linkedKey));
                return null;
            }

            @Override
            public Void visit(UntargettedBinding<? extends T> untargetted) {
                BindingImpl binding2;
                if (key2.hasAnnotationType()) {
                    BindingProcessor.this.errors.missingImplementation(key2);
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, key2, source2));
                    return null;
                }
                try {
                    binding2 = BindingProcessor.this.injector.createUnitializedBinding(key2, scoping, source2, BindingProcessor.this.errors);
                    BindingProcessor.this.putBinding(binding2);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, key2, source2));
                    return null;
                }
                BindingProcessor.this.uninitializedBindings.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((InjectorImpl)binding2.getInjector()).initializeBinding(binding2, BindingProcessor.this.errors.withSource(source2));
                        }
                        catch (ErrorsException e) {
                            BindingProcessor.this.errors.merge(e.getErrors());
                        }
                    }
                });
                return null;
            }

            @Override
            public Void visit(ExposedBinding<? extends T> binding2) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ConvertedConstantBinding<? extends T> binding2) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ConstructorBinding<? extends T> binding2) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ProviderBinding<? extends T> binding2) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }
        });
        return true;
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key2 : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key2);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key2) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key2, privateElements);
        this.creationListeners.add(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>((Injector)this.injector, privateElements.getExposedSource(key2), key2, exposedKeyFactory, privateElements));
    }

    private <T> void validateKey(Object source2, Key<T> key2) {
        Annotations.checkForMisplacedScopeAnnotations(key2.getRawType(), source2, this.errors);
    }

    <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injector, Key<T> key2, Object source2) {
        return new UntargettedBindingImpl<T>(injector, key2, source2);
    }

    public void initializeBindings() {
        for (Runnable initializer : this.uninitializedBindings) {
            initializer.run();
        }
    }

    public void runCreationListeners() {
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(this.errors);
        }
    }

    private void putBinding(BindingImpl<?> binding2) {
        Key<?> key2 = binding2.getKey();
        Class<?> rawType = key2.getRawType();
        if (FORBIDDEN_TYPES.contains(rawType)) {
            this.errors.cannotBindToGuiceType(rawType.getSimpleName());
            return;
        }
        BindingImpl<?> original = this.injector.state.getExplicitBinding(key2);
        if (original != null && !this.isOkayDuplicate(original, binding2)) {
            this.errors.bindingAlreadySet(key2, original.getSource());
            return;
        }
        this.injector.state.parent().blacklist(key2);
        this.injector.state.putBinding(key2, binding2);
    }

    private boolean isOkayDuplicate(Binding<?> original, BindingImpl<?> binding2) {
        if (original instanceof ExposedBindingImpl) {
            ExposedBindingImpl exposed = (ExposedBindingImpl)original;
            InjectorImpl exposedFrom = (InjectorImpl)exposed.getPrivateElements().getInjector();
            return exposedFrom == binding2.getInjector();
        }
        return false;
    }

    static interface CreationListener {
        public void notify(Errors var1);
    }
}

