/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.http.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.elasticsearch.common.Nullable;

public class HttpDownloadHelper {
    private boolean useTimestamp = false;
    private boolean skipExisting = false;
    private long maxTime = 0L;

    public boolean download(URL source2, File dest, @Nullable DownloadProgress progress) throws IOException {
        if (dest.exists() && this.skipExisting) {
            return true;
        }
        if (progress == null) {
            progress = new NullProgress();
        }
        long timestamp = 0L;
        boolean hasTimestamp = false;
        if (this.useTimestamp && dest.exists()) {
            timestamp = dest.lastModified();
            hasTimestamp = true;
        }
        GetThread getThread = new GetThread(source2, dest, hasTimestamp, timestamp, progress);
        getThread.setDaemon(true);
        getThread.start();
        try {
            getThread.join(this.maxTime * 1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (getThread.isAlive()) {
            String msg = "The GET operation took longer than " + this.maxTime + " seconds, stopping it.";
            getThread.closeStreams();
            throw new IOException(msg);
        }
        return getThread.wasSuccessful();
    }

    private class GetThread
    extends Thread {
        private final URL source;
        private final File dest;
        private final boolean hasTimestamp;
        private final long timestamp;
        private final DownloadProgress progress;
        private boolean success = false;
        private IOException ioexception = null;
        private InputStream is = null;
        private OutputStream os = null;
        private URLConnection connection;
        private int redirections = 0;

        GetThread(URL source2, File dest, boolean h, long t, DownloadProgress p2) {
            this.source = source2;
            this.dest = dest;
            this.hasTimestamp = h;
            this.timestamp = t;
            this.progress = p2;
        }

        @Override
        public void run() {
            try {
                this.success = this.get();
            }
            catch (IOException ioex) {
                this.ioexception = ioex;
            }
        }

        private boolean get() throws IOException {
            this.connection = this.openConnection(this.source);
            if (this.connection == null) {
                return false;
            }
            boolean downloadSucceeded = this.downloadFile();
            if (downloadSucceeded && HttpDownloadHelper.this.useTimestamp) {
                this.updateTimeStamp();
            }
            return downloadSucceeded;
        }

        private boolean redirectionAllowed(URL aSource, URL aDest) throws IOException {
            ++this.redirections;
            if (this.redirections > 5) {
                String message2 = "More than 5 times redirected, giving up";
                throw new IOException(message2);
            }
            return true;
        }

        private URLConnection openConnection(URL aSource) throws IOException {
            URLConnection connection = aSource.openConnection();
            if (this.hasTimestamp) {
                connection.setIfModifiedSince(this.timestamp);
            }
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setInstanceFollowRedirects(false);
                ((HttpURLConnection)connection).setUseCaches(true);
                ((HttpURLConnection)connection).setConnectTimeout(5000);
            }
            connection.connect();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                    String newLocation = httpConnection.getHeaderField("Location");
                    String message2 = aSource + (responseCode == 301 ? " permanently" : "") + " moved to " + newLocation;
                    URL newURL = new URL(newLocation);
                    if (!this.redirectionAllowed(aSource, newURL)) {
                        return null;
                    }
                    return this.openConnection(newURL);
                }
                long lastModified = httpConnection.getLastModified();
                if (responseCode == 304 || lastModified != 0L && this.hasTimestamp && this.timestamp >= lastModified) {
                    return null;
                }
                if (responseCode == 401) {
                    String message3 = "HTTP Authorization failure";
                    throw new IOException(message3);
                }
            }
            return connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean downloadFile() throws FileNotFoundException, IOException {
            IOException lastEx = null;
            for (int i2 = 0; i2 < 3; ++i2) {
                try {
                    this.is = this.connection.getInputStream();
                    break;
                }
                catch (IOException ex) {
                    lastEx = ex;
                    continue;
                }
            }
            if (this.is == null) {
                throw new IOException("Can't get " + this.source + " to " + this.dest, lastEx);
            }
            this.os = new FileOutputStream(this.dest);
            this.progress.beginDownload();
            boolean finished = false;
            try {
                int length2;
                byte[] buffer = new byte[102400];
                while (!this.isInterrupted() && (length2 = this.is.read(buffer)) >= 0) {
                    this.os.write(buffer, 0, length2);
                    this.progress.onTick();
                }
                finished = !this.isInterrupted();
            }
            finally {
                try {
                    this.os.close();
                }
                catch (IOException e) {}
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
                if (!finished) {
                    this.dest.delete();
                }
            }
            this.progress.endDownload();
            return true;
        }

        private void updateTimeStamp() {
            long remoteTimestamp = this.connection.getLastModified();
            if (remoteTimestamp != 0L) {
                this.dest.setLastModified(remoteTimestamp);
            }
        }

        boolean wasSuccessful() throws IOException {
            if (this.ioexception != null) {
                throw this.ioexception;
            }
            return this.success;
        }

        void closeStreams() {
            this.interrupt();
            try {
                this.os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.success && this.dest.exists()) {
                this.dest.delete();
            }
        }
    }

    public static class VerboseProgress
    implements DownloadProgress {
        private int dots = 0;
        PrintStream out;

        public VerboseProgress(PrintStream out) {
            this.out = out;
        }

        @Override
        public void beginDownload() {
            this.out.print("Downloading ");
            this.dots = 0;
        }

        @Override
        public void onTick() {
            this.out.print(".");
            if (this.dots++ > 50) {
                this.out.flush();
                this.dots = 0;
            }
        }

        @Override
        public void endDownload() {
            this.out.println("DONE");
            this.out.flush();
        }
    }

    public static class NullProgress
    implements DownloadProgress {
        @Override
        public void beginDownload() {
        }

        @Override
        public void onTick() {
        }

        @Override
        public void endDownload() {
        }
    }

    public static interface DownloadProgress {
        public void beginDownload();

        public void onTick();

        public void endDownload();
    }
}

