/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.impl.RectangleImpl;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.geo.GeoShapeConstants;
import org.elasticsearch.common.xcontent.XContentParser;

public class GeoJSONShapeParser {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    private GeoJSONShapeParser() {
    }

    public static Shape parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticSearchParseException("Shape must be an object consisting of type and coordinates");
        }
        String shapeType = null;
        CoordinateNode node = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            if ("type".equals(fieldName)) {
                token = parser.nextToken();
                shapeType = parser.text().toLowerCase(Locale.ENGLISH);
                if (shapeType != null) continue;
                throw new ElasticSearchParseException("Unknown Shape type [" + parser.text() + "]");
            }
            if (!"coordinates".equals(fieldName)) continue;
            token = parser.nextToken();
            node = GeoJSONShapeParser.parseCoordinates(parser);
        }
        if (shapeType == null) {
            throw new ElasticSearchParseException("Shape type not included");
        }
        if (node == null) {
            throw new ElasticSearchParseException("Coordinates not included");
        }
        return GeoJSONShapeParser.buildShape(shapeType, node);
    }

    private static CoordinateNode parseCoordinates(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_ARRAY) {
            double lon = parser.doubleValue();
            token = parser.nextToken();
            double lat = parser.doubleValue();
            token = parser.nextToken();
            return new CoordinateNode(new Coordinate(lon, lat));
        }
        ArrayList<CoordinateNode> nodes = new ArrayList<CoordinateNode>();
        while (token != XContentParser.Token.END_ARRAY) {
            nodes.add(GeoJSONShapeParser.parseCoordinates(parser));
            token = parser.nextToken();
        }
        return new CoordinateNode(nodes);
    }

    private static Shape buildShape(String shapeType, CoordinateNode node) {
        if ("point".equals(shapeType)) {
            return new JtsPoint(GEOMETRY_FACTORY.createPoint(node.coordinate), GeoShapeConstants.SPATIAL_CONTEXT);
        }
        if ("linestring".equals(shapeType)) {
            return new JtsGeometry(GEOMETRY_FACTORY.createLineString(GeoJSONShapeParser.toCoordinates(node)), GeoShapeConstants.SPATIAL_CONTEXT, true);
        }
        if ("polygon".equals(shapeType)) {
            return new JtsGeometry(GeoJSONShapeParser.buildPolygon(node), GeoShapeConstants.SPATIAL_CONTEXT, true);
        }
        if ("multipoint".equals(shapeType)) {
            return new JtsGeometry(GEOMETRY_FACTORY.createMultiPoint(GeoJSONShapeParser.toCoordinates(node)), GeoShapeConstants.SPATIAL_CONTEXT, true);
        }
        if ("envelope".equals(shapeType)) {
            Coordinate[] coordinates = GeoJSONShapeParser.toCoordinates(node);
            return new RectangleImpl(coordinates[0].x, coordinates[1].x, coordinates[1].y, coordinates[0].y, GeoShapeConstants.SPATIAL_CONTEXT);
        }
        if ("multipolygon".equals(shapeType)) {
            Polygon[] polygons = new Polygon[node.children.size()];
            for (int i2 = 0; i2 < node.children.size(); ++i2) {
                polygons[i2] = GeoJSONShapeParser.buildPolygon((CoordinateNode)node.children.get(i2));
            }
            return new JtsGeometry(GEOMETRY_FACTORY.createMultiPolygon(polygons), GeoShapeConstants.SPATIAL_CONTEXT, true);
        }
        throw new UnsupportedOperationException("ShapeType [" + shapeType + "] not supported");
    }

    private static Polygon buildPolygon(CoordinateNode node) {
        LinearRing shell = GEOMETRY_FACTORY.createLinearRing(GeoJSONShapeParser.toCoordinates((CoordinateNode)node.children.get(0)));
        LinearRing[] holes = null;
        if (node.children.size() > 1) {
            holes = new LinearRing[node.children.size() - 1];
            for (int i2 = 0; i2 < node.children.size() - 1; ++i2) {
                holes[i2] = GEOMETRY_FACTORY.createLinearRing(GeoJSONShapeParser.toCoordinates((CoordinateNode)node.children.get(i2 + 1)));
            }
        }
        return GEOMETRY_FACTORY.createPolygon(shell, holes);
    }

    private static Coordinate[] toCoordinates(CoordinateNode node) {
        Coordinate[] coordinates = new Coordinate[node.children.size()];
        for (int i2 = 0; i2 < node.children.size(); ++i2) {
            coordinates[i2] = ((CoordinateNode)node.children.get(i2)).coordinate;
        }
        return coordinates;
    }

    private static class CoordinateNode {
        private Coordinate coordinate;
        private List<CoordinateNode> children;

        private CoordinateNode(Coordinate coordinate) {
            this.coordinate = coordinate;
        }

        private CoordinateNode(List<CoordinateNode> children) {
            this.children = children;
        }
    }
}

