/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy.xerial;

import java.io.IOException;
import org.elasticsearch.common.compress.snappy.SnappyCompressedStreamInput;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.elasticsearch.common.io.stream.StreamInput;
import org.xerial.snappy.Snappy;

public class XerialSnappyCompressedStreamInput
extends SnappyCompressedStreamInput {
    public XerialSnappyCompressedStreamInput(StreamInput in, SnappyCompressorContext context) throws IOException {
        super(in, context);
    }

    @Override
    protected int uncompress(StreamInput in, byte[] out) throws IOException {
        int compressedByte = in.read();
        if (compressedByte == -1) {
            return 0;
        }
        boolean compressed = compressedByte == 1;
        int length2 = in.readVInt();
        if (!compressed) {
            in.readBytes(out, 0, length2);
            return length2;
        }
        in.readBytes(this.inputBuffer, 0, length2);
        return Snappy.rawUncompress(this.inputBuffer, 0, length2, out, 0);
    }
}

