/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;

public abstract class SnappyCompressor
implements Compressor {
    public static final byte[] HEADER = new byte[]{115, 110, 97, 112, 112, 121, 0};
    protected SnappyCompressorContext compressorContext = new SnappyCompressorContext(32768, this.maxCompressedLength(32768));
    static final int DEFAULT_CHUNK_SIZE = 32768;

    protected SnappyCompressor() {
    }

    @Override
    public void configure(Settings settings) {
        int chunkLength = (int)settings.getAsBytesSize("compress.snappy.chunk_size", new ByteSizeValue(this.compressorContext.compressChunkLength())).bytes();
        int maxCompressedChunkLength = this.maxCompressedLength(chunkLength);
        this.compressorContext = new SnappyCompressorContext(chunkLength, maxCompressedChunkLength);
    }

    protected abstract int maxCompressedLength(int var1);

    @Override
    public boolean isCompressed(byte[] data2, int offset2, int length2) {
        if (length2 < HEADER.length) {
            return false;
        }
        for (int i2 = 0; i2 < HEADER.length; ++i2) {
            if (data2[offset2 + i2] == HEADER[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompressed(BytesReference bytes2) {
        if (bytes2.length() < HEADER.length) {
            return false;
        }
        for (int i2 = 0; i2 < HEADER.length; ++i2) {
            if (bytes2.get(i2) == HEADER[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompressed(ChannelBuffer buffer) {
        if (buffer.readableBytes() < HEADER.length) {
            return false;
        }
        int offset2 = buffer.readerIndex();
        for (int i2 = 0; i2 < HEADER.length; ++i2) {
            if (buffer.getByte(offset2 + i2) == HEADER[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompressed(IndexInput in) throws IOException {
        long currentPointer = in.getFilePointer();
        if (in.length() - currentPointer < (long)HEADER.length) {
            return false;
        }
        for (int i2 = 0; i2 < HEADER.length; ++i2) {
            if (in.readByte() == HEADER[i2]) continue;
            in.seek(currentPointer);
            return false;
        }
        in.seek(currentPointer);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compress(byte[] data2, int offset2, int length2) throws IOException {
        CachedStreamOutput.Entry entry = CachedStreamOutput.popEntry();
        try {
            StreamOutput compressed = entry.bytes(this);
            compressed.writeBytes(data2, offset2, length2);
            compressed.close();
            byte[] byArray = entry.bytes().bytes().copyBytesArray().toBytes();
            return byArray;
        }
        finally {
            CachedStreamOutput.pushEntry(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] uncompress(byte[] data2, int offset2, int length2) throws IOException {
        CompressedStreamInput compressed = this.streamInput(new BytesStreamInput(data2, offset2, length2, false));
        CachedStreamOutput.Entry entry = CachedStreamOutput.popEntry();
        try {
            Streams.copy(compressed, (OutputStream)entry.bytes());
            byte[] byArray = entry.bytes().bytes().copyBytesArray().toBytes();
            return byArray;
        }
        finally {
            CachedStreamOutput.pushEntry(entry);
        }
    }
}

