/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedIndexInput;
import org.elasticsearch.common.compress.CompressedIndexOutput;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.lzf.ChunkDecoder;
import org.elasticsearch.common.compress.lzf.LZFCompressedIndexInput;
import org.elasticsearch.common.compress.lzf.LZFCompressedIndexOutput;
import org.elasticsearch.common.compress.lzf.LZFCompressedStreamInput;
import org.elasticsearch.common.compress.lzf.LZFCompressedStreamOutput;
import org.elasticsearch.common.compress.lzf.LZFEncoder;
import org.elasticsearch.common.compress.lzf.util.ChunkDecoderFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.settings.Settings;

public class LZFCompressor
implements Compressor {
    static final byte[] LUCENE_HEADER = new byte[]{76, 90, 70, 0};
    public static final String TYPE = "lzf";
    private ChunkDecoder decoder = ChunkDecoderFactory.optimalInstance();

    public LZFCompressor() {
        Loggers.getLogger(LZFCompressor.class).debug("using [{}] decoder", this.decoder.getClass().getSimpleName());
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void configure(Settings settings) {
        String decoderType = settings.get("compress.lzf.decoder", null);
        if (decoderType != null) {
            if ("optimal".equalsIgnoreCase(decoderType)) {
                this.decoder = ChunkDecoderFactory.optimalInstance();
                Loggers.getLogger(LZFCompressor.class).debug("using [{}] decoder", this.decoder.getClass().getSimpleName());
            } else if ("safe".equalsIgnoreCase(decoderType)) {
                this.decoder = ChunkDecoderFactory.safeInstance();
                Loggers.getLogger(LZFCompressor.class).debug("using [{}] decoder", this.decoder.getClass().getSimpleName());
            } else {
                Loggers.getLogger(LZFCompressor.class).warn("decoder type not recognized [{}], still using [{}]", decoderType, this.decoder.getClass().getSimpleName());
            }
        }
    }

    @Override
    public boolean isCompressed(BytesReference bytes2) {
        return bytes2.length() >= 3 && bytes2.get(0) == 90 && bytes2.get(1) == 86 && (bytes2.get(2) == 1 || bytes2.get(2) == 0);
    }

    @Override
    public boolean isCompressed(byte[] data2, int offset2, int length2) {
        return length2 >= 3 && data2[offset2] == 90 && data2[offset2 + 1] == 86 && (data2[offset2 + 2] == 1 || data2[offset2 + 2] == 0);
    }

    @Override
    public boolean isCompressed(ChannelBuffer buffer) {
        int offset2 = buffer.readerIndex();
        return buffer.readableBytes() >= 3 && buffer.getByte(offset2) == 90 && buffer.getByte(offset2 + 1) == 86 && (buffer.getByte(offset2 + 2) == 1 || buffer.getByte(offset2 + 2) == 0);
    }

    @Override
    public boolean isCompressed(IndexInput in) throws IOException {
        long currentPointer = in.getFilePointer();
        if (in.length() - currentPointer < (long)LUCENE_HEADER.length) {
            return false;
        }
        for (int i2 = 0; i2 < LUCENE_HEADER.length; ++i2) {
            if (in.readByte() == LUCENE_HEADER[i2]) continue;
            in.seek(currentPointer);
            return false;
        }
        in.seek(currentPointer);
        return true;
    }

    @Override
    public byte[] uncompress(byte[] data2, int offset2, int length2) throws IOException {
        return this.decoder.decode(data2, offset2, length2);
    }

    @Override
    public byte[] compress(byte[] data2, int offset2, int length2) throws IOException {
        return LZFEncoder.encode(data2, offset2, length2);
    }

    @Override
    public CompressedStreamInput streamInput(StreamInput in) throws IOException {
        return new LZFCompressedStreamInput(in, this.decoder);
    }

    @Override
    public CompressedStreamOutput streamOutput(StreamOutput out) throws IOException {
        return new LZFCompressedStreamOutput(out);
    }

    @Override
    public CompressedIndexInput indexInput(IndexInput in) throws IOException {
        return new LZFCompressedIndexInput(in, this.decoder);
    }

    @Override
    public CompressedIndexOutput indexOutput(IndexOutput out) throws IOException {
        return new LZFCompressedIndexOutput(out);
    }
}

