/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import org.elasticsearch.common.compress.BufferRecycler;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;
import org.elasticsearch.common.compress.lzf.LZFCompressorContext;
import org.elasticsearch.common.io.stream.StreamOutput;

public class LZFCompressedStreamOutput
extends CompressedStreamOutput<LZFCompressorContext> {
    private final BufferRecycler recycler = BufferRecycler.instance();
    private final ChunkEncoder encoder;

    public LZFCompressedStreamOutput(StreamOutput out) throws IOException {
        super(out, LZFCompressorContext.INSTANCE);
        this.uncompressed = this.recycler.allocOutputBuffer(65535);
        this.uncompressedLength = 65535;
        this.encoder = new ChunkEncoder(65535);
    }

    @Override
    public void writeHeader(StreamOutput out) throws IOException {
    }

    @Override
    protected void compress(byte[] data2, int offset2, int len, StreamOutput out) throws IOException {
        this.encoder.encodeAndWriteChunk(data2, offset2, len, out);
    }

    @Override
    protected void doClose() throws IOException {
        byte[] buf = this.uncompressed;
        if (buf != null) {
            this.uncompressed = null;
            this.recycler.releaseOutputBuffer(buf);
        }
        this.encoder.close();
    }
}

