/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cache;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.Beta;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheStats;
import org.elasticsearch.common.collect.ForwardingObject;
import org.elasticsearch.common.collect.ImmutableMap;

@Beta
public abstract class ForwardingCache<K, V>
extends ForwardingObject
implements Cache<K, V> {
    protected ForwardingCache() {
    }

    @Override
    protected abstract Cache<K, V> delegate();

    @Override
    @Nullable
    public V getIfPresent(Object key2) {
        return this.delegate().getIfPresent(key2);
    }

    @Override
    public V get(K key2, Callable<? extends V> valueLoader) throws ExecutionException {
        return this.delegate().get(key2, valueLoader);
    }

    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys2) {
        return this.delegate().getAllPresent(keys2);
    }

    @Override
    public void put(K key2, V value2) {
        this.delegate().put(key2, value2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate().putAll(m);
    }

    @Override
    public void invalidate(Object key2) {
        this.delegate().invalidate(key2);
    }

    @Override
    public void invalidateAll(Iterable<?> keys2) {
        this.delegate().invalidateAll(keys2);
    }

    @Override
    public void invalidateAll() {
        this.delegate().invalidateAll();
    }

    @Override
    public long size() {
        return this.delegate().size();
    }

    @Override
    public CacheStats stats() {
        return this.delegate().stats();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this.delegate().asMap();
    }

    @Override
    public void cleanUp() {
        this.delegate().cleanUp();
    }

    @Beta
    public static abstract class SimpleForwardingCache<K, V>
    extends ForwardingCache<K, V> {
        private final Cache<K, V> delegate;

        protected SimpleForwardingCache(Cache<K, V> delegate2) {
            this.delegate = Preconditions.checkNotNull(delegate2);
        }

        @Override
        protected final Cache<K, V> delegate() {
            return this.delegate;
        }
    }
}

