/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bloom;

import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.MurmurHash;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.bloom.BloomFilter;

public class ObsBloomFilter
implements BloomFilter {
    private final int hashCount;
    private final OpenBitSet bitset;
    private final long size;

    ObsBloomFilter(int hashCount, long size2) {
        this.hashCount = hashCount;
        this.bitset = new OpenBitSet(size2);
        this.size = size2;
    }

    long emptyBuckets() {
        long n = 0L;
        for (long i2 = 0L; i2 < this.buckets(); ++i2) {
            if (this.bitset.get(i2)) continue;
            ++n;
        }
        return n;
    }

    private long buckets() {
        return this.size;
    }

    private long[] getHashBuckets(byte[] key2, int offset2, int length2) {
        return ObsBloomFilter.getHashBuckets(key2, offset2, length2, this.hashCount, this.buckets());
    }

    static long[] getHashBuckets(byte[] b, int offset2, int length2, int hashCount, long max2) {
        long[] result2 = new long[hashCount];
        long[] hash2 = MurmurHash.hash3_x64_128(b, offset2, length2, 0L);
        for (int i2 = 0; i2 < hashCount; ++i2) {
            result2[i2] = Math.abs((hash2[0] + (long)i2 * hash2[1]) % max2);
        }
        return result2;
    }

    @Override
    public void add(byte[] key2, int offset2, int length2) {
        long[] hash2 = MurmurHash.hash3_x64_128(key2, offset2, length2, 0L);
        for (int i2 = 0; i2 < this.hashCount; ++i2) {
            long bucketIndex = Math.abs((hash2[0] + (long)i2 * hash2[1]) % this.size);
            this.bitset.fastSet(bucketIndex);
        }
    }

    @Override
    public boolean isPresent(byte[] key2, int offset2, int length2) {
        long[] hash2 = MurmurHash.hash3_x64_128(key2, offset2, length2, 0L);
        for (int i2 = 0; i2 < this.hashCount; ++i2) {
            long bucketIndex = Math.abs((hash2[0] + (long)i2 * hash2[1]) % this.size);
            if (this.bitset.fastGet(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.bitset.clear(0L, this.bitset.size());
    }

    @Override
    public long sizeInBytes() {
        return this.bitset.getBits().length * 8 + RamUsage.NUM_BYTES_ARRAY_HEADER + 4;
    }
}

