/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.base;

import org.elasticsearch.common.annotations.GwtCompatible;

@GwtCompatible
public final class Ascii {
    public static final byte NUL = 0;
    public static final byte SOH = 1;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte ACK = 6;
    public static final byte BEL = 7;
    public static final byte BS = 8;
    public static final byte HT = 9;
    public static final byte LF = 10;
    public static final byte NL = 10;
    public static final byte VT = 11;
    public static final byte FF = 12;
    public static final byte CR = 13;
    public static final byte SO = 14;
    public static final byte SI = 15;
    public static final byte DLE = 16;
    public static final byte DC1 = 17;
    public static final byte XON = 17;
    public static final byte DC2 = 18;
    public static final byte DC3 = 19;
    public static final byte XOFF = 19;
    public static final byte DC4 = 20;
    public static final byte NAK = 21;
    public static final byte SYN = 22;
    public static final byte ETB = 23;
    public static final byte CAN = 24;
    public static final byte EM = 25;
    public static final byte SUB = 26;
    public static final byte ESC = 27;
    public static final byte FS = 28;
    public static final byte GS = 29;
    public static final byte RS = 30;
    public static final byte US = 31;
    public static final byte SP = 32;
    public static final byte SPACE = 32;
    public static final byte DEL = 127;
    public static final char MIN = '\u0000';
    public static final char MAX = '\u007f';

    private Ascii() {
    }

    public static String toLowerCase(String string2) {
        return Ascii.toLowerCase((CharSequence)string2);
    }

    public static String toLowerCase(CharSequence chars2) {
        int length2 = chars2.length();
        StringBuilder builder = new StringBuilder(length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            builder.append(Ascii.toLowerCase(chars2.charAt(i2)));
        }
        return builder.toString();
    }

    public static char toLowerCase(char c) {
        return Ascii.isUpperCase(c) ? (char)(c ^ 0x20) : c;
    }

    public static String toUpperCase(String string2) {
        return Ascii.toUpperCase((CharSequence)string2);
    }

    public static String toUpperCase(CharSequence chars2) {
        int length2 = chars2.length();
        StringBuilder builder = new StringBuilder(length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            builder.append(Ascii.toUpperCase(chars2.charAt(i2)));
        }
        return builder.toString();
    }

    public static char toUpperCase(char c) {
        return Ascii.isLowerCase(c) ? (char)(c & 0x5F) : c;
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }
}

