/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import org.elasticsearch.ElasticSearchInterruptedException;

public class RateLimiter {
    private volatile double nsPerByte;
    private volatile long lastNS;

    public RateLimiter(double mbPerSec) {
        this.setMaxRate(mbPerSec);
    }

    public void setMaxRate(double mbPerSec) {
        this.nsPerByte = 1.0E9 / (1048576.0 * mbPerSec);
    }

    public long pause(long bytes2) {
        long pauseNS;
        long targetNS = this.lastNS += (long)((double)bytes2 * this.nsPerByte);
        long curNS = System.nanoTime();
        if (this.lastNS < curNS) {
            this.lastNS = curNS;
        }
        long totalPauseTime = 0L;
        while ((pauseNS = targetNS - curNS) > 0L) {
            try {
                Thread.sleep((int)(pauseNS / 1000000L), (int)(pauseNS % 1000000L));
                totalPauseTime += pauseNS;
            }
            catch (InterruptedException ie) {
                throw new ElasticSearchInterruptedException("interrupted while rate limiting", ie);
            }
            curNS = System.nanoTime();
        }
        return totalPauseTime;
    }
}

