/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.elasticsearch.common.Hex;

public class Digest {
    private static final int STREAM_BUFFER_LENGTH = 16384;
    private static final Charset Charset_UTF8 = Charset.forName("UTF8");
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final NullDigest NULL_DIGEST = new NullDigest("null");

    private static byte[] digest(MessageDigest digest2, InputStream data2) throws IOException {
        byte[] buffer = new byte[16384];
        int read2 = data2.read(buffer, 0, 16384);
        while (read2 > -1) {
            digest2.update(buffer, 0, read2);
            read2 = data2.read(buffer, 0, 16384);
        }
        return digest2.digest();
    }

    private static byte[] getBytesUtf8(String data2) {
        return data2.getBytes(Charset_UTF8);
    }

    static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static MessageDigest getMd5Digest() {
        return Digest.getDigest("MD5");
    }

    private static MessageDigest getSha256Digest() {
        return Digest.getDigest("SHA-256");
    }

    private static MessageDigest getSha384Digest() {
        return Digest.getDigest("SHA-384");
    }

    private static MessageDigest getSha512Digest() {
        return Digest.getDigest("SHA-512");
    }

    private static MessageDigest getShaDigest() {
        return Digest.getDigest("SHA");
    }

    public static byte[] md5(byte[] data2) {
        return Digest.getMd5Digest().digest(data2);
    }

    public static byte[] md5(InputStream data2) throws IOException {
        return Digest.digest(Digest.getMd5Digest(), data2);
    }

    public static byte[] md5(String data2) {
        return Digest.md5(Digest.getBytesUtf8(data2));
    }

    public static String md5Hex(byte[] data2) {
        return Hex.encodeHexString(Digest.md5(data2));
    }

    public static String md5Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(Digest.md5(data2));
    }

    public static String md5Hex(String data2) {
        return Hex.encodeHexString(Digest.md5(data2));
    }

    public static byte[] md5HexToByteArray(String md5Hex) {
        return md5Hex.getBytes(US_ASCII);
    }

    public static String md5HexFromByteArray(byte[] data2) {
        return new String(data2, 0, 32, US_ASCII);
    }

    public static byte[] sha(byte[] data2) {
        return Digest.getShaDigest().digest(data2);
    }

    public static byte[] sha(InputStream data2) throws IOException {
        return Digest.digest(Digest.getShaDigest(), data2);
    }

    public static byte[] sha(String data2) {
        return Digest.sha(Digest.getBytesUtf8(data2));
    }

    public static byte[] sha256(byte[] data2) {
        return Digest.getSha256Digest().digest(data2);
    }

    public static byte[] sha256(InputStream data2) throws IOException {
        return Digest.digest(Digest.getSha256Digest(), data2);
    }

    public static byte[] sha256(String data2) {
        return Digest.sha256(Digest.getBytesUtf8(data2));
    }

    public static String sha256Hex(byte[] data2) {
        return Hex.encodeHexString(Digest.sha256(data2));
    }

    public static String sha256Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(Digest.sha256(data2));
    }

    public static String sha256Hex(String data2) {
        return Hex.encodeHexString(Digest.sha256(data2));
    }

    public static byte[] sha384(byte[] data2) {
        return Digest.getSha384Digest().digest(data2);
    }

    public static byte[] sha384(InputStream data2) throws IOException {
        return Digest.digest(Digest.getSha384Digest(), data2);
    }

    public static byte[] sha384(String data2) {
        return Digest.sha384(Digest.getBytesUtf8(data2));
    }

    public static String sha384Hex(byte[] data2) {
        return Hex.encodeHexString(Digest.sha384(data2));
    }

    public static String sha384Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(Digest.sha384(data2));
    }

    public static String sha384Hex(String data2) {
        return Hex.encodeHexString(Digest.sha384(data2));
    }

    public static byte[] sha512(byte[] data2) {
        return Digest.getSha512Digest().digest(data2);
    }

    public static byte[] sha512(InputStream data2) throws IOException {
        return Digest.digest(Digest.getSha512Digest(), data2);
    }

    public static byte[] sha512(String data2) {
        return Digest.sha512(Digest.getBytesUtf8(data2));
    }

    public static String sha512Hex(byte[] data2) {
        return Hex.encodeHexString(Digest.sha512(data2));
    }

    public static String sha512Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(Digest.sha512(data2));
    }

    public static String sha512Hex(String data2) {
        return Hex.encodeHexString(Digest.sha512(data2));
    }

    public static String shaHex(byte[] data2) {
        return Hex.encodeHexString(Digest.sha(data2));
    }

    public static String shaHex(InputStream data2) throws IOException {
        return Hex.encodeHexString(Digest.sha(data2));
    }

    public static String shaHex(String data2) {
        return Hex.encodeHexString(Digest.sha(data2));
    }

    private static final class NullDigest
    extends MessageDigest {
        private NullDigest(String algorithm) {
            super(algorithm);
        }

        @Override
        protected void engineUpdate(byte input) {
        }

        @Override
        protected void engineUpdate(byte[] input, int offset2, int len) {
        }

        @Override
        protected byte[] engineDigest() {
            return null;
        }

        @Override
        protected void engineReset() {
        }
    }
}

