/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import org.elasticsearch.monitor.jvm.JvmUtils;

public class Bytes {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] LONG_MIN_VALUE_BYTES = "-9223372036854775808".getBytes();
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0) {
            return Integer.MAX_VALUE;
        }
        if (JvmUtils.JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 2: {
                return newSize + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return newSize + 3 & 0x7FFFFFFC;
            }
        }
        return newSize;
    }

    static int stringSize(int x) {
        int i2 = 0;
        while (x > sizeTable[i2]) {
            ++i2;
        }
        return i2 + 1;
    }

    public static byte[] itoa(int i2) {
        int size2 = i2 < 0 ? Bytes.stringSize(-i2) + 1 : Bytes.stringSize(i2);
        byte[] buf = new byte[size2];
        Bytes.getChars(i2, size2, buf);
        return buf;
    }

    static void getChars(int i2, int index2, byte[] buf) {
        int r;
        int q;
        int charPos = index2;
        int sign2 = 0;
        if (i2 < 0) {
            sign2 = 45;
            i2 = -i2;
        }
        while (i2 >= 65536) {
            q = i2 / 100;
            r = i2 - ((q << 6) + (q << 5) + (q << 2));
            i2 = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q = i2 * 52429 >>> 19;
            r = i2 - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q) != 0);
        if (sign2 != 0) {
            buf[--charPos] = sign2;
        }
    }

    public static int atoi(byte[] s2) throws NumberFormatException {
        int result2 = 0;
        boolean negative = false;
        int i2 = 0;
        int len = s2.length;
        int limit2 = -2147483647;
        if (len > 0) {
            byte firstChar = s2[0];
            if (firstChar < 48) {
                if (firstChar != 45) {
                    throw new NumberFormatException();
                }
                negative = true;
                limit2 = Integer.MIN_VALUE;
                if (len == 1) {
                    throw new NumberFormatException();
                }
                ++i2;
            }
            int multmin = limit2 / 10;
            while (i2 < len) {
                int digit;
                if ((digit = Character.digit(s2[i2++], 10)) < 0) {
                    throw new NumberFormatException();
                }
                if (result2 < multmin) {
                    throw new NumberFormatException();
                }
                if ((result2 *= 10) < limit2 + digit) {
                    throw new NumberFormatException();
                }
                result2 -= digit;
            }
        } else {
            throw new NumberFormatException();
        }
        return negative ? result2 : -result2;
    }

    public static byte[] ltoa(long i2) {
        if (i2 == Long.MIN_VALUE) {
            return LONG_MIN_VALUE_BYTES;
        }
        int size2 = i2 < 0L ? Bytes.stringSize(-i2) + 1 : Bytes.stringSize(i2);
        byte[] buf = new byte[size2];
        Bytes.getChars(i2, size2, buf);
        return buf;
    }

    static void getChars(long i2, int index2, byte[] buf) {
        int q2;
        int r;
        int charPos = index2;
        int sign2 = 0;
        if (i2 < 0L) {
            sign2 = 45;
            i2 = -i2;
        }
        while (i2 > Integer.MAX_VALUE) {
            long q = i2 / 100L;
            r = (int)(i2 - ((q << 6) + (q << 5) + (q << 2)));
            i2 = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i22 = (int)i2;
        while (i22 >= 65536) {
            q2 = i22 / 100;
            r = i22 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i22 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i22 * 52429 >>> 19;
            r = i22 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i22 = q2) != 0);
        if (sign2 != 0) {
            buf[--charPos] = sign2;
        }
    }

    static int stringSize(long x) {
        long p2 = 10L;
        for (int i2 = 1; i2 < 19; ++i2) {
            if (x < p2) {
                return i2;
            }
            p2 = 10L * p2;
        }
        return 19;
    }

    public static long atol(byte[] s2) throws NumberFormatException {
        long result2 = 0L;
        boolean negative = false;
        int i2 = 0;
        int len = s2.length;
        long limit2 = -9223372036854775807L;
        if (len > 0) {
            byte firstChar = s2[0];
            if (firstChar < 48) {
                if (firstChar != 45) {
                    throw new NumberFormatException();
                }
                negative = true;
                limit2 = Long.MIN_VALUE;
                if (len == 1) {
                    throw new NumberFormatException();
                }
                ++i2;
            }
            long multmin = limit2 / 10L;
            while (i2 < len) {
                int digit;
                if ((digit = Character.digit(s2[i2++], 10)) < 0) {
                    throw new NumberFormatException();
                }
                if (result2 < multmin) {
                    throw new NumberFormatException();
                }
                if ((result2 *= 10L) < limit2 + (long)digit) {
                    throw new NumberFormatException();
                }
                result2 -= (long)digit;
            }
        } else {
            throw new NumberFormatException();
        }
        return negative ? result2 : -result2;
    }
}

