/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.settings;

import java.util.Arrays;
import java.util.HashSet;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.regex.Regex;

public class DynamicSettings {
    private ImmutableSet<String> dynamicSettings = ImmutableSet.of();

    public boolean hasDynamicSetting(String key2) {
        for (String dynamicSetting : this.dynamicSettings) {
            if (!Regex.simpleMatch(dynamicSetting, key2)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addDynamicSettings(String ... settings) {
        HashSet<String> updatedSettings = new HashSet<String>(this.dynamicSettings);
        updatedSettings.addAll(Arrays.asList(settings));
        this.dynamicSettings = ImmutableSet.copyOf(updatedSettings);
    }
}

