/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.operation.plain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.operation.OperationRouting;
import org.elasticsearch.cluster.routing.operation.hash.HashFunction;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexMissingException;

public class PlainOperationRouting
extends AbstractComponent
implements OperationRouting {
    private final HashFunction hashFunction;
    private final boolean useType;
    private final AwarenessAllocationDecider awarenessAllocationDecider;
    private static final Map<String, Set<String>> EMPTY_ROUTING = Collections.emptyMap();

    @Inject
    public PlainOperationRouting(Settings indexSettings, HashFunction hashFunction, AwarenessAllocationDecider awarenessAllocationDecider) {
        super(indexSettings);
        this.hashFunction = hashFunction;
        this.useType = indexSettings.getAsBoolean("cluster.routing.operation.use_type", false);
        this.awarenessAllocationDecider = awarenessAllocationDecider;
    }

    @Override
    public ShardIterator indexShards(ClusterState clusterState, String index2, String type2, String id2, @Nullable String routing) throws IndexMissingException, IndexShardMissingException {
        return this.shards(clusterState, index2, type2, id2, routing).shardsIt();
    }

    @Override
    public ShardIterator deleteShards(ClusterState clusterState, String index2, String type2, String id2, @Nullable String routing) throws IndexMissingException, IndexShardMissingException {
        return this.shards(clusterState, index2, type2, id2, routing).shardsIt();
    }

    @Override
    public ShardIterator getShards(ClusterState clusterState, String index2, String type2, String id2, @Nullable String routing, @Nullable String preference) throws IndexMissingException, IndexShardMissingException {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index2, type2, id2, routing), clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
    }

    @Override
    public ShardIterator getShards(ClusterState clusterState, String index2, int shardId, @Nullable String preference) throws IndexMissingException, IndexShardMissingException {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index2, shardId), clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
    }

    @Override
    public GroupShardsIterator broadcastDeleteShards(ClusterState clusterState, String index2) throws IndexMissingException {
        return this.indexRoutingTable(clusterState, index2).groupByShardsIt();
    }

    @Override
    public GroupShardsIterator deleteByQueryShards(ClusterState clusterState, String index2, @Nullable Set<String> routing) throws IndexMissingException {
        if (routing == null || routing.isEmpty()) {
            return this.indexRoutingTable(clusterState, index2).groupByShardsIt();
        }
        HashSet<ShardIterator> set = new HashSet<ShardIterator>();
        IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index2);
        for (String r : routing) {
            int shardId = this.shardId(clusterState, index2, null, null, r);
            IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
            if (indexShard == null) {
                throw new IndexShardMissingException(new ShardId(index2, shardId));
            }
            set.add(indexShard.shardsRandomIt());
        }
        return new GroupShardsIterator(set);
    }

    @Override
    public int searchShardsCount(ClusterState clusterState, String[] indices2, String[] concreteIndices, @Nullable String queryHint, @Nullable Map<String, Set<String>> routing, @Nullable String preference) throws IndexMissingException {
        if (concreteIndices == null || concreteIndices.length == 0) {
            concreteIndices = clusterState.metaData().concreteAllOpenIndices();
        }
        if (routing != null) {
            HashSet<ShardId> set = new HashSet<ShardId>();
            for (String index2 : concreteIndices) {
                IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index2);
                Set<String> effectiveRouting = routing.get(index2);
                if (effectiveRouting == null) continue;
                for (String r : effectiveRouting) {
                    int shardId = this.shardId(clusterState, index2, null, null, r);
                    IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
                    if (indexShard == null) {
                        throw new IndexShardMissingException(new ShardId(index2, shardId));
                    }
                    set.add(indexShard.shardId());
                }
            }
            return set.size();
        }
        int count2 = 0;
        for (String index3 : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index3);
            count2 += indexRouting.shards().size();
        }
        return count2;
    }

    @Override
    public GroupShardsIterator searchShards(ClusterState clusterState, String[] indices2, String[] concreteIndices, @Nullable String queryHint, @Nullable Map<String, Set<String>> routing, @Nullable String preference) throws IndexMissingException {
        if (concreteIndices == null || concreteIndices.length == 0) {
            concreteIndices = clusterState.metaData().concreteAllOpenIndices();
        }
        routing = routing == null ? EMPTY_ROUTING : routing;
        HashSet<ShardIterator> set = new HashSet<ShardIterator>();
        for (String index2 : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index2);
            Set<String> effectiveRouting = routing.get(index2);
            if (effectiveRouting != null) {
                for (String r : effectiveRouting) {
                    int shardId = this.shardId(clusterState, index2, null, null, r);
                    IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
                    if (indexShard == null) {
                        throw new IndexShardMissingException(new ShardId(index2, shardId));
                    }
                    ShardIterator iterator = this.preferenceActiveShardIterator(indexShard, clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
                    if (iterator == null) continue;
                    set.add(iterator);
                }
                continue;
            }
            for (IndexShardRoutingTable indexShard : indexRouting) {
                ShardIterator iterator = this.preferenceActiveShardIterator(indexShard, clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
                if (iterator == null) continue;
                set.add(iterator);
            }
        }
        return new GroupShardsIterator(set);
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String localNodeId, DiscoveryNodes nodes, @Nullable String preference) {
        String[] awarenessAttributes;
        if (preference == null) {
            String[] awarenessAttributes2 = this.awarenessAllocationDecider.awarenessAttributes();
            if (awarenessAttributes2.length == 0) {
                return indexShard.activeShardsRandomIt();
            }
            return indexShard.preferAttributesActiveShardsIt(awarenessAttributes2, nodes);
        }
        if (preference.charAt(0) == '_') {
            if (preference.startsWith("_shards:")) {
                int index2 = preference.indexOf(59);
                String shards = index2 == -1 ? preference.substring("_shards:".length()) : preference.substring("_shards:".length(), index2);
                String[] ids = Strings.splitStringByCommaToArray(shards);
                boolean found = false;
                for (String id2 : ids) {
                    if (Integer.parseInt(id2) != indexShard.shardId().id()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                if (index2 == -1 || index2 == preference.length() - 1) {
                    String[] awarenessAttributes3 = this.awarenessAllocationDecider.awarenessAttributes();
                    if (awarenessAttributes3.length == 0) {
                        return indexShard.activeShardsRandomIt();
                    }
                    return indexShard.preferAttributesActiveShardsIt(awarenessAttributes3, nodes);
                }
                preference = preference.substring(index2 + 1);
            }
            if (preference.startsWith("_prefer_node:")) {
                return indexShard.preferNodeActiveShardsIt(preference.substring("_prefer_node:".length()));
            }
            if ("_local".equals(preference)) {
                return indexShard.preferNodeActiveShardsIt(localNodeId);
            }
            if ("_primary".equals(preference)) {
                return indexShard.primaryShardIt();
            }
            if ("_primary_first".equals(preference) || "_primaryFirst".equals(preference)) {
                return indexShard.primaryFirstActiveShardsIt();
            }
            if ("_only_local".equals(preference) || "_onlyLocal".equals(preference)) {
                return indexShard.onlyNodeActiveShardsIt(localNodeId);
            }
            if (preference.startsWith("_only_node:")) {
                return indexShard.onlyNodeActiveShardsIt(preference.substring("_only_node:".length()));
            }
        }
        if ((awarenessAttributes = this.awarenessAllocationDecider.awarenessAttributes()).length == 0) {
            return indexShard.activeShardsIt(DjbHashFunction.DJB_HASH(preference));
        }
        return indexShard.preferAttributesActiveShardsIt(awarenessAttributes, nodes, DjbHashFunction.DJB_HASH(preference));
    }

    public IndexMetaData indexMetaData(ClusterState clusterState, String index2) {
        IndexMetaData indexMetaData = clusterState.metaData().index(index2);
        if (indexMetaData == null) {
            throw new IndexMissingException(new Index(index2));
        }
        return indexMetaData;
    }

    protected IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index2) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index2);
        if (indexRouting == null) {
            throw new IndexMissingException(new Index(index2));
        }
        return indexRouting;
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index2, String type2, String id2, String routing) {
        int shardId = this.shardId(clusterState, index2, type2, id2, routing);
        return this.shards(clusterState, index2, shardId);
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index2, int shardId) {
        IndexShardRoutingTable indexShard = this.indexRoutingTable(clusterState, index2).shard(shardId);
        if (indexShard == null) {
            throw new IndexShardMissingException(new ShardId(index2, shardId));
        }
        return indexShard;
    }

    private int shardId(ClusterState clusterState, String index2, String type2, @Nullable String id2, @Nullable String routing) {
        if (routing == null) {
            if (!this.useType) {
                return Math.abs(this.hash(id2) % this.indexMetaData(clusterState, index2).numberOfShards());
            }
            return Math.abs(this.hash(type2, id2) % this.indexMetaData(clusterState, index2).numberOfShards());
        }
        return Math.abs(this.hash(routing) % this.indexMetaData(clusterState, index2).numberOfShards());
    }

    protected int hash(String routing) {
        return this.hashFunction.hash(routing);
    }

    protected int hash(String type2, String id2) {
        if (type2 == null || "_all".equals(type2)) {
            throw new ElasticSearchIllegalArgumentException("Can't route an operation with no type and having type part of the routing (for backward comp)");
        }
        return this.hashFunction.hash(type2, id2);
    }
}

