/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class RoutingTableValidation
implements Serializable,
Streamable {
    private boolean valid = true;
    private List<String> failures;
    private Map<String, List<String>> indicesFailures;

    public boolean valid() {
        return this.valid;
    }

    public List<String> allFailures() {
        if (this.failures().isEmpty() && this.indicesFailures().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<String> allFailures = Lists.newArrayList(this.failures());
        for (Map.Entry<String, List<String>> entry : this.indicesFailures().entrySet()) {
            for (String failure : entry.getValue()) {
                allFailures.add("Index [" + entry.getKey() + "]: " + failure);
            }
        }
        return allFailures;
    }

    public List<String> failures() {
        if (this.failures == null) {
            return ImmutableList.of();
        }
        return this.failures;
    }

    public Map<String, List<String>> indicesFailures() {
        if (this.indicesFailures == null) {
            return ImmutableMap.of();
        }
        return this.indicesFailures;
    }

    public List<String> indexFailures(String index2) {
        if (this.indicesFailures == null) {
            return ImmutableList.of();
        }
        List<String> indexFailures = this.indicesFailures.get(index2);
        if (indexFailures == null) {
            return ImmutableList.of();
        }
        return indexFailures;
    }

    public void addFailure(String failure) {
        this.valid = false;
        if (this.failures == null) {
            this.failures = Lists.newArrayList();
        }
        this.failures.add(failure);
    }

    public void addIndexFailure(String index2, String failure) {
        List<String> indexFailures;
        this.valid = false;
        if (this.indicesFailures == null) {
            this.indicesFailures = Maps.newHashMap();
        }
        if ((indexFailures = this.indicesFailures.get(index2)) == null) {
            indexFailures = Lists.newArrayList();
            this.indicesFailures.put(index2, indexFailures);
        }
        indexFailures.add(failure);
    }

    public String toString() {
        return this.allFailures().toString();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i2;
        this.valid = in.readBoolean();
        int size2 = in.readVInt();
        if (size2 == 0) {
            this.failures = ImmutableList.of();
        } else {
            this.failures = Lists.newArrayListWithCapacity(size2);
            for (i2 = 0; i2 < size2; ++i2) {
                this.failures.add(in.readUTF());
            }
        }
        size2 = in.readVInt();
        if (size2 == 0) {
            this.indicesFailures = ImmutableMap.of();
        } else {
            this.indicesFailures = Maps.newHashMap();
            for (i2 = 0; i2 < size2; ++i2) {
                String index2 = in.readUTF();
                int size22 = in.readVInt();
                ArrayList<String> indexFailures = Lists.newArrayListWithCapacity(size22);
                for (int j = 0; j < size22; ++j) {
                    indexFailures.add(in.readUTF());
                }
                this.indicesFailures.put(index2, indexFailures);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.valid);
        if (this.failures == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.failures.size());
            for (String string2 : this.failures) {
                out.writeUTF(string2);
            }
        }
        if (this.indicesFailures == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indicesFailures.size());
            for (Map.Entry entry : this.indicesFailures.entrySet()) {
                out.writeUTF((String)entry.getKey());
                out.writeVInt(((List)entry.getValue()).size());
                for (String failure : (List)entry.getValue()) {
                    out.writeUTF(failure);
                }
            }
        }
    }
}

