/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.action.index.NodeMappingCreatedAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;

public class MetaDataMappingService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final NodeMappingCreatedAction mappingCreatedAction;
    private final Map<String, Set<String>> indicesAndTypesToRefresh = Maps.newHashMap();

    @Inject
    public MetaDataMappingService(Settings settings, ClusterService clusterService, IndicesService indicesService, NodeMappingCreatedAction mappingCreatedAction) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.mappingCreatedAction = mappingCreatedAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMapping(final String index2, String ... types) {
        Map<String, Set<String>> map = this.indicesAndTypesToRefresh;
        synchronized (map) {
            Set<String> sTypes = this.indicesAndTypesToRefresh.get(index2);
            if (sTypes == null) {
                sTypes = Sets.newHashSet();
                this.indicesAndTypesToRefresh.put(index2, sTypes);
            }
            sTypes.addAll(Arrays.asList(types));
        }
        this.clusterService.submitStateUpdateTask("refresh-mapping [" + index2 + "][" + Arrays.toString(types) + "]", new ClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                Object object;
                boolean createdIndex = false;
                try {
                    Set sTypes;
                    object = MetaDataMappingService.this.indicesAndTypesToRefresh;
                    synchronized (object) {
                        sTypes = (Set)MetaDataMappingService.this.indicesAndTypesToRefresh.remove(index2);
                    }
                    if (sTypes == null || sTypes.isEmpty()) {
                        object = currentState;
                        return object;
                    }
                    IndexMetaData indexMetaData = currentState.metaData().index(index2);
                    if (indexMetaData == null) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index2);
                    if (indexService == null) {
                        indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), currentState.nodes().localNode().id());
                        createdIndex = true;
                        for (String type2 : sTypes) {
                            if (!indexMetaData.mappings().containsKey(type2)) continue;
                            indexService.mapperService().merge(type2, indexMetaData.mappings().get(type2).source().string(), false);
                        }
                    }
                    IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.newIndexMetaDataBuilder(indexMetaData);
                    ArrayList<String> updatedTypes = Lists.newArrayList();
                    for (String type3 : sTypes) {
                        DocumentMapper mapper = indexService.mapperService().documentMapper(type3);
                        if (mapper.mappingSource().equals(indexMetaData.mappings().get(type3).source())) continue;
                        updatedTypes.add(type3);
                        indexMetaDataBuilder.putMapping(new MappingMetaData(mapper));
                    }
                    if (updatedTypes.isEmpty()) {
                        ClusterState i$ = currentState;
                        return i$;
                    }
                    MetaDataMappingService.this.logger.warn("[{}] re-syncing mappings with cluster state for types [{}]", index2, updatedTypes);
                    MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    builder.put(indexMetaDataBuilder);
                    ClusterState clusterState = ClusterState.newClusterStateBuilder().state(currentState).metaData(builder).build();
                    return clusterState;
                }
                catch (Exception e) {
                    MetaDataMappingService.this.logger.warn("failed to dynamically refresh the mapping in cluster_state from shard", e, new Object[0]);
                    object = currentState;
                    return object;
                }
                finally {
                    if (createdIndex) {
                        MetaDataMappingService.this.indicesService.cleanIndex(index2, "created for mapping processing");
                    }
                }
            }
        });
    }

    public void updateMapping(final String index2, final String type2, final CompressedString mappingSource, final Listener listener) {
        this.clusterService.submitStateUpdateTask("update-mapping [" + index2 + "][" + type2 + "]", new ProcessedClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean createdIndex = false;
                try {
                    IndexMetaData indexMetaData = currentState.metaData().index(index2);
                    if (indexMetaData == null) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    if (indexMetaData.mappings().containsKey(type2) && indexMetaData.mapping(type2).source().equals(mappingSource)) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index2);
                    if (indexService == null) {
                        indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), currentState.nodes().localNode().id());
                        createdIndex = true;
                        if (indexMetaData.mappings().containsKey(type2)) {
                            indexService.mapperService().merge(type2, indexMetaData.mappings().get(type2).source().string(), false);
                        }
                    }
                    DocumentMapper updatedMapper = indexService.mapperService().merge(type2, mappingSource.string(), false);
                    if (indexMetaData.mappings().containsKey(type2) && indexMetaData.mapping(type2).source().equals(updatedMapper.mappingSource())) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                        try {
                            MetaDataMappingService.this.logger.debug("[{}] update_mapping [{}] (dynamic) with source [{}]", index2, type2, updatedMapper.mappingSource().string());
                        }
                        catch (IOException e) {}
                    } else if (MetaDataMappingService.this.logger.isInfoEnabled()) {
                        MetaDataMappingService.this.logger.info("[{}] update_mapping [{}] (dynamic)", index2, type2);
                    }
                    MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    builder.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).putMapping(new MappingMetaData(updatedMapper)));
                    ClusterState clusterState = ClusterState.newClusterStateBuilder().state(currentState).metaData(builder).build();
                    return clusterState;
                }
                catch (Exception e) {
                    MetaDataMappingService.this.logger.warn("failed to dynamically update the mapping in cluster_state from shard", e, new Object[0]);
                    listener.onFailure(e);
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                finally {
                    if (createdIndex) {
                        MetaDataMappingService.this.indicesService.cleanIndex(index2, "created for mapping processing");
                    }
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                listener.onResponse(new Response(true));
            }
        });
    }

    public void removeMapping(final RemoveRequest request, final Listener listener) {
        final AtomicBoolean notifyOnPostProcess = new AtomicBoolean();
        this.clusterService.submitStateUpdateTask("remove-mapping [" + request.mappingType + "]", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (request.indices.length == 0) {
                    listener.onFailure(new IndexMissingException(new Index("_all")));
                    return currentState;
                }
                try {
                    MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    boolean changed = false;
                    String latestIndexWithout = null;
                    for (String indexName : request.indices) {
                        IndexMetaData indexMetaData = currentState.metaData().index(indexName);
                        if (indexMetaData == null) continue;
                        if (indexMetaData.mappings().containsKey(request.mappingType)) {
                            builder.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).removeMapping(request.mappingType));
                            changed = true;
                            continue;
                        }
                        latestIndexWithout = indexMetaData.index();
                    }
                    if (!changed) {
                        listener.onFailure(new TypeMissingException(new Index(latestIndexWithout), request.mappingType));
                        return currentState;
                    }
                    MetaDataMappingService.this.logger.info("[{}] remove_mapping [{}]", request.indices, request.mappingType);
                    notifyOnPostProcess.set(true);
                    return ClusterState.builder().state(currentState).metaData(builder).build();
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return currentState;
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                if (notifyOnPostProcess.get()) {
                    listener.onResponse(new Response(true));
                }
            }
        });
    }

    public void putMapping(final PutRequest request, final Listener listener) {
        final AtomicBoolean notifyOnPostProcess = new AtomicBoolean();
        this.clusterService.submitStateUpdateTask("put-mapping [" + request.mappingType + "]", new ProcessedClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                ArrayList<String> indicesToClose = Lists.newArrayList();
                try {
                    ClusterState clusterState;
                    DocumentMapper newMapper;
                    if (request.indices.length == 0) {
                        throw new IndexMissingException(new Index("_all"));
                    }
                    for (String index2 : request.indices) {
                        if (currentState.metaData().hasIndex(index2)) continue;
                        listener.onFailure(new IndexMissingException(new Index(index2)));
                    }
                    for (String index2 : request.indices) {
                        if (MetaDataMappingService.this.indicesService.hasIndex(index2)) continue;
                        IndexMetaData indexMetaData = currentState.metaData().index(index2);
                        IndexService indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), currentState.nodes().localNode().id());
                        indicesToClose.add(indexMetaData.index());
                        if (!indexMetaData.mappings().containsKey(request.mappingType)) continue;
                        indexService.mapperService().merge(request.mappingType, indexMetaData.mappings().get(request.mappingType).source().string(), false);
                    }
                    HashMap<String, DocumentMapper> newMappers = Maps.newHashMap();
                    HashMap<String, DocumentMapper> existingMappers = Maps.newHashMap();
                    for (String index3 : request.indices) {
                        IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index3);
                        if (indexService != null) {
                            newMapper = indexService.mapperService().parse(request.mappingType, request.mappingSource);
                            newMappers.put(index3, newMapper);
                            DocumentMapper existingMapper = indexService.mapperService().documentMapper(request.mappingType);
                            if (existingMapper == null) continue;
                            DocumentMapper.MergeResult mergeResult = existingMapper.merge(newMapper, DocumentMapper.MergeFlags.mergeFlags().simulate(true));
                            if (!request.ignoreConflicts && mergeResult.hasConflicts()) {
                                throw new MergeMappingException(mergeResult.conflicts());
                            }
                            existingMappers.put(index3, existingMapper);
                            continue;
                        }
                        throw new IndexMissingException(new Index(index3));
                    }
                    String mappingType = request.mappingType;
                    if (mappingType == null) {
                        mappingType = ((DocumentMapper)newMappers.values().iterator().next()).type();
                    } else if (!mappingType.equals(((DocumentMapper)newMappers.values().iterator().next()).type())) {
                        throw new InvalidTypeNameException("Type name provided does not match type name within mapping definition");
                    }
                    if (!"_default_".equals(mappingType) && mappingType.charAt(0) == '_') {
                        throw new InvalidTypeNameException("Document mapping type name can't start with '_'");
                    }
                    HashMap<String, MappingMetaData> mappings = Maps.newHashMap();
                    for (Map.Entry entry : newMappers.entrySet()) {
                        String index4 = (String)entry.getKey();
                        newMapper = (DocumentMapper)entry.getValue();
                        IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index4);
                        CompressedString existingSource = null;
                        if (existingMappers.containsKey(entry.getKey())) {
                            existingSource = ((DocumentMapper)existingMappers.get(entry.getKey())).mappingSource();
                        }
                        DocumentMapper mergedMapper = indexService.mapperService().merge(newMapper.type(), newMapper.mappingSource().string(), false);
                        CompressedString updatedSource = mergedMapper.mappingSource();
                        if (existingSource != null) {
                            if (existingSource.equals(updatedSource)) continue;
                            mappings.put(index4, new MappingMetaData(mergedMapper));
                            if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                                MetaDataMappingService.this.logger.debug("[{}] update_mapping [{}] with source [{}]", index4, mergedMapper.type(), updatedSource);
                                continue;
                            }
                            if (!MetaDataMappingService.this.logger.isInfoEnabled()) continue;
                            MetaDataMappingService.this.logger.info("[{}] update_mapping [{}]", index4, mergedMapper.type());
                            continue;
                        }
                        mappings.put(index4, new MappingMetaData(mergedMapper));
                        if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                            MetaDataMappingService.this.logger.debug("[{}] create_mapping [{}] with source [{}]", index4, newMapper.type(), updatedSource);
                            continue;
                        }
                        if (!MetaDataMappingService.this.logger.isInfoEnabled()) continue;
                        MetaDataMappingService.this.logger.info("[{}] create_mapping [{}]", index4, newMapper.type());
                    }
                    if (mappings.isEmpty()) {
                        listener.onResponse(new Response(true));
                        ClusterState i$ = currentState;
                        return i$;
                    }
                    MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    for (String indexName : request.indices) {
                        IndexMetaData indexMetaData = currentState.metaData().index(indexName);
                        if (indexMetaData == null) {
                            throw new IndexMissingException(new Index(indexName));
                        }
                        MappingMetaData mappingMd = (MappingMetaData)mappings.get(indexName);
                        if (mappingMd == null) continue;
                        builder.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).putMapping(mappingMd));
                    }
                    ClusterState updatedState = ClusterState.newClusterStateBuilder().state(currentState).metaData(builder).build();
                    int counter = 0;
                    for (String index5 : request.indices) {
                        IndexRoutingTable indexRoutingTable = updatedState.routingTable().index(index5);
                        if (indexRoutingTable == null) continue;
                        counter += indexRoutingTable.numberOfNodesShardsAreAllocatedOn(updatedState.nodes().masterNodeId());
                    }
                    if (counter == 0) {
                        notifyOnPostProcess.set(true);
                        clusterState = updatedState;
                        return clusterState;
                    }
                    MetaDataMappingService.this.mappingCreatedAction.add(new CountDownListener(counter, listener), request.timeout);
                    clusterState = updatedState;
                    return clusterState;
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                finally {
                    for (String index6 : indicesToClose) {
                        MetaDataMappingService.this.indicesService.cleanIndex(index6, "created for mapping processing");
                    }
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                if (notifyOnPostProcess.get()) {
                    listener.onResponse(new Response(true));
                }
            }
        });
    }

    private class CountDownListener
    implements NodeMappingCreatedAction.Listener {
        private final AtomicBoolean notified = new AtomicBoolean();
        private final AtomicInteger countDown;
        private final Listener listener;

        public CountDownListener(int countDown, Listener listener) {
            this.countDown = new AtomicInteger(countDown);
            this.listener = listener;
        }

        @Override
        public void onNodeMappingCreated(NodeMappingCreatedAction.NodeMappingCreatedResponse response) {
            if (this.countDown.decrementAndGet() == 0) {
                MetaDataMappingService.this.mappingCreatedAction.remove(this);
                if (this.notified.compareAndSet(false, true)) {
                    this.listener.onResponse(new Response(true));
                }
            }
        }

        @Override
        public void onTimeout() {
            MetaDataMappingService.this.mappingCreatedAction.remove(this);
            if (this.notified.compareAndSet(false, true)) {
                this.listener.onResponse(new Response(false));
            }
        }
    }

    public static class Response {
        private final boolean acknowledged;

        public Response(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class PutRequest {
        final String[] indices;
        final String mappingType;
        final String mappingSource;
        boolean ignoreConflicts = false;
        TimeValue timeout = TimeValue.timeValueSeconds(10L);

        public PutRequest(String[] indices2, String mappingType, String mappingSource) {
            this.indices = indices2;
            this.mappingType = mappingType;
            this.mappingSource = mappingSource;
        }

        public PutRequest ignoreConflicts(boolean ignoreConflicts) {
            this.ignoreConflicts = ignoreConflicts;
            return this;
        }

        public PutRequest timeout(TimeValue timeout2) {
            this.timeout = timeout2;
            return this;
        }
    }

    public static class RemoveRequest {
        final String[] indices;
        final String mappingType;

        public RemoveRequest(String[] indices2, String mappingType) {
            this.indices = indices2;
            this.mappingType = mappingType;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }
}

