/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.rest.RestStatus;

public class MetaData
implements Iterable<IndexMetaData> {
    public static Map<String, Custom.Factory> customFactories = new HashMap<String, Custom.Factory>();
    public static final String SETTING_READ_ONLY = "cluster.blocks.read_only";
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA);
    public static final MetaData EMPTY_META_DATA = MetaData.newMetaDataBuilder().build();
    private final long version;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final ImmutableMap<String, IndexMetaData> indices;
    private final ImmutableMap<String, IndexTemplateMetaData> templates;
    private final ImmutableMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final String[] allIndices;
    private final ImmutableSet<String> allIndicesSet;
    private final String[] allOpenIndices;
    private final ImmutableMap<String, ImmutableMap<String, AliasMetaData>> aliases;
    private final ImmutableMap<String, ImmutableMap<String, ImmutableSet<String>>> aliasToIndexToSearchRoutingMap;
    private final ImmutableMap<String, ImmutableMap<String, Boolean>> indexToAliasFilteringRequiredMap;
    private final ImmutableMap<String, String[]> aliasAndIndexToIndexMap;

    public static void registerFactory(String type2, Custom.Factory factory) {
        customFactories.put(type2, factory);
    }

    @Nullable
    public static <T extends Custom> Custom.Factory<T> lookupFactory(String type2) {
        return customFactories.get(type2);
    }

    public static <T extends Custom> Custom.Factory<T> lookupFactorySafe(String type2) throws ElasticSearchIllegalArgumentException {
        Custom.Factory factory = customFactories.get(type2);
        if (factory == null) {
            throw new ElasticSearchIllegalArgumentException("No custom index metadata factory registered for type [" + type2 + "]");
        }
        return factory;
    }

    MetaData(long version, Settings transientSettings, Settings persistentSettings, ImmutableMap<String, IndexMetaData> indices2, ImmutableMap<String, IndexTemplateMetaData> templates, ImmutableMap<String, Custom> customs) {
        this.version = version;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = ImmutableSettings.settingsBuilder().put(persistentSettings).put(transientSettings).build();
        this.indices = ImmutableMap.copyOf(indices2);
        this.customs = customs;
        this.templates = templates;
        int totalNumberOfShards = 0;
        for (IndexMetaData indexMetaData : indices2.values()) {
            totalNumberOfShards += indexMetaData.totalNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        ArrayList<String> allIndicesLst = Lists.newArrayList();
        for (IndexMetaData indexMetaData : indices2.values()) {
            allIndicesLst.add(indexMetaData.index());
        }
        this.allIndices = allIndicesLst.toArray(new String[allIndicesLst.size()]);
        this.allIndicesSet = ImmutableSet.copyOf(this.allIndices);
        ArrayList<String> allOpenIndices = Lists.newArrayList();
        for (IndexMetaData indexMetaData : indices2.values()) {
            if (indexMetaData.state() != IndexMetaData.State.OPEN) continue;
            allOpenIndices.add(indexMetaData.index());
        }
        this.allOpenIndices = allOpenIndices.toArray(new String[allOpenIndices.size()]);
        MapBuilder tmpAliasesMap = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices2.values()) {
            String index2 = indexMetaData.index();
            for (AliasMetaData aliasMd : indexMetaData.aliases().values()) {
                MapBuilder<String, AliasMetaData> indexAliasMap = (MapBuilder<String, AliasMetaData>)tmpAliasesMap.get(aliasMd.alias());
                if (indexAliasMap == null) {
                    indexAliasMap = MapBuilder.newMapBuilder();
                    tmpAliasesMap.put(aliasMd.alias(), indexAliasMap);
                }
                indexAliasMap.put(index2, aliasMd);
            }
        }
        MapBuilder aliases2 = MapBuilder.newMapBuilder();
        for (Map.Entry alias2 : tmpAliasesMap.map().entrySet()) {
            aliases2.put(alias2.getKey(), ((MapBuilder)alias2.getValue()).immutableMap());
        }
        this.aliases = aliases2.immutableMap();
        MapBuilder tmpAliasToIndexToSearchRoutingMap = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices2.values()) {
            for (AliasMetaData aliasMd : indexMetaData.aliases().values()) {
                MapBuilder indexToSearchRoutingMap = (MapBuilder)tmpAliasToIndexToSearchRoutingMap.get(aliasMd.alias());
                if (indexToSearchRoutingMap == null) {
                    indexToSearchRoutingMap = MapBuilder.newMapBuilder();
                    tmpAliasToIndexToSearchRoutingMap.put(aliasMd.alias(), indexToSearchRoutingMap);
                }
                if (aliasMd.searchRouting() != null) {
                    indexToSearchRoutingMap.put(indexMetaData.index(), ImmutableSet.copyOf(Strings.splitStringByCommaToSet(aliasMd.searchRouting())));
                    continue;
                }
                indexToSearchRoutingMap.put(indexMetaData.index(), ImmutableSet.of());
            }
        }
        MapBuilder aliasToIndexToSearchRoutingMap = MapBuilder.newMapBuilder();
        for (Map.Entry alias3 : tmpAliasToIndexToSearchRoutingMap.map().entrySet()) {
            aliasToIndexToSearchRoutingMap.put(alias3.getKey(), ((MapBuilder)alias3.getValue()).immutableMap());
        }
        this.aliasToIndexToSearchRoutingMap = aliasToIndexToSearchRoutingMap.immutableMap();
        MapBuilder filteringRequiredMap = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices2.values()) {
            MapBuilder<String, Boolean> indexFilteringRequiredMap = MapBuilder.newMapBuilder();
            indexFilteringRequiredMap.put(indexMetaData.index(), false);
            for (AliasMetaData aliasMetaData : indexMetaData.aliases().values()) {
                if (aliasMetaData.filter() != null) {
                    indexFilteringRequiredMap.put(aliasMetaData.alias(), true);
                    continue;
                }
                indexFilteringRequiredMap.put(aliasMetaData.alias(), false);
            }
            filteringRequiredMap.put(indexMetaData.index(), indexFilteringRequiredMap.immutableMap());
        }
        this.indexToAliasFilteringRequiredMap = filteringRequiredMap.immutableMap();
        MapBuilder tmpAliasAndIndexToIndexBuilder = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices2.values()) {
            Set<String> lst = (HashSet<String>)tmpAliasAndIndexToIndexBuilder.get(indexMetaData.index());
            if (lst == null) {
                lst = Sets.newHashSet();
                tmpAliasAndIndexToIndexBuilder.put(indexMetaData.index(), lst);
            }
            lst.add(indexMetaData.index());
            for (String alias4 : indexMetaData.aliases().keySet()) {
                lst = (Set)tmpAliasAndIndexToIndexBuilder.get(alias4);
                if (lst == null) {
                    lst = Sets.newHashSet();
                    tmpAliasAndIndexToIndexBuilder.put(alias4, lst);
                }
                lst.add(indexMetaData.index());
            }
        }
        MapBuilder aliasAndIndexToIndexBuilder = MapBuilder.newMapBuilder();
        for (Map.Entry entry : tmpAliasAndIndexToIndexBuilder.map().entrySet()) {
            aliasAndIndexToIndexBuilder.put(entry.getKey(), ((Set)entry.getValue()).toArray(new String[((Set)entry.getValue()).size()]));
        }
        this.aliasAndIndexToIndexMap = aliasAndIndexToIndexBuilder.immutableMap();
    }

    public long version() {
        return this.version;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public ImmutableMap<String, ImmutableMap<String, AliasMetaData>> aliases() {
        return this.aliases;
    }

    public ImmutableMap<String, ImmutableMap<String, AliasMetaData>> getAliases() {
        return this.aliases();
    }

    public String[] concreteAllIndices() {
        return this.allIndices;
    }

    public ImmutableSet<String> concreteAllIndicesAsSet() {
        return this.allIndicesSet;
    }

    public String[] getConcreteAllIndices() {
        return this.concreteAllIndices();
    }

    public String[] concreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        ImmutableMap<String, AliasMetaData> indexAliases = this.aliases.get(aliasOrIndex);
        if (indexAliases == null || indexAliases.isEmpty()) {
            return routing;
        }
        if (indexAliases.size() > 1) {
            throw new ElasticSearchIllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + indexAliases.keySet() + "], can't execute a single index op");
        }
        AliasMetaData aliasMd = (AliasMetaData)((ImmutableCollection)indexAliases.values()).iterator().next();
        if (aliasMd.indexRouting() != null) {
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new ElasticSearchIllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            routing = aliasMd.indexRouting();
        }
        if (routing != null && routing.indexOf(44) != -1) {
            throw new ElasticSearchIllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + routing + "] that resolved to several routing values, rejecting operation");
        }
        return routing;
    }

    public Map<String, Set<String>> resolveSearchRouting(@Nullable String routing, String aliasOrIndex) {
        return this.resolveSearchRouting(routing, this.convertFromWildcards(new String[]{aliasOrIndex}, true, IgnoreIndices.MISSING));
    }

    public Map<String, Set<String>> resolveSearchRouting(@Nullable String routing, String[] aliasesOrIndices) {
        if (this.isAllIndices(aliasesOrIndices)) {
            return this.resolveSearchRoutingAllIndices(routing);
        }
        if ((aliasesOrIndices = this.convertFromWildcards(aliasesOrIndices, true, IgnoreIndices.MISSING)).length == 1) {
            return this.resolveSearchRoutingSingleValue(routing, aliasesOrIndices[0]);
        }
        HashMap<String, THashSet<Object>> routings = null;
        Set<String> paramRouting = null;
        THashSet<Object> norouting = new THashSet<Object>();
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        for (String aliasOrIndex : aliasesOrIndices) {
            ImmutableMap<String, ImmutableSet<String>> indexToRoutingMap = this.aliasToIndexToSearchRoutingMap.get(aliasOrIndex);
            if (indexToRoutingMap != null && !indexToRoutingMap.isEmpty()) {
                for (Map.Entry indexRouting : indexToRoutingMap.entrySet()) {
                    THashSet<Object> r;
                    if (norouting.contains(indexRouting.getKey())) continue;
                    if (!((ImmutableSet)indexRouting.getValue()).isEmpty()) {
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        if ((r = (THashSet)routings.get(indexRouting.getKey())) == null) {
                            r = new THashSet();
                            routings.put((String)indexRouting.getKey(), r);
                        }
                        r.addAll((Collection)indexRouting.getValue());
                        if (paramRouting != null) {
                            r.retainAll(paramRouting);
                        }
                        if (!r.isEmpty()) continue;
                        routings.remove(indexRouting.getKey());
                        continue;
                    }
                    if (norouting.contains(indexRouting.getKey())) continue;
                    norouting.add(indexRouting.getKey());
                    if (paramRouting != null) {
                        r = new THashSet<String>(paramRouting);
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        routings.put((String)indexRouting.getKey(), r);
                        continue;
                    }
                    if (routings == null) continue;
                    routings.remove(indexRouting.getKey());
                }
                continue;
            }
            if (norouting.contains(aliasOrIndex)) continue;
            norouting.add(aliasOrIndex);
            if (paramRouting != null) {
                THashSet<String> r = new THashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put(aliasOrIndex, r);
                continue;
            }
            if (routings == null) continue;
            routings.remove(aliasOrIndex);
        }
        if (routings == null || routings.isEmpty()) {
            return null;
        }
        return routings;
    }

    private Map<String, Set<String>> resolveSearchRoutingSingleValue(@Nullable String routing, String aliasOrIndex) {
        ImmutableMap<String, ImmutableSet<String>> indexToRoutingMap;
        Map<String, Set<String>> routings = null;
        Set<String> paramRouting = null;
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        if ((indexToRoutingMap = this.aliasToIndexToSearchRoutingMap.get(aliasOrIndex)) != null && !indexToRoutingMap.isEmpty()) {
            for (Map.Entry indexRouting : indexToRoutingMap.entrySet()) {
                THashSet<Object> r;
                if (!((ImmutableSet)indexRouting.getValue()).isEmpty()) {
                    r = new THashSet((Collection)indexRouting.getValue());
                    if (paramRouting != null) {
                        r.retainAll(paramRouting);
                    }
                    if (r.isEmpty()) continue;
                    if (routings == null) {
                        routings = Maps.newHashMap();
                    }
                    routings.put((String)indexRouting.getKey(), (Set<String>)r);
                    continue;
                }
                if (paramRouting == null) continue;
                r = new THashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put((String)indexRouting.getKey(), (Set<String>)r);
            }
        } else if (paramRouting != null) {
            routings = ImmutableMap.of(aliasOrIndex, paramRouting);
        }
        return routings;
    }

    private Map<String, Set<String>> resolveSearchRoutingAllIndices(String routing) {
        if (routing != null) {
            String[] concreteIndices;
            Set<String> r = Strings.splitStringByCommaToSet(routing);
            HashMap<String, Set<String>> routings = Maps.newHashMap();
            for (String index2 : concreteIndices = this.concreteAllIndices()) {
                routings.put(index2, r);
            }
            return routings;
        }
        return null;
    }

    public String[] concreteIndices(String[] indices2) throws IndexMissingException {
        return this.concreteIndices(indices2, IgnoreIndices.NONE, false);
    }

    public String[] concreteIndicesIgnoreMissing(String[] indices2) {
        return this.concreteIndices(indices2, IgnoreIndices.MISSING, false);
    }

    public String[] concreteIndices(String[] aliasesOrIndices, IgnoreIndices ignoreIndices, boolean allOnlyOpen) throws IndexMissingException {
        if (this.isAllIndices(aliasesOrIndices)) {
            return allOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices();
        }
        if ((aliasesOrIndices = this.convertFromWildcards(aliasesOrIndices, allOnlyOpen, ignoreIndices)).length == 1) {
            String aliasOrIndex = aliasesOrIndices[0];
            if (this.indices.containsKey(aliasOrIndex)) {
                return aliasesOrIndices;
            }
            String[] actualLst = this.aliasAndIndexToIndexMap.get(aliasOrIndex);
            if (actualLst == null) {
                if (ignoreIndices == IgnoreIndices.MISSING) {
                    return Strings.EMPTY_ARRAY;
                }
                throw new IndexMissingException(new Index(aliasOrIndex));
            }
            return actualLst;
        }
        boolean possiblyAliased = false;
        for (String index2 : aliasesOrIndices) {
            if (this.indices.containsKey(index2)) continue;
            possiblyAliased = true;
            break;
        }
        if (!possiblyAliased) {
            return aliasesOrIndices;
        }
        THashSet<String> actualIndices = new THashSet<String>();
        for (String index3 : aliasesOrIndices) {
            String[] actualLst = this.aliasAndIndexToIndexMap.get(index3);
            if (actualLst == null) {
                if (ignoreIndices == IgnoreIndices.MISSING) continue;
                throw new IndexMissingException(new Index(index3));
            }
            for (String x : actualLst) {
                actualIndices.add(x);
            }
        }
        return actualIndices.toArray(new String[actualIndices.size()]);
    }

    public String concreteIndex(String index2) throws IndexMissingException, ElasticSearchIllegalArgumentException {
        if (this.indices.containsKey(index2)) {
            return index2;
        }
        Object[] lst = this.aliasAndIndexToIndexMap.get(index2);
        if (lst == null) {
            throw new IndexMissingException(new Index(index2));
        }
        if (lst.length > 1) {
            throw new ElasticSearchIllegalArgumentException("Alias [" + index2 + "] has more than one indices associated with it [" + Arrays.toString(lst) + "], can't execute a single index op");
        }
        return lst[0];
    }

    public String[] convertFromWildcards(String[] aliasesOrIndices, boolean wildcardOnlyOpen, IgnoreIndices ignoreIndices) {
        THashSet<Object> result2 = null;
        for (int i2 = 0; i2 < aliasesOrIndices.length; ++i2) {
            String aliasOrIndex = aliasesOrIndices[i2];
            if (this.aliasAndIndexToIndexMap.containsKey(aliasOrIndex)) {
                if (result2 == null) continue;
                result2.add(aliasOrIndex);
                continue;
            }
            boolean add3 = true;
            if (aliasOrIndex.charAt(0) == '+') {
                add3 = true;
                aliasOrIndex = aliasOrIndex.substring(1);
            } else if (aliasOrIndex.charAt(0) == '-') {
                if (i2 == 0) {
                    result2 = new THashSet<String>(Arrays.asList(wildcardOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices()));
                }
                add3 = false;
                aliasOrIndex = aliasOrIndex.substring(1);
            }
            if (!Regex.isSimpleMatchPattern(aliasOrIndex)) {
                if (ignoreIndices != IgnoreIndices.MISSING && !this.aliasAndIndexToIndexMap.containsKey(aliasOrIndex)) {
                    throw new IndexMissingException(new Index(aliasOrIndex));
                }
                if (result2 == null) continue;
                if (add3) {
                    result2.add(aliasOrIndex);
                    continue;
                }
                result2.remove(aliasOrIndex);
                continue;
            }
            if (result2 == null) {
                result2 = new THashSet<String>();
                result2.addAll(Arrays.asList(aliasesOrIndices).subList(0, i2));
            }
            String[] indices2 = wildcardOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices();
            boolean found = false;
            for (String index2 : indices2) {
                if (!Regex.simpleMatch(aliasOrIndex, index2)) continue;
                found = true;
                if (add3) {
                    result2.add(index2);
                    continue;
                }
                result2.remove(index2);
            }
            for (String alias2 : this.aliases.keySet()) {
                if (!Regex.simpleMatch(aliasOrIndex, alias2)) continue;
                found = true;
                if (add3) {
                    result2.add(alias2);
                    continue;
                }
                result2.remove(alias2);
            }
            if (found || ignoreIndices == IgnoreIndices.MISSING) continue;
            throw new IndexMissingException(new Index(aliasOrIndex));
        }
        if (result2 == null) {
            return aliasesOrIndices;
        }
        return result2.toArray(new String[result2.size()]);
    }

    public boolean hasIndex(String index2) {
        return this.indices.containsKey(index2);
    }

    public boolean hasConcreteIndex(String index2) {
        return this.aliasAndIndexToIndexMap.containsKey(index2);
    }

    public IndexMetaData index(String index2) {
        return this.indices.get(index2);
    }

    public ImmutableMap<String, IndexMetaData> indices() {
        return this.indices;
    }

    public ImmutableMap<String, IndexMetaData> getIndices() {
        return this.indices();
    }

    public ImmutableMap<String, IndexTemplateMetaData> templates() {
        return this.templates;
    }

    public ImmutableMap<String, IndexTemplateMetaData> getTemplates() {
        return this.templates;
    }

    public ImmutableMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public int totalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards();
    }

    public String[] filteringAliases(String index2, String ... indices2) {
        if (this.isAllIndices(indices2)) {
            return null;
        }
        if (indices2.length == 1) {
            String alias2 = indices2[0];
            ImmutableMap<String, Boolean> aliasToFilteringRequiredMap = this.indexToAliasFilteringRequiredMap.get(index2);
            if (aliasToFilteringRequiredMap == null) {
                throw new IndexMissingException(new Index(index2));
            }
            Boolean filteringRequired = aliasToFilteringRequiredMap.get(alias2);
            if (filteringRequired == null || !filteringRequired.booleanValue()) {
                return null;
            }
            return new String[]{alias2};
        }
        ArrayList<String> filteringAliases = null;
        for (String alias3 : indices2) {
            ImmutableMap<String, Boolean> aliasToFilteringRequiredMap = this.indexToAliasFilteringRequiredMap.get(index2);
            if (aliasToFilteringRequiredMap == null) {
                throw new IndexMissingException(new Index(index2));
            }
            Boolean filteringRequired = aliasToFilteringRequiredMap.get(alias3);
            if (filteringRequired == null) continue;
            if (filteringRequired.booleanValue()) {
                if (filteringAliases == null) {
                    filteringAliases = Lists.newArrayList();
                }
                filteringAliases.add(alias3);
                continue;
            }
            return null;
        }
        if (filteringAliases == null) {
            return null;
        }
        return filteringAliases.toArray(new String[filteringAliases.size()]);
    }

    private boolean isAllIndices(String[] aliasesOrIndices) {
        return aliasesOrIndices == null || aliasesOrIndices.length == 0 || aliasesOrIndices.length == 1 && "_all".equals(aliasesOrIndices[0]);
    }

    @Override
    public UnmodifiableIterator<IndexMetaData> iterator() {
        return ((ImmutableCollection)this.indices.values()).iterator();
    }

    public static boolean isGlobalStateEquals(MetaData metaData1, MetaData metaData2) {
        if (!metaData1.persistentSettings.equals(metaData2.persistentSettings)) {
            return false;
        }
        return metaData1.templates.equals(metaData2.templates());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newMetaDataBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long version;
        private Settings transientSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private Settings persistentSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private MapBuilder<String, IndexMetaData> indices = MapBuilder.newMapBuilder();
        private MapBuilder<String, IndexTemplateMetaData> templates = MapBuilder.newMapBuilder();
        private MapBuilder<String, Custom> customs = MapBuilder.newMapBuilder();

        public Builder metaData(MetaData metaData) {
            this.transientSettings = metaData.transientSettings;
            this.persistentSettings = metaData.persistentSettings;
            this.version = metaData.version;
            this.indices.putAll(metaData.indices);
            this.templates.putAll(metaData.templates);
            this.customs.putAll(metaData.customs);
            return this;
        }

        public Builder put(IndexMetaData.Builder indexMetaDataBuilder) {
            indexMetaDataBuilder.version(indexMetaDataBuilder.version() + 1L);
            IndexMetaData indexMetaData = indexMetaDataBuilder.build();
            this.indices.put(indexMetaData.index(), indexMetaData);
            return this;
        }

        public Builder put(IndexMetaData indexMetaData, boolean incrementVersion) {
            if (this.indices.get(indexMetaData.index()) == indexMetaData) {
                return this;
            }
            if (incrementVersion) {
                indexMetaData = IndexMetaData.newIndexMetaDataBuilder(indexMetaData).version(indexMetaData.version() + 1L).build();
            }
            this.indices.put(indexMetaData.index(), indexMetaData);
            return this;
        }

        public IndexMetaData get(String index2) {
            return this.indices.get(index2);
        }

        public Builder remove(String index2) {
            this.indices.remove(index2);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder put(IndexTemplateMetaData.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetaData template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Custom getCustom(String type2) {
            return this.customs.get(type2);
        }

        public Builder putCustom(String type2, Custom custom) {
            this.customs.put(type2, custom);
            return this;
        }

        public Builder removeCustom(String type2) {
            this.customs.remove(type2);
            return this;
        }

        public Builder updateSettings(Settings settings, String ... indices2) {
            if (indices2 == null || indices2.length == 0) {
                indices2 = this.indices.map().keySet().toArray(new String[this.indices.map().keySet().size()]);
            }
            for (String index2 : indices2) {
                IndexMetaData indexMetaData = this.indices.get(index2);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index2));
                }
                this.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).settings(ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).put(settings)));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices2) {
            if (indices2 == null || indices2.length == 0) {
                indices2 = this.indices.map().keySet().toArray(new String[this.indices.map().keySet().size()]);
            }
            for (String index2 : indices2) {
                IndexMetaData indexMetaData = this.indices.get(index2);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index2));
                }
                this.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public MetaData build() {
            return new MetaData(this.version, this.transientSettings, this.persistentSettings, this.indices.immutableMap(), this.templates.immutableMap(), this.customs.immutableMap());
        }

        public static String toXContent(MetaData metaData) throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }

        public static void toXContent(MetaData metaData, XContentBuilder builder, ToXContent.Params params2) throws IOException {
            builder.startObject("meta-data");
            builder.field("version", metaData.version());
            if (!metaData.persistentSettings().getAsMap().isEmpty()) {
                builder.startObject("settings");
                for (Map.Entry entry : metaData.persistentSettings().getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            builder.startObject("templates");
            for (IndexTemplateMetaData template : metaData.templates().values()) {
                IndexTemplateMetaData.Builder.toXContent(template, builder, params2);
            }
            builder.endObject();
            if (!metaData.indices().isEmpty()) {
                builder.startObject("indices");
                for (IndexMetaData indexMetaData : metaData) {
                    IndexMetaData.Builder.toXContent(indexMetaData, builder, params2);
                }
                builder.endObject();
            }
            for (Map.Entry entry : metaData.customs().entrySet()) {
                builder.startObject((String)entry.getKey());
                MetaData.lookupFactorySafe((String)entry.getKey()).toXContent((Custom)entry.getValue(), builder, params2);
                builder.endObject();
            }
            builder.endObject();
        }

        public static MetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
                if (token == null) {
                    return builder.build();
                }
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(ImmutableSettings.settingsBuilder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())).build());
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetaData.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetaData.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    Custom.Factory factory = MetaData.lookupFactory(currentFieldName);
                    if (factory == null) {
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(factory.type(), (Custom)factory.fromXContent(parser));
                    continue;
                }
                if (!token.isValue() || !"version".equals(currentFieldName)) continue;
                builder.version = parser.longValue();
            }
            return builder.build();
        }

        public static MetaData readFrom(StreamInput in) throws IOException {
            int i2;
            Builder builder = new Builder();
            builder.version = in.readLong();
            builder.transientSettings(ImmutableSettings.readSettingsFromStream(in));
            builder.persistentSettings(ImmutableSettings.readSettingsFromStream(in));
            int size2 = in.readVInt();
            for (i2 = 0; i2 < size2; ++i2) {
                builder.put(IndexMetaData.Builder.readFrom(in), false);
            }
            size2 = in.readVInt();
            for (i2 = 0; i2 < size2; ++i2) {
                builder.put(IndexTemplateMetaData.Builder.readFrom(in));
            }
            int customSize = in.readVInt();
            for (int i3 = 0; i3 < customSize; ++i3) {
                String type2 = in.readUTF();
                Object customIndexMetaData = MetaData.lookupFactorySafe(type2).readFrom(in);
                builder.putCustom(type2, (Custom)customIndexMetaData);
            }
            return builder.build();
        }

        public static void writeTo(MetaData metaData, StreamOutput out) throws IOException {
            out.writeLong(metaData.version);
            ImmutableSettings.writeSettingsToStream(metaData.transientSettings(), out);
            ImmutableSettings.writeSettingsToStream(metaData.persistentSettings(), out);
            out.writeVInt(metaData.indices.size());
            for (IndexMetaData indexMetaData : metaData) {
                IndexMetaData.Builder.writeTo(indexMetaData, out);
            }
            out.writeVInt(metaData.templates.size());
            for (IndexTemplateMetaData template : metaData.templates.values()) {
                IndexTemplateMetaData.Builder.writeTo(template, out);
            }
            out.writeVInt(metaData.customs().size());
            for (Map.Entry entry : metaData.customs().entrySet()) {
                out.writeUTF((String)entry.getKey());
                MetaData.lookupFactorySafe((String)entry.getKey()).writeTo((Custom)entry.getValue(), out);
            }
        }
    }

    public static interface Custom {

        public static interface Factory<T extends Custom> {
            public String type();

            public T readFrom(StreamInput var1) throws IOException;

            public void writeTo(T var1, StreamOutput var2) throws IOException;

            public T fromXContent(XContentParser var1) throws IOException;

            public void toXContent(T var1, XContentBuilder var2, ToXContent.Params var3);
        }
    }
}

