/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.FilterBuilder;

public class AliasAction
implements Streamable {
    private Type actionType;
    private String index;
    private String alias;
    @Nullable
    private String filter;
    @Nullable
    private String indexRouting;
    @Nullable
    private String searchRouting;

    private AliasAction() {
    }

    public AliasAction(Type actionType, String index2, String alias2) {
        this.actionType = actionType;
        this.index = index2;
        this.alias = alias2;
    }

    public AliasAction(Type actionType, String index2, String alias2, String filter) {
        this.actionType = actionType;
        this.index = index2;
        this.alias = alias2;
        this.filter = filter;
    }

    public Type actionType() {
        return this.actionType;
    }

    public String index() {
        return this.index;
    }

    public String alias() {
        return this.alias;
    }

    public String filter() {
        return this.filter;
    }

    public AliasAction filter(String filter) {
        this.filter = filter;
        return this;
    }

    public AliasAction filter(Map<String, Object> filter) {
        if (filter == null || filter.isEmpty()) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(filter);
            this.filter = builder.string();
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + filter + "]", e);
        }
    }

    public AliasAction filter(FilterBuilder filterBuilder) {
        if (filterBuilder == null) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            filterBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.close();
            this.filter = builder.string();
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to build json for alias request", e);
        }
    }

    public AliasAction routing(String routing) {
        this.indexRouting = routing;
        this.searchRouting = routing;
        return this;
    }

    public String indexRouting() {
        return this.indexRouting;
    }

    public AliasAction indexRouting(String indexRouting) {
        this.indexRouting = indexRouting;
        return this;
    }

    public String searchRouting() {
        return this.searchRouting;
    }

    public AliasAction searchRouting(String searchRouting) {
        this.searchRouting = searchRouting;
        return this;
    }

    public static AliasAction readAliasAction(StreamInput in) throws IOException {
        AliasAction aliasAction = new AliasAction();
        aliasAction.readFrom(in);
        return aliasAction;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.actionType = Type.fromValue(in.readByte());
        this.index = in.readUTF();
        this.alias = in.readUTF();
        if (in.readBoolean()) {
            this.filter = in.readUTF();
        }
        if (in.readBoolean()) {
            this.indexRouting = in.readUTF();
        }
        if (in.readBoolean()) {
            this.searchRouting = in.readUTF();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.actionType.value());
        out.writeUTF(this.index);
        out.writeUTF(this.alias);
        if (this.filter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.filter);
        }
        if (this.indexRouting == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.indexRouting);
        }
        if (this.searchRouting == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.searchRouting);
        }
    }

    public static AliasAction newAddAliasAction(String index2, String alias2) {
        return new AliasAction(Type.ADD, index2, alias2);
    }

    public static AliasAction newRemoveAliasAction(String index2, String alias2) {
        return new AliasAction(Type.REMOVE, index2, alias2);
    }

    public static enum Type {
        ADD(0),
        REMOVE(1);

        private final byte value;

        private Type(byte value2) {
            this.value = value2;
        }

        public byte value() {
            return this.value;
        }

        public static Type fromValue(byte value2) {
            if (value2 == 0) {
                return ADD;
            }
            if (value2 == 1) {
                return REMOVE;
            }
            throw new ElasticSearchIllegalArgumentException("No type for action [" + value2 + "]");
        }
    }
}

