/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum ClusterBlockLevel {
    READ(0),
    WRITE(1),
    METADATA(2);

    public static final ClusterBlockLevel[] ALL;
    public static final ClusterBlockLevel[] READ_WRITE;
    private final int id;

    private ClusterBlockLevel(int id2) {
        this.id = id2;
    }

    public int id() {
        return this.id;
    }

    public static ClusterBlockLevel fromId(int id2) {
        if (id2 == 0) {
            return READ;
        }
        if (id2 == 1) {
            return WRITE;
        }
        if (id2 == 2) {
            return METADATA;
        }
        throw new ElasticSearchIllegalArgumentException("No cluster block level matching [" + id2 + "]");
    }

    static {
        ALL = new ClusterBlockLevel[]{READ, WRITE, METADATA};
        READ_WRITE = new ClusterBlockLevel[]{READ, WRITE};
    }
}

