/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;

public class ClusterState
implements ToXContent {
    public static Map<String, Custom.Factory> customFactories = new HashMap<String, Custom.Factory>();
    private final long version;
    private final RoutingTable routingTable;
    private final DiscoveryNodes nodes;
    private final MetaData metaData;
    private final ClusterBlocks blocks;
    private final AllocationExplanation allocationExplanation;
    private final ImmutableMap<String, Custom> customs;
    private volatile RoutingNodes routingNodes;
    private SettingsFilter settingsFilter;

    public static void registerFactory(String type2, Custom.Factory factory) {
        customFactories.put(type2, factory);
    }

    @Nullable
    public static <T extends Custom> Custom.Factory<T> lookupFactory(String type2) {
        return customFactories.get(type2);
    }

    public static <T extends Custom> Custom.Factory<T> lookupFactorySafe(String type2) throws ElasticSearchIllegalArgumentException {
        Custom.Factory factory = customFactories.get(type2);
        if (factory == null) {
            throw new ElasticSearchIllegalArgumentException("No custom state factory registered for type [" + type2 + "]");
        }
        return factory;
    }

    public ClusterState(long version, ClusterState state2) {
        this(version, state2.metaData(), state2.routingTable(), state2.nodes(), state2.blocks(), state2.allocationExplanation(), state2.customs());
    }

    public ClusterState(long version, MetaData metaData, RoutingTable routingTable, DiscoveryNodes nodes, ClusterBlocks blocks2, AllocationExplanation allocationExplanation, ImmutableMap<String, Custom> customs) {
        this.version = version;
        this.metaData = metaData;
        this.routingTable = routingTable;
        this.nodes = nodes;
        this.blocks = blocks2;
        this.allocationExplanation = allocationExplanation;
        this.customs = customs;
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version();
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public DiscoveryNodes getNodes() {
        return this.nodes();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        return this.metaData();
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public RoutingNodes routingNodes() {
        return this.routingTable.routingNodes(this);
    }

    public RoutingNodes getRoutingNodes() {
        return this.readOnlyRoutingNodes();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public AllocationExplanation allocationExplanation() {
        return this.allocationExplanation;
    }

    public AllocationExplanation getAllocationExplanation() {
        return this.allocationExplanation();
    }

    public ImmutableMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public RoutingNodes readOnlyRoutingNodes() {
        if (this.routingNodes != null) {
            return this.routingNodes;
        }
        this.routingNodes = this.routingTable.routingNodes(this);
        return this.routingNodes;
    }

    public ClusterState settingsFilter(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (!params2.paramAsBoolean("filter_nodes", false)) {
            builder.field("master_node", this.nodes().masterNodeId());
        }
        if (!params2.paramAsBoolean("filter_blocks", false)) {
            builder.startObject("blocks");
            if (!this.blocks().global().isEmpty()) {
                builder.startObject("global");
                for (ClusterBlock clusterBlock : this.blocks().global()) {
                    clusterBlock.toXContent(builder, params2);
                }
                builder.endObject();
            }
            if (!this.blocks().indices().isEmpty()) {
                builder.startObject("indices");
                for (Map.Entry entry : this.blocks().indices().entrySet()) {
                    builder.startObject((String)entry.getKey());
                    for (ClusterBlock block : (ImmutableSet)entry.getValue()) {
                        block.toXContent(builder, params2);
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
        }
        if (!params2.paramAsBoolean("filter_nodes", false)) {
            builder.startObject("nodes");
            for (DiscoveryNode discoveryNode : this.nodes()) {
                builder.startObject(discoveryNode.id(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field("name", discoveryNode.name());
                builder.field("transport_address", discoveryNode.address().toString());
                builder.startObject("attributes");
                for (Map.Entry attr2 : discoveryNode.attributes().entrySet()) {
                    builder.field((String)attr2.getKey(), (String)attr2.getValue());
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
        }
        if (!params2.paramAsBoolean("filter_metadata", false)) {
            Map<String, Object> mapping;
            XContentParser parser;
            byte[] mappingSource;
            Settings settings;
            builder.startObject("metadata");
            builder.startObject("templates");
            for (IndexTemplateMetaData indexTemplateMetaData : this.metaData().templates().values()) {
                builder.startObject(indexTemplateMetaData.name(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field("template", indexTemplateMetaData.template());
                builder.field("order", indexTemplateMetaData.order());
                builder.startObject("settings");
                settings = this.settingsFilter.filterSettings(indexTemplateMetaData.settings());
                for (Map.Entry entry : settings.getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
                builder.startObject("mappings");
                for (Map.Entry entry : indexTemplateMetaData.mappings().entrySet()) {
                    mappingSource = ((CompressedString)entry.getValue()).uncompressed();
                    parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                    mapping = parser.map();
                    if (mapping.size() == 1 && mapping.containsKey(entry.getKey())) {
                        mapping = (Map<String, Object>)mapping.get(entry.getKey());
                    }
                    builder.field((String)entry.getKey());
                    builder.map(mapping);
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.startObject("indices");
            for (IndexMetaData indexMetaData : this.metaData()) {
                builder.startObject(indexMetaData.index(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field("state", indexMetaData.state().toString().toLowerCase(Locale.ENGLISH));
                builder.startObject("settings");
                settings = this.settingsFilter.filterSettings(indexMetaData.settings());
                for (Map.Entry entry : settings.getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
                builder.startObject("mappings");
                for (Map.Entry entry : indexMetaData.mappings().entrySet()) {
                    mappingSource = ((MappingMetaData)entry.getValue()).source().uncompressed();
                    parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                    mapping = parser.map();
                    if (mapping.size() == 1 && mapping.containsKey(entry.getKey())) {
                        mapping = (Map)mapping.get(entry.getKey());
                    }
                    builder.field((String)entry.getKey());
                    builder.map(mapping);
                }
                builder.endObject();
                builder.startArray("aliases");
                for (String alias2 : indexMetaData.aliases().keySet()) {
                    builder.value(alias2);
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (!params2.paramAsBoolean("filter_routing_table", false)) {
            builder.startObject("routing_table");
            builder.startObject("indices");
            for (IndexRoutingTable indexRoutingTable : this.routingTable()) {
                builder.startObject(indexRoutingTable.index(), XContentBuilder.FieldCaseConversion.NONE);
                builder.startObject("shards");
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.startArray(Integer.toString(indexShardRoutingTable.shardId().id()));
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        shardRouting.toXContent(builder, params2);
                    }
                    builder.endArray();
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (!params2.paramAsBoolean("filter_routing_table", false)) {
            builder.startObject("routing_nodes");
            builder.startArray("unassigned");
            for (MutableShardRouting mutableShardRouting : this.readOnlyRoutingNodes().unassigned()) {
                mutableShardRouting.toXContent(builder, params2);
            }
            builder.endArray();
            builder.startObject("nodes");
            for (RoutingNode routingNode : this.readOnlyRoutingNodes()) {
                builder.startArray(routingNode.nodeId(), XContentBuilder.FieldCaseConversion.NONE);
                for (MutableShardRouting shardRouting : routingNode) {
                    shardRouting.toXContent(builder, params2);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        if (!params2.paramAsBoolean("filter_routing_table", false)) {
            builder.startArray("allocations");
            for (Map.Entry entry : this.allocationExplanation().explanations().entrySet()) {
                builder.startObject();
                builder.field("index", ((ShardId)entry.getKey()).index().name());
                builder.field("shard", ((ShardId)entry.getKey()).id());
                builder.startArray("explanations");
                for (AllocationExplanation.NodeExplanation nodeExplanation : (List)entry.getValue()) {
                    builder.field("desc", nodeExplanation.description());
                    if (nodeExplanation.node() == null) continue;
                    builder.startObject("node");
                    builder.field("id", nodeExplanation.node().id());
                    builder.field("name", nodeExplanation.node().name());
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endArray();
        }
        if (!params2.paramAsBoolean("filter_customs", false)) {
            for (Map.Entry entry : this.customs().entrySet()) {
                builder.startObject((String)entry.getKey());
                ClusterState.lookupFactorySafe((String)entry.getKey()).toXContent((Custom)entry.getValue(), builder, params2);
                builder.endObject();
            }
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newClusterStateBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long version = 0L;
        private MetaData metaData = MetaData.EMPTY_META_DATA;
        private RoutingTable routingTable = RoutingTable.EMPTY_ROUTING_TABLE;
        private DiscoveryNodes nodes = DiscoveryNodes.EMPTY_NODES;
        private ClusterBlocks blocks = ClusterBlocks.EMPTY_CLUSTER_BLOCK;
        private AllocationExplanation allocationExplanation = AllocationExplanation.EMPTY;
        private MapBuilder<String, Custom> customs = MapBuilder.newMapBuilder();

        public Builder nodes(DiscoveryNodes.Builder nodesBuilder) {
            return this.nodes(nodesBuilder.build());
        }

        public Builder nodes(DiscoveryNodes nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder routingTable(RoutingTable.Builder routingTable) {
            return this.routingTable(routingTable.build());
        }

        public Builder routingResult(RoutingAllocation.Result routingResult) {
            this.routingTable = routingResult.routingTable();
            this.allocationExplanation = routingResult.explanation();
            return this;
        }

        public Builder routingTable(RoutingTable routingTable) {
            this.routingTable = routingTable;
            return this;
        }

        public Builder metaData(MetaData.Builder metaDataBuilder) {
            return this.metaData(metaDataBuilder.build());
        }

        public Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder blocks(ClusterBlocks.Builder blocksBuilder) {
            return this.blocks(blocksBuilder.build());
        }

        public Builder blocks(ClusterBlocks block) {
            this.blocks = block;
            return this;
        }

        public Builder allocationExplanation(AllocationExplanation allocationExplanation) {
            this.allocationExplanation = allocationExplanation;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Custom getCustom(String type2) {
            return this.customs.get(type2);
        }

        public Builder putCustom(String type2, Custom custom) {
            this.customs.put(type2, custom);
            return this;
        }

        public Builder removeCustom(String type2) {
            this.customs.remove(type2);
            return this;
        }

        public Builder state(ClusterState state2) {
            this.version = state2.version();
            this.nodes = state2.nodes();
            this.routingTable = state2.routingTable();
            this.metaData = state2.metaData();
            this.blocks = state2.blocks();
            this.allocationExplanation = state2.allocationExplanation();
            this.customs.clear().putAll(state2.customs());
            return this;
        }

        public ClusterState build() {
            return new ClusterState(this.version, this.metaData, this.routingTable, this.nodes, this.blocks, this.allocationExplanation, this.customs.immutableMap());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static byte[] toBytes(ClusterState state2) throws IOException {
            CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
            try {
                BytesStreamOutput os = cachedEntry.bytes();
                Builder.writeTo(state2, os);
                byte[] byArray = os.bytes().copyBytesArray().toBytes();
                return byArray;
            }
            finally {
                CachedStreamOutput.pushEntry(cachedEntry);
            }
        }

        public static ClusterState fromBytes(byte[] data2, DiscoveryNode localNode) throws IOException {
            return Builder.readFrom(new BytesStreamInput(data2, false), localNode);
        }

        public static void writeTo(ClusterState state2, StreamOutput out) throws IOException {
            out.writeLong(state2.version());
            MetaData.Builder.writeTo(state2.metaData(), out);
            RoutingTable.Builder.writeTo(state2.routingTable(), out);
            DiscoveryNodes.Builder.writeTo(state2.nodes(), out);
            ClusterBlocks.Builder.writeClusterBlocks(state2.blocks(), out);
            state2.allocationExplanation().writeTo(out);
            out.writeVInt(state2.customs().size());
            for (Map.Entry entry : state2.customs().entrySet()) {
                out.writeString((String)entry.getKey());
                ClusterState.lookupFactorySafe((String)entry.getKey()).writeTo((Custom)entry.getValue(), out);
            }
        }

        public static ClusterState readFrom(StreamInput in, @Nullable DiscoveryNode localNode) throws IOException {
            Builder builder = new Builder();
            builder.version = in.readLong();
            builder.metaData = MetaData.Builder.readFrom(in);
            builder.routingTable = RoutingTable.Builder.readFrom(in);
            builder.nodes = DiscoveryNodes.Builder.readFrom(in, localNode);
            builder.blocks = ClusterBlocks.Builder.readClusterBlocks(in);
            builder.allocationExplanation = AllocationExplanation.readAllocationExplanation(in);
            int customSize = in.readVInt();
            for (int i2 = 0; i2 < customSize; ++i2) {
                String type2 = in.readString();
                Object customIndexMetaData = ClusterState.lookupFactorySafe(type2).readFrom(in);
                builder.putCustom(type2, (Custom)customIndexMetaData);
            }
            return builder.build();
        }
    }

    public static interface Custom {

        public static interface Factory<T extends Custom> {
            public String type();

            public T readFrom(StreamInput var1) throws IOException;

            public void writeTo(T var1, StreamOutput var2) throws IOException;

            public void toXContent(T var1, XContentBuilder var2, ToXContent.Params var3);
        }
    }
}

