/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum IgnoreIndices {
    DEFAULT(0),
    NONE(1),
    MISSING(2);

    private final byte id;

    private IgnoreIndices(byte id2) {
        this.id = id2;
    }

    public byte id() {
        return this.id;
    }

    public static IgnoreIndices fromId(byte id2) {
        if (id2 == 0) {
            return DEFAULT;
        }
        if (id2 == 1) {
            return NONE;
        }
        if (id2 == 2) {
            return MISSING;
        }
        throw new ElasticSearchIllegalArgumentException("No valid missing index type id: " + id2);
    }

    public static IgnoreIndices fromString(String type2) {
        if ("none".equals(type2)) {
            return NONE;
        }
        if ("missing".equals(type2)) {
            return MISSING;
        }
        throw new ElasticSearchIllegalArgumentException("No valid missing index type: " + type2);
    }
}

