/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchInterruptedException;
import org.elasticsearch.ElasticSearchTimeoutException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.BaseFuture;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;

public abstract class AdapterActionFuture<T, L>
extends BaseFuture<T>
implements ActionFuture<T>,
ActionListener<L> {
    private Throwable rootFailure;

    @Override
    public T actionGet() throws ElasticSearchException {
        try {
            return (T)this.get();
        }
        catch (InterruptedException e) {
            throw new ElasticSearchInterruptedException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw AdapterActionFuture.rethrowExecutionException(e);
        }
    }

    @Override
    public T actionGet(String timeout2) throws ElasticSearchException {
        return this.actionGet(TimeValue.parseTimeValue(timeout2, null));
    }

    @Override
    public T actionGet(long timeoutMillis) throws ElasticSearchException {
        return this.actionGet(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(TimeValue timeout2) throws ElasticSearchException {
        return this.actionGet(timeout2.millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(long timeout2, TimeUnit unit) throws ElasticSearchException {
        try {
            return (T)this.get(timeout2, unit);
        }
        catch (TimeoutException e) {
            throw new ElasticSearchTimeoutException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new ElasticSearchInterruptedException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw AdapterActionFuture.rethrowExecutionException(e);
        }
    }

    static ElasticSearchException rethrowExecutionException(ExecutionException e) {
        if (e.getCause() instanceof ElasticSearchException) {
            ElasticSearchException esEx = (ElasticSearchException)e.getCause();
            Throwable root = esEx.unwrapCause();
            if (root instanceof ElasticSearchException) {
                return (ElasticSearchException)root;
            }
            return new UncategorizedExecutionException("Failed execution", root);
        }
        return new UncategorizedExecutionException("Failed execution", e);
    }

    @Override
    public void onResponse(L result2) {
        this.set(this.convert(result2));
    }

    @Override
    public void onFailure(Throwable e) {
        this.setException(e);
    }

    protected abstract T convert(L var1);

    @Override
    public Throwable getRootFailure() {
        return this.rootFailure;
    }
}

