/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.controller.ShardDoc;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchCountAction
extends TransportSearchTypeAction {
    private static ShardDoc[] EMPTY_DOCS = new ShardDoc[0];

    @Inject
    public TransportSearchCountAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportSearchCache transportSearchCache, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, transportSearchCache, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<QuerySearchResult> {
        private final Map<SearchShardTarget, QuerySearchResultProvider> queryFetchResults;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(request, listener);
            this.queryFetchResults = TransportSearchCountAction.this.searchCache.obtainQueryResults();
        }

        @Override
        protected String firstPhaseName() {
            return "query";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchRequest request, SearchServiceListener<QuerySearchResult> listener) {
            TransportSearchCountAction.this.searchService.sendExecuteQuery(node, request, listener);
        }

        @Override
        protected void processFirstPhaseResult(ShardRouting shard, QuerySearchResult result2) {
            this.queryFetchResults.put(result2.shardTarget(), result2);
        }

        @Override
        protected void moveToSecondPhase() throws Exception {
            InternalSearchResponse internalResponse = TransportSearchCountAction.this.searchPhaseController.merge(EMPTY_DOCS, this.queryFetchResults, ImmutableMap.of());
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), this.queryFetchResults.values(), null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
            TransportSearchCountAction.this.searchCache.releaseQueryResults(this.queryFetchResults);
        }
    }
}

