/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.facet.Facets;
import org.elasticsearch.search.internal.InternalSearchResponse;

public class SearchResponse
extends ActionResponse
implements ToXContent {
    private InternalSearchResponse internalResponse;
    private String scrollId;
    private int totalShards;
    private int successfulShards;
    private ShardSearchFailure[] shardFailures;
    private long tookInMillis;

    public SearchResponse() {
    }

    public SearchResponse(InternalSearchResponse internalResponse, String scrollId, int totalShards, int successfulShards, long tookInMillis, ShardSearchFailure[] shardFailures) {
        this.internalResponse = internalResponse;
        this.scrollId = scrollId;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.tookInMillis = tookInMillis;
        this.shardFailures = shardFailures;
    }

    public RestStatus status() {
        if (this.shardFailures.length == 0) {
            return RestStatus.OK;
        }
        if (this.successfulShards == 0 && this.totalShards > 0) {
            RestStatus status2 = this.shardFailures[0].status();
            if (this.shardFailures.length > 1) {
                for (int i2 = 1; i2 < this.shardFailures.length; ++i2) {
                    if (this.shardFailures[i2].status().getStatus() < 500) continue;
                    status2 = this.shardFailures[i2].status();
                }
            }
            return status2;
        }
        return RestStatus.OK;
    }

    public SearchHits hits() {
        return this.internalResponse.hits();
    }

    public SearchHits getHits() {
        return this.hits();
    }

    public Facets facets() {
        return this.internalResponse.facets();
    }

    public Facets getFacets() {
        return this.facets();
    }

    public boolean timedOut() {
        return this.internalResponse.timedOut();
    }

    public boolean isTimedOut() {
        return this.timedOut();
    }

    public TimeValue took() {
        return new TimeValue(this.tookInMillis);
    }

    public TimeValue getTook() {
        return this.took();
    }

    public long tookInMillis() {
        return this.tookInMillis;
    }

    public long getTookInMillis() {
        return this.tookInMillis();
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards();
    }

    public ShardSearchFailure[] shardFailures() {
        return this.shardFailures;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardFailures;
    }

    public String scrollId() {
        return this.scrollId;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.scrollId != null) {
            builder.field(Fields._SCROLL_ID, this.scrollId);
        }
        builder.field(Fields.TOOK, this.tookInMillis);
        builder.field(Fields.TIMED_OUT, this.timedOut());
        builder.startObject(Fields._SHARDS);
        builder.field(Fields.TOTAL, this.totalShards());
        builder.field(Fields.SUCCESSFUL, this.successfulShards());
        builder.field(Fields.FAILED, this.failedShards());
        if (this.shardFailures.length > 0) {
            builder.startArray(Fields.FAILURES);
            for (ShardSearchFailure shardFailure : this.shardFailures) {
                builder.startObject();
                if (shardFailure.shard() != null) {
                    builder.field(Fields.INDEX, shardFailure.shard().index());
                    builder.field(Fields.SHARD, shardFailure.shard().shardId());
                }
                builder.field(Fields.STATUS, shardFailure.status().getStatus());
                builder.field(Fields.REASON, shardFailure.reason());
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        this.internalResponse.toXContent(builder, params2);
        return builder;
    }

    public static SearchResponse readSearchResponse(StreamInput in) throws IOException {
        SearchResponse response = new SearchResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.internalResponse = InternalSearchResponse.readInternalSearchResponse(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        int size2 = in.readVInt();
        if (size2 == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size2];
            for (int i2 = 0; i2 < this.shardFailures.length; ++i2) {
                this.shardFailures[i2] = ShardSearchFailure.readShardSearchFailure(in);
            }
        }
        this.scrollId = in.readOptionalString();
        this.tookInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.internalResponse.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        out.writeOptionalString(this.scrollId);
        out.writeVLong(this.tookInMillis);
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    static final class Fields {
        static final XContentBuilderString _SCROLL_ID = new XContentBuilderString("_scroll_id");
        static final XContentBuilderString _SHARDS = new XContentBuilderString("_shards");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString SUCCESSFUL = new XContentBuilderString("successful");
        static final XContentBuilderString FAILED = new XContentBuilderString("failed");
        static final XContentBuilderString FAILURES = new XContentBuilderString("failures");
        static final XContentBuilderString STATUS = new XContentBuilderString("status");
        static final XContentBuilderString INDEX = new XContentBuilderString("index");
        static final XContentBuilderString SHARD = new XContentBuilderString("shard");
        static final XContentBuilderString REASON = new XContentBuilderString("reason");
        static final XContentBuilderString TOOK = new XContentBuilderString("took");
        static final XContentBuilderString TIMED_OUT = new XContentBuilderString("timed_out");

        Fields() {
        }
    }
}

