/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.internal.InternalClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class SearchRequestBuilder
extends ActionRequestBuilder<SearchRequest, SearchResponse, SearchRequestBuilder> {
    private SearchSourceBuilder sourceBuilder;

    public SearchRequestBuilder(Client client) {
        super((InternalClient)client, new SearchRequest());
    }

    public SearchRequestBuilder setIndices(String ... indices2) {
        ((SearchRequest)this.request).indices(indices2);
        return this;
    }

    public SearchRequestBuilder setTypes(String ... types) {
        ((SearchRequest)this.request).types(types);
        return this;
    }

    public SearchRequestBuilder setSearchType(SearchType searchType) {
        ((SearchRequest)this.request).searchType(searchType);
        return this;
    }

    public SearchRequestBuilder setSearchType(String searchType) throws ElasticSearchIllegalArgumentException {
        ((SearchRequest)this.request).searchType(searchType);
        return this;
    }

    public SearchRequestBuilder setScroll(Scroll scroll) {
        ((SearchRequest)this.request).scroll(scroll);
        return this;
    }

    public SearchRequestBuilder setScroll(TimeValue keepAlive) {
        ((SearchRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchRequestBuilder setScroll(String keepAlive) {
        ((SearchRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchRequestBuilder setTimeout(TimeValue timeout2) {
        this.sourceBuilder().timeout(timeout2);
        return this;
    }

    public SearchRequestBuilder setTimeout(String timeout2) {
        this.sourceBuilder().timeout(timeout2);
        return this;
    }

    public SearchRequestBuilder setQueryHint(String queryHint) {
        ((SearchRequest)this.request).queryHint(queryHint);
        return this;
    }

    public SearchRequestBuilder setRouting(String routing) {
        ((SearchRequest)this.request).routing(routing);
        return this;
    }

    public SearchRequestBuilder setRouting(String ... routing) {
        ((SearchRequest)this.request).routing(routing);
        return this;
    }

    public SearchRequestBuilder setPreference(String preference) {
        ((SearchRequest)this.request).preference(preference);
        return this;
    }

    public SearchRequestBuilder setOperationThreading(SearchOperationThreading operationThreading) {
        ((SearchRequest)this.request).operationThreading(operationThreading);
        return this;
    }

    public SearchRequestBuilder setOperationThreading(String operationThreading) {
        ((SearchRequest)this.request).operationThreading(operationThreading);
        return this;
    }

    public SearchRequestBuilder setIgnoreIndices(IgnoreIndices ignoreIndices) {
        this.request().ignoreIndices(ignoreIndices);
        return this;
    }

    public SearchRequestBuilder setQuery(QueryBuilder queryBuilder) {
        this.sourceBuilder().query(queryBuilder);
        return this;
    }

    public SearchRequestBuilder setQuery(String query) {
        this.sourceBuilder().query(query);
        return this;
    }

    public SearchRequestBuilder setQuery(BytesReference queryBinary) {
        this.sourceBuilder().query(queryBinary);
        return this;
    }

    public SearchRequestBuilder setQuery(byte[] queryBinary) {
        this.sourceBuilder().query(queryBinary);
        return this;
    }

    public SearchRequestBuilder setQuery(byte[] queryBinary, int queryBinaryOffset, int queryBinaryLength) {
        this.sourceBuilder().query(queryBinary, queryBinaryOffset, queryBinaryLength);
        return this;
    }

    public SearchRequestBuilder setQuery(XContentBuilder query) {
        this.sourceBuilder().query(query);
        return this;
    }

    public SearchRequestBuilder setQuery(Map query) {
        this.sourceBuilder().query(query);
        return this;
    }

    public SearchRequestBuilder setFilter(FilterBuilder filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setFilter(String filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setFilter(BytesReference filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setFilter(byte[] filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setFilter(byte[] filter, int filterOffset, int filterLength) {
        this.sourceBuilder().filter(filter, filterOffset, filterLength);
        return this;
    }

    public SearchRequestBuilder setFilter(XContentBuilder filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setFilter(Map filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setMinScore(float minScore) {
        this.sourceBuilder().minScore(minScore);
        return this;
    }

    public SearchRequestBuilder setFrom(int from) {
        this.sourceBuilder().from(from);
        return this;
    }

    public SearchRequestBuilder setSize(int size2) {
        this.sourceBuilder().size(size2);
        return this;
    }

    public SearchRequestBuilder setExplain(boolean explain) {
        this.sourceBuilder().explain(explain);
        return this;
    }

    public SearchRequestBuilder setVersion(boolean version) {
        this.sourceBuilder().version(version);
        return this;
    }

    public SearchRequestBuilder addIndexBoost(String index2, float indexBoost) {
        this.sourceBuilder().indexBoost(index2, indexBoost);
        return this;
    }

    public SearchRequestBuilder setStats(String ... statsGroups) {
        this.sourceBuilder().stats(statsGroups);
        return this;
    }

    public SearchRequestBuilder setNoFields() {
        this.sourceBuilder().noFields();
        return this;
    }

    public SearchRequestBuilder addField(String field2) {
        this.sourceBuilder().field(field2);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name2, String script) {
        this.sourceBuilder().scriptField(name2, script);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name2, String script, Map<String, Object> params2) {
        this.sourceBuilder().scriptField(name2, script, params2);
        return this;
    }

    public SearchRequestBuilder addPartialField(String name2, @Nullable String include2, @Nullable String exclude) {
        this.sourceBuilder().partialField(name2, include2, exclude);
        return this;
    }

    public SearchRequestBuilder addPartialField(String name2, @Nullable String[] includes, @Nullable String[] excludes) {
        this.sourceBuilder().partialField(name2, includes, excludes);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name2, String lang, String script, Map<String, Object> params2) {
        this.sourceBuilder().scriptField(name2, lang, script, params2);
        return this;
    }

    public SearchRequestBuilder addSort(String field2, SortOrder order2) {
        this.sourceBuilder().sort(field2, order2);
        return this;
    }

    public SearchRequestBuilder addSort(SortBuilder sort2) {
        this.sourceBuilder().sort(sort2);
        return this;
    }

    public SearchRequestBuilder setTrackScores(boolean trackScores) {
        this.sourceBuilder().trackScores(trackScores);
        return this;
    }

    public SearchRequestBuilder addFields(String ... fields2) {
        this.sourceBuilder().fields(fields2);
        return this;
    }

    public SearchRequestBuilder addFacet(AbstractFacetBuilder facet) {
        this.sourceBuilder().facet(facet);
        return this;
    }

    public SearchRequestBuilder setFacets(BytesReference facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder setFacets(byte[] facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder setFacets(byte[] facets, int facetsOffset, int facetsLength) {
        this.sourceBuilder().facets(facets, facetsOffset, facetsLength);
        return this;
    }

    public SearchRequestBuilder setFacets(XContentBuilder facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder setFacets(Map facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name2) {
        this.highlightBuilder().field(name2);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name2, int fragmentSize) {
        this.highlightBuilder().field(name2, fragmentSize);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name2, int fragmentSize, int numberOfFragments) {
        this.highlightBuilder().field(name2, fragmentSize, numberOfFragments);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name2, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        this.highlightBuilder().field(name2, fragmentSize, numberOfFragments, fragmentOffset);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(HighlightBuilder.Field field2) {
        this.highlightBuilder().field(field2);
        return this;
    }

    public SearchRequestBuilder setHighlighterTagsSchema(String schemaName) {
        this.highlightBuilder().tagsSchema(schemaName);
        return this;
    }

    public SearchRequestBuilder setHighlighterPreTags(String ... preTags) {
        this.highlightBuilder().preTags(preTags);
        return this;
    }

    public SearchRequestBuilder setHighlighterPostTags(String ... postTags) {
        this.highlightBuilder().postTags(postTags);
        return this;
    }

    public SearchRequestBuilder setHighlighterOrder(String order2) {
        this.highlightBuilder().order(order2);
        return this;
    }

    public SearchRequestBuilder setHighlighterEncoder(String encoder) {
        this.highlightBuilder().encoder(encoder);
        return this;
    }

    public SearchRequestBuilder setHighlighterRequireFieldMatch(boolean requireFieldMatch) {
        this.highlightBuilder().requireFieldMatch(requireFieldMatch);
        return this;
    }

    public SearchRequestBuilder setHighlighterType(String type2) {
        this.highlightBuilder().highlighterType(type2);
        return this;
    }

    public SearchRequestBuilder setSource(String source2) {
        ((SearchRequest)this.request).source(source2);
        return this;
    }

    public SearchRequestBuilder setExtraSource(String source2) {
        ((SearchRequest)this.request).extraSource(source2);
        return this;
    }

    public SearchRequestBuilder setSource(BytesReference source2) {
        ((SearchRequest)this.request).source(source2, false);
        return this;
    }

    public SearchRequestBuilder setSource(BytesReference source2, boolean unsafe) {
        ((SearchRequest)this.request).source(source2, unsafe);
        return this;
    }

    public SearchRequestBuilder setSource(byte[] source2) {
        ((SearchRequest)this.request).source(source2);
        return this;
    }

    public SearchRequestBuilder setExtraSource(BytesReference source2) {
        ((SearchRequest)this.request).extraSource(source2, false);
        return this;
    }

    public SearchRequestBuilder setExtraSource(BytesReference source2, boolean unsafe) {
        ((SearchRequest)this.request).extraSource(source2, unsafe);
        return this;
    }

    public SearchRequestBuilder setExtraSource(byte[] source2) {
        ((SearchRequest)this.request).extraSource(source2);
        return this;
    }

    public SearchRequestBuilder setSource(byte[] source2, int offset2, int length2) {
        ((SearchRequest)this.request).source(source2, offset2, length2);
        return this;
    }

    public SearchRequestBuilder setExtraSource(byte[] source2, int offset2, int length2) {
        ((SearchRequest)this.request).extraSource(source2, offset2, length2);
        return this;
    }

    public SearchRequestBuilder setSource(XContentBuilder builder) {
        ((SearchRequest)this.request).source(builder);
        return this;
    }

    public SearchRequestBuilder setExtraSource(XContentBuilder builder) {
        ((SearchRequest)this.request).extraSource(builder);
        return this;
    }

    public SearchRequestBuilder setSource(Map source2) {
        ((SearchRequest)this.request).source(source2);
        return this;
    }

    public SearchRequestBuilder setExtraSource(Map source2) {
        ((SearchRequest)this.request).extraSource(source2);
        return this;
    }

    public SearchRequestBuilder internalBuilder(SearchSourceBuilder sourceBuilder) {
        this.sourceBuilder = sourceBuilder;
        return this;
    }

    public SearchSourceBuilder internalBuilder() {
        return this.sourceBuilder();
    }

    public String toString() {
        return this.internalBuilder().toString();
    }

    @Override
    public SearchRequest request() {
        if (this.sourceBuilder != null) {
            ((SearchRequest)this.request).source(this.sourceBuilder());
        }
        return (SearchRequest)this.request;
    }

    @Override
    protected void doExecute(ActionListener<SearchResponse> listener) {
        if (this.sourceBuilder != null) {
            ((SearchRequest)this.request).source(this.sourceBuilder());
        }
        ((Client)((Object)this.client)).search((SearchRequest)this.request, listener);
    }

    private SearchSourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new SearchSourceBuilder();
        }
        return this.sourceBuilder;
    }

    private HighlightBuilder highlightBuilder() {
        return this.sourceBuilder().highlighter();
    }
}

