/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchRequest
extends ActionRequest<SearchRequest> {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private SearchType searchType = SearchType.DEFAULT;
    private String[] indices;
    @Nullable
    private String queryHint;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private BytesReference source;
    private boolean sourceUnsafe;
    private BytesReference extraSource;
    private boolean extraSourceUnsafe;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private SearchOperationThreading operationThreading = SearchOperationThreading.THREAD_PER_SHARD;
    private IgnoreIndices ignoreIndices = IgnoreIndices.DEFAULT;

    public SearchRequest() {
    }

    public SearchRequest(String ... indices2) {
        this.indices = indices2;
    }

    public SearchRequest(String[] indices2, byte[] source2) {
        this.indices = indices2;
        this.source = new BytesArray(source2);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        return validationException;
    }

    public void beforeStart() {
        if (this.source != null && this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
            this.sourceUnsafe = false;
        }
        if (this.extraSource != null && this.extraSourceUnsafe) {
            this.extraSource = this.extraSource.copyBytesArray();
            this.extraSourceUnsafe = false;
        }
    }

    public void beforeLocalFork() {
    }

    public SearchRequest indices(String ... indices2) {
        this.indices = indices2;
        return this;
    }

    public SearchOperationThreading operationThreading() {
        return this.operationThreading;
    }

    public SearchRequest operationThreading(SearchOperationThreading operationThreading) {
        this.operationThreading = operationThreading;
        return this;
    }

    public SearchRequest operationThreading(String operationThreading) {
        return this.operationThreading(SearchOperationThreading.fromString(operationThreading, this.operationThreading));
    }

    public IgnoreIndices ignoreIndices() {
        return this.ignoreIndices;
    }

    public SearchRequest ignoreIndices(IgnoreIndices ignoreIndices) {
        this.ignoreIndices = ignoreIndices;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public SearchRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SearchRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SearchRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public SearchRequest searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public SearchRequest searchType(String searchType) throws ElasticSearchIllegalArgumentException {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchRequest source(SearchSourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(contentType);
        this.sourceUnsafe = false;
        return this;
    }

    public SearchRequest source(String source2) {
        this.source = new BytesArray(source2);
        this.sourceUnsafe = false;
        return this;
    }

    public SearchRequest source(Map source2) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source2);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source2 + "]", e);
        }
    }

    public SearchRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        this.sourceUnsafe = false;
        return this;
    }

    public SearchRequest source(byte[] source2) {
        return this.source(source2, 0, source2.length, false);
    }

    public SearchRequest source(byte[] source2, int offset2, int length2) {
        return this.source(source2, offset2, length2, false);
    }

    public SearchRequest source(byte[] source2, int offset2, int length2, boolean unsafe) {
        return this.source(new BytesArray(source2, offset2, length2), unsafe);
    }

    public SearchRequest source(BytesReference source2, boolean unsafe) {
        this.source = source2;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public SearchRequest extraSource(SearchSourceBuilder sourceBuilder) {
        if (sourceBuilder == null) {
            this.extraSource = null;
            return this;
        }
        this.extraSource = sourceBuilder.buildAsBytes(contentType);
        this.extraSourceUnsafe = false;
        return this;
    }

    public SearchRequest extraSource(Map extraSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(extraSource);
            return this.extraSource(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + this.source + "]", e);
        }
    }

    public SearchRequest extraSource(XContentBuilder builder) {
        this.extraSource = builder.bytes();
        this.extraSourceUnsafe = false;
        return this;
    }

    public SearchRequest extraSource(String source2) {
        this.extraSource = new BytesArray(source2);
        this.extraSourceUnsafe = false;
        return this;
    }

    public SearchRequest extraSource(byte[] source2) {
        return this.extraSource(source2, 0, source2.length, false);
    }

    public SearchRequest extraSource(byte[] source2, int offset2, int length2) {
        return this.extraSource(source2, offset2, length2, false);
    }

    public SearchRequest extraSource(byte[] source2, int offset2, int length2, boolean unsafe) {
        return this.extraSource(new BytesArray(source2, offset2, length2), unsafe);
    }

    public SearchRequest extraSource(BytesReference source2, boolean unsafe) {
        this.extraSource = source2;
        this.extraSourceUnsafe = unsafe;
        return this;
    }

    public BytesReference extraSource() {
        return this.extraSource;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public String[] indices() {
        return this.indices;
    }

    public SearchRequest queryHint(String queryHint) {
        this.queryHint = queryHint;
        return this;
    }

    public String queryHint() {
        return this.queryHint;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue(keepAlive, null)));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.operationThreading = SearchOperationThreading.fromId(in.readByte());
        this.searchType = SearchType.fromId(in.readByte());
        this.indices = new String[in.readVInt()];
        for (int i2 = 0; i2 < this.indices.length; ++i2) {
            this.indices[i2] = in.readString();
        }
        this.queryHint = in.readOptionalString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        this.sourceUnsafe = false;
        this.source = in.readBytesReference();
        this.extraSourceUnsafe = false;
        this.extraSource = in.readBytesReference();
        this.types = in.readStringArray();
        this.ignoreIndices = IgnoreIndices.fromId(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.operationThreading.id());
        out.writeByte(this.searchType.id());
        out.writeVInt(this.indices.length);
        for (String index2 : this.indices) {
            out.writeString(index2);
        }
        out.writeOptionalString(this.queryHint);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.extraSource);
        out.writeStringArray(this.types);
        out.writeByte(this.ignoreIndices.id());
    }
}

