/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;

public enum SearchOperationThreading {
    NO_THREADS(0),
    SINGLE_THREAD(1),
    THREAD_PER_SHARD(2);

    private final byte id;

    private SearchOperationThreading(byte id2) {
        this.id = id2;
    }

    public byte id() {
        return this.id;
    }

    public static SearchOperationThreading fromId(byte id2) {
        if (id2 == 0) {
            return NO_THREADS;
        }
        if (id2 == 1) {
            return SINGLE_THREAD;
        }
        if (id2 == 2) {
            return THREAD_PER_SHARD;
        }
        throw new ElasticSearchIllegalArgumentException("No type matching id [" + id2 + "]");
    }

    public static SearchOperationThreading fromString(String value2, @Nullable SearchOperationThreading defaultValue) {
        if (value2 == null) {
            return defaultValue;
        }
        if ("no_threads".equals(value2) || "noThreads".equals(value2)) {
            return NO_THREADS;
        }
        if ("single_thread".equals(value2) || "singleThread".equals(value2)) {
            return SINGLE_THREAD;
        }
        if ("thread_per_shard".equals(value2) || "threadPerShard".equals(value2)) {
            return THREAD_PER_SHARD;
        }
        throw new ElasticSearchIllegalArgumentException("No value for search operation threading matching [" + value2 + "]");
    }
}

