/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.MultiGetShardRequest;
import org.elasticsearch.action.get.MultiGetShardResponse;
import org.elasticsearch.action.support.single.shard.TransportShardSingleOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardMultiGetAction
extends TransportShardSingleOperationAction<MultiGetShardRequest, MultiGetShardResponse> {
    private final IndicesService indicesService;
    private final boolean realtime;

    @Inject
    public TransportShardMultiGetAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
        this.realtime = settings.getAsBoolean("action.get.realtime", true);
    }

    @Override
    protected String executor() {
        return "get";
    }

    @Override
    protected String transportAction() {
        return "mget/shard";
    }

    @Override
    protected MultiGetShardRequest newRequest() {
        return new MultiGetShardRequest();
    }

    @Override
    protected MultiGetShardResponse newResponse() {
        return new MultiGetShardResponse();
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state2, MultiGetShardRequest request) {
        return state2.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state2, MultiGetShardRequest request) {
        return state2.blocks().indexBlockedException(ClusterBlockLevel.READ, request.index());
    }

    @Override
    protected ShardIterator shards(ClusterState state2, MultiGetShardRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.index(), request.shardId(), request.preference());
    }

    @Override
    protected void resolveRequest(ClusterState state2, MultiGetShardRequest request) {
        if (request.realtime == null) {
            request.realtime = this.realtime;
        }
    }

    @Override
    protected MultiGetShardResponse shardOperation(MultiGetShardRequest request, int shardId) throws ElasticSearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(shardId);
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh(new Engine.Refresh(false));
        }
        MultiGetShardResponse response = new MultiGetShardResponse();
        for (int i2 = 0; i2 < request.locations.size(); ++i2) {
            String type2 = request.types.get(i2);
            String id2 = request.ids.get(i2);
            String[] fields2 = request.fields.get(i2);
            try {
                GetResult getResult = indexShard.getService().get(type2, id2, fields2, request.realtime());
                response.add(request.locations.get(i2), new GetResponse(getResult));
                continue;
            }
            catch (Exception e) {
                this.logger.debug("[{}][{}] failed to execute multi_get for [{}]/[{}]", e, request.index(), shardId, type2, id2);
                response.add(request.locations.get(i2), new MultiGetResponse.Failure(request.index(), type2, id2, ExceptionsHelper.detailedMessage(e)));
            }
        }
        return response;
    }
}

