/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.list.array.TIntArrayList;

public class MultiGetShardRequest
extends SingleShardOperationRequest<MultiGetShardRequest> {
    private int shardId;
    private String preference;
    Boolean realtime;
    boolean refresh;
    TIntArrayList locations;
    List<String> types;
    List<String> ids;
    List<String[]> fields;

    MultiGetShardRequest() {
    }

    MultiGetShardRequest(String index2, int shardId) {
        super(index2);
        this.shardId = shardId;
        this.locations = new TIntArrayList();
        this.types = new ArrayList<String>();
        this.ids = new ArrayList<String>();
        this.fields = new ArrayList<String[]>();
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiGetShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public MultiGetShardRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetShardRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public void add(int location, @Nullable String type2, String id2, String[] fields2) {
        this.locations.add(location);
        this.types.add(type2);
        this.ids.add(id2);
        this.fields.add(fields2);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size2 = in.readVInt();
        this.locations = new TIntArrayList(size2);
        this.types = new ArrayList<String>(size2);
        this.ids = new ArrayList<String>(size2);
        this.fields = new ArrayList<String[]>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.types.add(in.readString());
            } else {
                this.types.add(null);
            }
            this.ids.add(in.readString());
            int size1 = in.readVInt();
            if (size1 > 0) {
                String[] fields2 = new String[size1];
                for (int j = 0; j < size1; ++j) {
                    fields2[j] = in.readString();
                }
                this.fields.add(fields2);
                continue;
            }
            this.fields.add(null);
        }
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        byte realtime = in.readByte();
        if (realtime == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.types.size());
        for (int i2 = 0; i2 < this.types.size(); ++i2) {
            out.writeVInt(this.locations.get(i2));
            if (this.types.get(i2) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.types.get(i2));
            }
            out.writeString(this.ids.get(i2));
            if (this.fields.get(i2) == null) {
                out.writeVInt(0);
                continue;
            }
            out.writeVInt(this.fields.get(i2).length);
            for (String field2 : this.fields.get(i2)) {
                out.writeString(field2);
            }
        }
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
    }
}

