/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.explain.ExplainSourceBuilder;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;

public class ExplainRequest
extends SingleShardOperationRequest<ExplainRequest> {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private String type = "_all";
    private String id;
    private String routing;
    private String preference;
    private BytesReference source;
    private String[] fields;
    private boolean sourceUnsafe;
    private String[] filteringAlias = Strings.EMPTY_ARRAY;

    ExplainRequest() {
    }

    public ExplainRequest(String index2, String type2, String id2) {
        this.index = index2;
        this.type = type2;
        this.id = id2;
    }

    public String type() {
        return this.type;
    }

    public ExplainRequest type(String type2) {
        this.type = type2;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ExplainRequest id(String id2) {
        this.id = id2;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public ExplainRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public ExplainRequest parent(String parent) {
        this.routing = parent;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public ExplainRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public boolean sourceUnsafe() {
        return this.sourceUnsafe;
    }

    public ExplainRequest source(ExplainSourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(contentType);
        this.sourceUnsafe = false;
        return this;
    }

    public ExplainRequest source(BytesReference source2, boolean unsafe) {
        this.source = source2;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public ExplainRequest fields(String[] fields2) {
        this.fields = fields2;
        return this;
    }

    public String[] filteringAlias() {
        return this.filteringAlias;
    }

    public void filteringAlias(String[] filteringAlias) {
        if (filteringAlias == null) {
            return;
        }
        this.filteringAlias = filteringAlias;
    }

    @Override
    protected void beforeLocalFork() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
            this.sourceUnsafe = false;
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.source = in.readBytesReference();
        this.sourceUnsafe = false;
        this.filteringAlias = in.readStringArray();
        if (in.readBoolean()) {
            this.fields = in.readStringArray();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBytesReference(this.source);
        out.writeStringArray(this.filteringAlias);
        if (this.fields != null) {
            out.writeBoolean(true);
            out.writeStringArray(this.fields);
        } else {
            out.writeBoolean(false);
        }
    }
}

